/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.impl;

import io.fabric8.kubernetes.api.model.APIResourceList;
import io.fabric8.kubernetes.api.model.APIResourceListBuilder;
import io.fabric8.kubernetes.api.model.APIResourceListFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.networking.v1.Ingress;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.dsl.internal.OperationSupport;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.impl.BaseClient;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.MockedConstruction;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class BaseClientTest {
    private HttpClient httpClient;
    private BaseClient baseClient;

    BaseClientTest() {
    }

    @BeforeEach
    void setUp() {
        this.httpClient = (HttpClient)Mockito.mock(HttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.baseClient = new BaseClient(this.httpClient, Config.empty(), () -> Runnable::run){

            BaseClient newInstance(Config config) {
                return BaseClientTest.this.baseClient;
            }

            public Client newClient(RequestConfig requestConfig) {
                return BaseClientTest.this.baseClient;
            }
        };
    }

    @Test
    @DisplayName(value="supports, with matchingGroupPredicate function, should evaluate function")
    void supportsWithMatchingGroupPredicate() {
        AtomicBoolean called = new AtomicBoolean(false);
        this.baseClient.setMatchingGroupPredicate(s -> {
            called.set(true);
            return true;
        });
        boolean result = this.baseClient.supports(Pod.class);
        Assertions.assertThat((AtomicBoolean)called).isTrue();
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    @DisplayName(value="supports Pod, with no support in server, should check API server and return false")
    void supportsPodNotInServer() {
        try (MockedConstruction ignore = Mockito.mockConstruction(OperationSupport.class, (mock, ctx) -> Mockito.when((Object)mock.restCall(APIResourceList.class, new String[]{"api", "v1"})).thenReturn((Object)new APIResourceListBuilder().build()));){
            boolean result = this.baseClient.supports(Pod.class);
            Assertions.assertThat((boolean)result).isFalse();
        }
    }

    @Test
    @DisplayName(value="supports Pod, with support in server, should check API server and return true")
    void supportsPodInServer() {
        try (MockedConstruction ignore = Mockito.mockConstruction(OperationSupport.class, (mock, ctx) -> Mockito.when((Object)mock.restCall(APIResourceList.class, new String[]{"api", "v1"})).thenReturn((Object)((APIResourceListBuilder)((APIResourceListFluent.ResourcesNested)new APIResourceListBuilder().addNewResource().withKind("Pod")).endResource()).build()));){
            boolean result = this.baseClient.supports(Pod.class);
            Assertions.assertThat((boolean)result).isTrue();
        }
    }

    @Test
    @DisplayName(value="supports Ingress, with no group+version registered in server, should check API server and return false")
    void supportsNetworkingApiNotFound() {
        try (MockedConstruction ignore = Mockito.mockConstruction(OperationSupport.class, (mock, ctx) -> Mockito.when((Object)mock.restCall(APIResourceList.class, new String[]{"/apis", "networking.k8s.io/v1"})).thenReturn(null));){
            boolean result = this.baseClient.supports(Ingress.class);
            Assertions.assertThat((boolean)result).isFalse();
        }
    }

    @Test
    @DisplayName(value="supports Ingress, with support in server, should check API server and return true")
    void supportsIngressInServer() {
        try (MockedConstruction ignore = Mockito.mockConstruction(OperationSupport.class, (mock, ctx) -> Mockito.when((Object)mock.restCall(APIResourceList.class, new String[]{"/apis", "networking.k8s.io/v1"})).thenReturn((Object)((APIResourceListBuilder)((APIResourceListFluent.ResourcesNested)new APIResourceListBuilder().addNewResource().withKind("Ingress")).endResource()).build()));){
            boolean result = this.baseClient.supports(Ingress.class);
            Assertions.assertThat((boolean)result).isTrue();
        }
    }
}

