/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.DeleteOptions;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Preconditions;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v1.Scale;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.base.PatchContext;
import io.fabric8.kubernetes.client.dsl.base.PatchType;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PatchUtils;
import io.fabric8.kubernetes.client.dsl.internal.VersionUsageUtils;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.client.utils.internal.ExponentialBackoffIntervalCalculator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSupport {
    public static final String JSON = "application/json";
    public static final String JSON_PATCH = "application/json-patch+json";
    public static final String STRATEGIC_MERGE_JSON_PATCH = "application/strategic-merge-patch+json";
    public static final String JSON_MERGE_PATCH = "application/merge-patch+json";
    protected static final ObjectMapper JSON_MAPPER = Serialization.jsonMapper();
    private static final Logger LOG = LoggerFactory.getLogger(OperationSupport.class);
    private static final String CLIENT_STATUS_FLAG = "CLIENT_STATUS_FLAG";
    private static final int MAX_RETRY_INTERVAL_EXPONENT = 5;
    protected OperationContext context;
    protected final HttpClient httpClient;
    protected final Config config;
    protected final String resourceT;
    protected String namespace;
    protected String name;
    protected String apiGroupName;
    protected String apiGroupVersion;
    protected boolean dryRun;
    private final int requestRetryBackoffLimit;
    private final int requestRetryBackoffInterval;

    public OperationSupport(Client client) {
        this(new OperationContext().withClient(client));
    }

    public OperationSupport(OperationContext ctx) {
        this.context = ctx;
        this.httpClient = ctx.getHttpClient();
        this.config = ctx.getConfig();
        this.resourceT = ctx.getPlural();
        this.namespace = ctx.getNamespace();
        this.name = ctx.getName();
        this.apiGroupName = ctx.getApiGroupName();
        this.dryRun = ctx.getDryRun();
        this.apiGroupVersion = Utils.isNotNullOrEmpty(ctx.getApiGroupVersion()) ? ctx.getApiGroupVersion() : (ctx.getConfig() != null && Utils.isNotNullOrEmpty(ctx.getConfig().getApiVersion()) ? ctx.getConfig().getApiVersion() : "v1");
        if (ctx.getConfig() != null) {
            this.requestRetryBackoffInterval = ctx.getConfig().getRequestRetryBackoffInterval();
            this.requestRetryBackoffLimit = ctx.getConfig().getRequestRetryBackoffLimit();
        } else {
            this.requestRetryBackoffInterval = Config.DEFAULT_REQUEST_RETRY_BACKOFFINTERVAL;
            this.requestRetryBackoffLimit = Config.DEFAULT_REQUEST_RETRY_BACKOFFLIMIT;
        }
    }

    public String getAPIGroupName() {
        return this.apiGroupName;
    }

    public String getAPIGroupVersion() {
        return this.apiGroupVersion;
    }

    public String getResourceT() {
        return this.resourceT;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public boolean isResourceNamespaced() {
        return true;
    }

    protected List<String> getRootUrlParts() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.config.getMasterUrl());
        if (!Utils.isNullOrEmpty(this.apiGroupName)) {
            result.add("apis");
            result.add(this.apiGroupName);
            result.add(this.apiGroupVersion);
        } else {
            result.add("api");
            result.add(this.apiGroupVersion);
        }
        return result;
    }

    protected URL getNamespacedUrl(String namespace, String type) throws MalformedURLException {
        List<String> parts = this.getRootUrlParts();
        this.addNamespacedUrlPathParts(parts, namespace, type);
        URL requestUrl = new URL(URLUtils.join(parts.toArray(new String[parts.size()])));
        return requestUrl;
    }

    public URL getNamespacedUrl(String namespace) throws MalformedURLException {
        return this.getNamespacedUrl(namespace, this.resourceT);
    }

    protected void addNamespacedUrlPathParts(List<String> parts, String namespace, String type) {
        if (this.isResourceNamespaced() && Utils.isNotNullOrEmpty(namespace)) {
            parts.add("namespaces");
            parts.add(namespace);
        }
        parts.add(type);
    }

    public URL getNamespacedUrl() throws MalformedURLException {
        return this.getNamespacedUrl(this.getNamespace());
    }

    public URL getResourceUrl(String namespace, String name) throws MalformedURLException {
        return this.getResourceUrl(namespace, name, false);
    }

    public URL getResourceUrl(String namespace, String name, boolean status) throws MalformedURLException {
        if (name == null) {
            if (status) {
                throw new KubernetesClientException("name not specified for an operation requiring one.");
            }
            return this.getNamespacedUrl(namespace);
        }
        if (status) {
            return new URL(URLUtils.join(this.getNamespacedUrl(namespace).toString(), name, "status"));
        }
        return new URL(URLUtils.join(this.getNamespacedUrl(namespace).toString(), name));
    }

    public URL getResourceUrl() throws MalformedURLException {
        if (this.name == null) {
            return this.getNamespacedUrl();
        }
        return new URL(URLUtils.join(this.getNamespacedUrl().toString(), this.name));
    }

    public URL getResourceURLForWriteOperation(URL resourceURL) throws MalformedURLException {
        if (this.dryRun) {
            return new URL(URLUtils.join(resourceURL.toString(), "?dryRun=All"));
        }
        return resourceURL;
    }

    public URL getResourceURLForPatchOperation(URL resourceUrl, PatchContext patchContext) throws MalformedURLException {
        if (patchContext != null) {
            String fieldManager;
            String url = resourceUrl.toString();
            if (patchContext.getForce() != null) {
                url = URLUtils.join(url, "?force=" + patchContext.getForce());
            }
            if (patchContext.getDryRun() != null && !patchContext.getDryRun().isEmpty() || this.dryRun) {
                url = URLUtils.join(url, "?dryRun=All");
            }
            if ((fieldManager = patchContext.getFieldManager()) == null && patchContext.getPatchType() == PatchType.SERVER_SIDE_APPLY) {
                fieldManager = "fabric8";
            }
            if (fieldManager != null) {
                url = URLUtils.join(url, "?fieldManager=" + fieldManager);
            }
            if (patchContext.getFieldValidation() != null) {
                url = URLUtils.join(url, "?fieldValidation=" + patchContext.getFieldValidation());
            }
            return new URL(url);
        }
        return resourceUrl;
    }

    protected <T> T correctNamespace(T item) {
        if (!this.isResourceNamespaced() || this.context.isDefaultNamespace() || !(item instanceof HasMetadata)) {
            return item;
        }
        String itemNs = KubernetesResourceUtil.getNamespace((HasMetadata)item);
        if (Utils.isNotNullOrEmpty(this.namespace) && Utils.isNotNullOrEmpty(itemNs) && !this.namespace.equals(itemNs)) {
            item = Serialization.clone(item);
            KubernetesResourceUtil.setNamespace((HasMetadata)item, this.namespace);
        }
        return item;
    }

    protected <T> String checkNamespace(T item) {
        String itemNs;
        if (!this.isResourceNamespaced()) {
            return null;
        }
        String operationNs = this.getNamespace();
        String string = itemNs = item instanceof HasMetadata ? KubernetesResourceUtil.getNamespace((HasMetadata)item) : null;
        if (Utils.isNullOrEmpty(operationNs) && Utils.isNullOrEmpty(itemNs)) {
            if (this.context.isDefaultNamespace()) {
                throw new KubernetesClientException("namespace not specified for an operation requiring one and no default was found in the Config.");
            }
            throw new KubernetesClientException("namespace not specified for an operation requiring one.");
        }
        if (!Utils.isNullOrEmpty(itemNs) && (Utils.isNullOrEmpty(operationNs) || this.context.isDefaultNamespace())) {
            return itemNs;
        }
        return operationNs;
    }

    protected <T> String checkName(T item) {
        String itemName;
        String operationName = this.getName();
        ObjectMeta metadata = item instanceof HasMetadata ? ((HasMetadata)item).getMetadata() : null;
        String string = itemName = metadata != null ? metadata.getName() : null;
        if (Utils.isNullOrEmpty(operationName) && Utils.isNullOrEmpty(itemName)) {
            return null;
        }
        if (Utils.isNullOrEmpty(itemName)) {
            return operationName;
        }
        if (Utils.isNullOrEmpty(operationName)) {
            return itemName;
        }
        if (Objects.equals(itemName, operationName)) {
            return itemName;
        }
        throw new KubernetesClientException("Name mismatch. Item name:" + itemName + ". Operation name:" + operationName + ".");
    }

    protected <T> T handleMetric(String resourceUrl, Class<T> type) throws InterruptedException, IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().uri(resourceUrl);
        return this.handleResponse(requestBuilder, type);
    }

    protected KubernetesResource handleDelete(URL requestUrl, long gracePeriodSeconds, DeletionPropagation propagationPolicy, String resourceVersion) throws InterruptedException, IOException {
        DeleteOptions deleteOptions = new DeleteOptions();
        if (gracePeriodSeconds >= 0L) {
            deleteOptions.setGracePeriodSeconds(Long.valueOf(gracePeriodSeconds));
        }
        if (resourceVersion != null) {
            deleteOptions.setPreconditions(new Preconditions(resourceVersion, null));
        }
        if (propagationPolicy != null) {
            deleteOptions.setPropagationPolicy(propagationPolicy.toString());
        }
        if (this.dryRun) {
            deleteOptions.setDryRun(Collections.singletonList("All"));
        }
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().delete(JSON, JSON_MAPPER.writeValueAsString((Object)deleteOptions)).url(requestUrl);
        return this.handleResponse(requestBuilder, KubernetesResource.class);
    }

    protected <T, I> T handleCreate(I resource, Class<T> outputType) throws InterruptedException, IOException {
        resource = this.correctNamespace(resource);
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().post(JSON, JSON_MAPPER.writeValueAsString(resource)).url(this.getResourceURLForWriteOperation(this.getResourceUrl(this.checkNamespace(resource), null)));
        return this.handleResponse(requestBuilder, outputType);
    }

    protected <T> T handleUpdate(T updated, Class<T> type, boolean status) throws IOException {
        updated = this.correctNamespace(updated);
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().put(JSON, JSON_MAPPER.writeValueAsString(updated)).url(this.getResourceURLForWriteOperation(this.getResourceUrl(this.checkNamespace(updated), this.checkName(updated), status)));
        return this.handleResponse(requestBuilder, type, this.getParameters());
    }

    protected <T> T handlePatch(PatchContext patchContext, T current, T updated, Class<T> type, boolean status) throws InterruptedException, IOException {
        String patchForUpdate;
        if (current != null && (patchContext == null || patchContext.getPatchType() == PatchType.JSON)) {
            patchForUpdate = PatchUtils.jsonDiff(current, updated, false);
            if (patchContext == null) {
                patchContext = new PatchContext.Builder().withPatchType(PatchType.JSON).build();
            }
        } else {
            ObjectMeta meta;
            if (patchContext != null && patchContext.getPatchType() == PatchType.SERVER_SIDE_APPLY && updated instanceof HasMetadata && (meta = ((HasMetadata)updated).getMetadata()) != null && meta.getManagedFields() != null && !meta.getManagedFields().isEmpty()) {
                meta.setManagedFields(null);
            }
            patchForUpdate = Serialization.asJson(updated);
            current = updated;
        }
        return this.handlePatch(patchContext, current, patchForUpdate, type, status);
    }

    protected <T> T handlePatch(PatchContext patchContext, T current, String patchForUpdate, Class<T> type, boolean status) throws InterruptedException, IOException {
        String bodyContentType = this.getContentTypeFromPatchContextOrDefault(patchContext);
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().patch(bodyContentType, patchForUpdate).url(this.getResourceURLForPatchOperation(this.getResourceUrl(this.checkNamespace(current), this.checkName(current), status), patchContext));
        return this.handleResponse(requestBuilder, type);
    }

    protected Scale handleScale(String resourceUrl, Scale scale) throws InterruptedException, IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().uri(resourceUrl + "/scale");
        if (scale != null) {
            requestBuilder.put(JSON, JSON_MAPPER.writeValueAsString((Object)scale));
        }
        return this.handleResponse(requestBuilder, Scale.class);
    }

    protected Status handleDeploymentRollback(String resourceUrl, DeploymentRollback deploymentRollback) throws InterruptedException, IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().uri(resourceUrl + "/rollback").post(JSON, JSON_MAPPER.writeValueAsString((Object)deploymentRollback));
        return this.handleResponse(requestBuilder, Status.class);
    }

    protected <T> T handleGet(URL resourceUrl, Class<T> type) throws InterruptedException, IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().url(resourceUrl);
        return this.handleResponse(requestBuilder, type, this.getParameters());
    }

    protected Map<String, String> getParameters() {
        return Collections.emptyMap();
    }

    protected <T extends HasMetadata> T handleApproveOrDeny(T csr, Class<T> type) throws IOException, InterruptedException {
        String uri = URLUtils.join(this.getResourceUrl(null, csr.getMetadata().getName(), false).toString(), "approval");
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().put(JSON, JSON_MAPPER.writeValueAsString(csr)).uri(uri);
        return (T)((HasMetadata)this.handleResponse(requestBuilder, type));
    }

    protected <T> T handleRawGet(URL resourceUrl, Class<T> type) throws IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().url(resourceUrl);
        HttpRequest request = requestBuilder.build();
        HttpResponse<T> response = this.waitForResult(this.httpClient.sendAsync(request, type));
        this.assertResponseCode(request, response);
        return response.body();
    }

    protected <T> T waitForResult(CompletableFuture<T> future) throws IOException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            InterruptedIOException ie = new InterruptedIOException();
            ie.initCause(e);
            throw ie;
        }
        catch (ExecutionException e) {
            Throwable t = e;
            if (e.getCause() != null) {
                t = e.getCause();
            }
            if (t instanceof IOException) {
                throw new IOException(t.getMessage(), t);
            }
            if (t instanceof KubernetesClientException) {
                throw ((KubernetesClientException)t).copyAsCause();
            }
            throw new KubernetesClientException(t.getMessage(), t);
        }
    }

    protected <T> T handleResponse(HttpRequest.Builder requestBuilder, Class<T> type) throws InterruptedException, IOException {
        return this.handleResponse(requestBuilder, type, this.getParameters());
    }

    private <T> T handleResponse(HttpRequest.Builder requestBuilder, Class<T> type, Map<String, String> parameters) throws IOException {
        return this.waitForResult(this.handleResponse(this.httpClient, requestBuilder, type, parameters));
    }

    protected <T> CompletableFuture<T> handleResponse(HttpClient client, HttpRequest.Builder requestBuilder, Class<T> type, Map<String, String> parameters) {
        VersionUsageUtils.log(this.resourceT, this.apiGroupVersion);
        HttpRequest request = requestBuilder.build();
        CompletableFuture<HttpResponse<byte[]>> futureResponse = new CompletableFuture<HttpResponse<byte[]>>();
        this.retryWithExponentialBackoff(futureResponse, new ExponentialBackoffIntervalCalculator(this.requestRetryBackoffInterval, 5), Utils.getNonNullOrElse(client, this.httpClient), request);
        return futureResponse.thenApply(response -> {
            try {
                this.assertResponseCode(request, (HttpResponse<?>)response);
                if (type != null) {
                    return Serialization.unmarshal((InputStream)new ByteArrayInputStream((byte[])response.body()), type, parameters);
                }
                return null;
            }
            catch (KubernetesClientException e) {
                throw e;
            }
            catch (Exception e) {
                throw OperationSupport.requestException(request, e);
            }
        });
    }

    protected void retryWithExponentialBackoff(CompletableFuture<HttpResponse<byte[]>> result, ExponentialBackoffIntervalCalculator retryIntervalCalculator, HttpClient client, HttpRequest request) {
        client.sendAsync(request, byte[].class).whenComplete((response, throwable) -> {
            int retries = retryIntervalCalculator.getCurrentReconnectAttempt();
            if (retries < this.requestRetryBackoffLimit) {
                long retryInterval = retryIntervalCalculator.nextReconnectInterval();
                boolean retry = false;
                if (response != null && response.code() >= 500) {
                    LOG.debug("HTTP operation on url: {} should be retried as the response code was {}, retrying after {} millis", new Object[]{request.uri(), response.code(), retryInterval});
                    retry = true;
                } else if (throwable instanceof IOException) {
                    LOG.debug(String.format("HTTP operation on url: %s should be retried after %d millis because of IOException", request.uri(), retryInterval), throwable);
                    retry = true;
                }
                if (retry) {
                    Utils.schedule(this.context.getExecutor(), () -> this.retryWithExponentialBackoff(result, retryIntervalCalculator, client, request), retryInterval, TimeUnit.MILLISECONDS);
                    return;
                }
            }
            if (throwable != null) {
                result.completeExceptionally((Throwable)throwable);
            } else {
                result.complete((HttpResponse<byte[]>)response);
            }
        });
    }

    protected void assertResponseCode(HttpRequest request, HttpResponse<?> response) {
        if (response.isSuccessful()) {
            return;
        }
        int statusCode = response.code();
        String customMessage = this.config.getErrorMessages().get(statusCode);
        if (customMessage != null) {
            throw OperationSupport.requestFailure(request, OperationSupport.createStatus(statusCode, this.combineMessages(customMessage, OperationSupport.createStatus(response))));
        }
        throw OperationSupport.requestFailure(request, OperationSupport.createStatus(response));
    }

    private String combineMessages(String customMessage, Status defaultStatus) {
        String message;
        if (defaultStatus != null && (message = defaultStatus.getMessage()) != null && message.length() > 0) {
            return customMessage + " " + message;
        }
        return customMessage;
    }

    public static Status createStatus(HttpResponse<?> response) {
        int statusCode;
        String statusMessage = "";
        int n = statusCode = response != null ? response.code() : 0;
        if (response == null) {
            statusMessage = "No response";
        } else {
            try {
                String bodyString = response.bodyString();
                if (Utils.isNotNullOrEmpty(bodyString)) {
                    Status status = (Status)JSON_MAPPER.readValue(bodyString, Status.class);
                    if (status.getCode() == null) {
                        status = ((StatusBuilder)new StatusBuilder(status).withCode(Integer.valueOf(statusCode))).build();
                    }
                    return status;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (response.message() != null) {
                statusMessage = response.message();
            }
        }
        return OperationSupport.createStatus(statusCode, statusMessage);
    }

    public static Status createStatus(int statusCode, String message) {
        Status status = ((StatusBuilder)((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(statusCode))).withMessage(message)).build();
        status.getAdditionalProperties().put(CLIENT_STATUS_FLAG, "true");
        return status;
    }

    public static KubernetesClientException requestFailure(HttpRequest request, Status status) {
        return OperationSupport.requestFailure(request, status, null);
    }

    public static KubernetesClientException requestFailure(HttpRequest request, Status status, String message) {
        StringBuilder sb = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            sb.append(message).append(". ");
        }
        sb.append("Failure executing: ").append(request.method()).append(" at: ").append(request.uri()).append(".");
        if (status.getMessage() != null && !status.getMessage().isEmpty()) {
            sb.append(" Message: ").append(status.getMessage()).append(".");
        }
        if (!status.getAdditionalProperties().containsKey(CLIENT_STATUS_FLAG)) {
            sb.append(" Received status: ").append(status).append(".");
        }
        return new KubernetesClientException(sb.toString(), null, (int)status.getCode(), status, request);
    }

    public static KubernetesClientException requestException(HttpRequest request, Throwable e, String message) {
        StringBuilder sb = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            sb.append(message).append(". ");
        }
        sb.append("Error executing: ").append(request.method()).append(" at: ").append(request.uri()).append(". Cause: ").append(e.getMessage());
        return new KubernetesClientException(sb.toString(), e, -1, null, request);
    }

    public static KubernetesClientException requestException(HttpRequest request, Exception e) {
        return OperationSupport.requestException(request, e, null);
    }

    protected static <T> T unmarshal(InputStream is) {
        return Serialization.unmarshal(is);
    }

    protected static <T> T unmarshal(InputStream is, Class<T> type) {
        return Serialization.unmarshal(is, type);
    }

    protected static <T> T unmarshal(InputStream is, TypeReference<T> type) {
        return Serialization.unmarshal(is, type);
    }

    protected static <T> Map<String, Object> getObjectValueAsMap(T object) {
        return (Map)JSON_MAPPER.convertValue(object, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public Config getConfig() {
        return this.config;
    }

    private String getContentTypeFromPatchContextOrDefault(PatchContext patchContext) {
        if (patchContext != null && patchContext.getPatchType() != null) {
            return patchContext.getPatchType().getContentType();
        }
        return STRATEGIC_MERGE_JSON_PATCH;
    }

    public <R1> R1 restCall(Class<R1> result, String ... path) {
        try {
            URL requestUrl = new URL(this.config.getMasterUrl());
            String url = requestUrl.toString();
            if (path != null && path.length > 0) {
                url = URLUtils.join(url, URLUtils.pathJoin(path));
            }
            HttpRequest.Builder req = this.httpClient.newHttpRequestBuilder().uri(url);
            return this.handleResponse(req, result);
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return null;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(ie);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }
}

