/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils.internal;

import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueFluent;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressRuleValueFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressSpecFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressTLS;
import io.fabric8.kubernetes.api.model.networking.v1.IngressTLSBuilder;
import io.fabric8.kubernetes.client.utils.internal.URLFromServiceUtil;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class URLFromServiceUtilTest {
    URLFromServiceUtilTest() {
    }

    @Test
    void resolveHostFromEnvVarOrSystemProperty_whenPropertyFound_thenReturnProperty() {
        String propertyName = "SVC1_SERVICE_HOST";
        try {
            System.setProperty("SVC1_SERVICE_HOST", "10.111.31.220");
            String host = URLFromServiceUtil.resolveHostFromEnvVarOrSystemProperty((String)"svc1");
            AssertionsForInterfaceTypes.assertThat((String)host).isEqualTo("10.111.31.220");
        }
        finally {
            System.clearProperty("SVC1_SERVICE_HOST");
        }
    }

    @Test
    void resolveProtocolFromEnvVarOrSystemProperty_whenPropertyFound_thenReturnProtocol() {
        String propertyName = "SVC1_PORT_443_TCP_PROTO";
        try {
            System.setProperty("SVC1_PORT_443_TCP_PROTO", "tcp");
            String host = URLFromServiceUtil.resolveProtocolFromEnvVarOrSystemProperty((String)"svc1", (String)"443");
            AssertionsForInterfaceTypes.assertThat((String)host).isEqualTo("tcp");
        }
        finally {
            System.clearProperty("SVC1_PORT_443_TCP_PROTO");
        }
    }

    @Test
    void resolvePortFromEnvVarOrSystemProperty_whenPortPropertyProvided_thenReturnPort() {
        String propertyName = "SVC1_SERVICE_PORT";
        try {
            System.setProperty("SVC1_SERVICE_PORT", "80");
            String host = URLFromServiceUtil.resolvePortFromEnvVarOrSystemProperty((String)"svc1", (String)"");
            AssertionsForInterfaceTypes.assertThat((String)host).isEqualTo("80");
        }
        finally {
            System.clearProperty("SVC1_SERVICE_PORT");
        }
    }

    @Test
    void getURLFromTLSHost_whenTLSProvided_thenReturnURL() {
        String url = URLFromServiceUtil.getURLFromTLSHost((String)"example.com", (String)"/foo");
        AssertionsForInterfaceTypes.assertThat((String)url).isEqualTo("https://example.com/foo");
    }

    @Test
    void getURLFromTLSHost_whenEmptyHost_thenReturnNull() {
        AssertionsForInterfaceTypes.assertThat((String)URLFromServiceUtil.getURLFromTLSHost((String)"", (String)"/foo")).isNull();
    }

    @Test
    void getURLFromNetworkingV1IngressList_whenIngressWithNoRules_thenReturnNull() {
        ServicePort servicePort = ((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("http")).withPort(Integer.valueOf(80))).build();
        List<io.fabric8.kubernetes.api.model.networking.v1.Ingress> ingressList = Collections.singletonList(((io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder)((IngressFluent.SpecNested)this.createNewNetworkV1IngressBuilder().editSpec().withRules(Collections.emptyList())).endSpec()).build());
        String url = URLFromServiceUtil.getURLFromNetworkingV1IngressList(ingressList, (String)"test", (String)"svc1", (ServicePort)servicePort);
        AssertionsForInterfaceTypes.assertThat((String)url).isNull();
    }

    @Test
    void getURLFromNetworkingV1IngressList_whenIngressRuleWithNoPath_thenReturnNull() {
        ServicePort servicePort = ((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("http")).withPort(Integer.valueOf(80))).build();
        List<io.fabric8.kubernetes.api.model.networking.v1.Ingress> ingressList = Collections.singletonList(((io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)this.createNewNetworkV1IngressBuilder().editSpec().editFirstRule().editHttp().withPaths(Collections.emptyList())).endHttp()).endRule()).endSpec()).build());
        String url = URLFromServiceUtil.getURLFromNetworkingV1IngressList(ingressList, (String)"test", (String)"svc1", (ServicePort)servicePort);
        AssertionsForInterfaceTypes.assertThat((String)url).isNull();
    }

    @Test
    void getURLFromNetworkingV1IngressList_whenNetworkV1IngressProvided_thenReturnURL() {
        ServicePort servicePort = ((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("http")).withPort(Integer.valueOf(80))).build();
        List<io.fabric8.kubernetes.api.model.networking.v1.Ingress> ingressList = Collections.singletonList(this.createNewNetworkV1IngressBuilder().build());
        String url = URLFromServiceUtil.getURLFromNetworkingV1IngressList(ingressList, (String)"test", (String)"svc1", (ServicePort)servicePort);
        AssertionsForInterfaceTypes.assertThat((String)url).isEqualTo("https://example.com/testpath");
    }

    @Test
    void getURLFromNetworkingV1beta1IngressList_whenIngressWithEmptyHost_thenReturnNull() {
        ServicePort servicePort = ((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("http")).withPort(Integer.valueOf(80))).build();
        List<io.fabric8.kubernetes.api.model.networking.v1.Ingress> ingressList = Collections.singletonList(((io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)this.createNewNetworkV1IngressBuilder().editSpec().editFirstRule().withHost("")).endRule()).endSpec()).build());
        String url = URLFromServiceUtil.getURLFromNetworkingV1IngressList(ingressList, (String)"test", (String)"svc1", (ServicePort)servicePort);
        AssertionsForInterfaceTypes.assertThat((String)url).isNull();
    }

    @Test
    void getURLFromExtensionsV1beta1IngressList_whenNoNetworkV1Ingress_thenReturnNull() {
        ServicePort servicePort = ((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("http")).withPort(Integer.valueOf(80))).build();
        List ingressList = Collections.emptyList();
        String url = URLFromServiceUtil.getURLFromExtensionsV1beta1IngressList(ingressList, (String)"test", (String)"svc1", (ServicePort)servicePort);
        AssertionsForInterfaceTypes.assertThat((String)url).isNull();
    }

    @Test
    void getURLFromExtensionsV1beta1IngressList_whenIngressWithNoRules_thenReturnNull() {
        ServicePort servicePort = ((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("http")).withPort(Integer.valueOf(80))).build();
        List<Ingress> ingressList = Collections.singletonList(((IngressBuilder)((IngressFluent.SpecNested)this.createNewExtensionsV1beta1IngressBuilder().editSpec().withRules(Collections.emptyList())).endSpec()).build());
        String url = URLFromServiceUtil.getURLFromExtensionsV1beta1IngressList(ingressList, (String)"test", (String)"svc1", (ServicePort)servicePort);
        AssertionsForInterfaceTypes.assertThat((String)url).isNull();
    }

    @Test
    void getURLFromExtensionsV1beta1IngressList_whenIngressRuleWithNoPath_thenReturnNull() {
        ServicePort servicePort = ((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("http")).withPort(Integer.valueOf(80))).build();
        List<Ingress> ingressList = Collections.singletonList(((IngressBuilder)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)this.createNewExtensionsV1beta1IngressBuilder().editSpec().editFirstRule().editHttp().withPaths(Collections.emptyList())).endHttp()).endRule()).endSpec()).build());
        String url = URLFromServiceUtil.getURLFromExtensionsV1beta1IngressList(ingressList, (String)"test", (String)"svc1", (ServicePort)servicePort);
        AssertionsForInterfaceTypes.assertThat((String)url).isNull();
    }

    @Test
    void getURLFromExtensionsV1beta1IngressList_whenExtensionsV1beta1IngressProvided_thenReturnURL() {
        ServicePort servicePort = ((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("http")).withPort(Integer.valueOf(80))).build();
        List<Ingress> ingressList = Collections.singletonList(this.createNewExtensionsV1beta1IngressBuilder().build());
        String url = URLFromServiceUtil.getURLFromExtensionsV1beta1IngressList(ingressList, (String)"test", (String)"svc1", (ServicePort)servicePort);
        AssertionsForInterfaceTypes.assertThat((String)url).isEqualTo("http://example.com/testpath");
    }

    @Test
    void getURLFromExtensionsV1beta1IngressList_whenExtensionsV1beta1IngressWithEmptyHost_thenReturnNull() {
        ServicePort servicePort = ((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("http")).withPort(Integer.valueOf(80))).build();
        List<Ingress> ingressList = Collections.singletonList(((IngressBuilder)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)this.createNewExtensionsV1beta1IngressBuilder().editSpec().editFirstRule().withHost("")).endRule()).endSpec()).build());
        String url = URLFromServiceUtil.getURLFromExtensionsV1beta1IngressList(ingressList, (String)"test", (String)"svc1", (ServicePort)servicePort);
        AssertionsForInterfaceTypes.assertThat((String)url).isNull();
    }

    @Test
    void getURLFromNetworkingV1IngressList_whenNoNetworkV1Ingress_thenReturnNull() {
        ServicePort servicePort = ((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("http")).withPort(Integer.valueOf(80))).build();
        List ingressList = Collections.emptyList();
        String url = URLFromServiceUtil.getURLFromNetworkingV1IngressList(ingressList, (String)"test", (String)"svc1", (ServicePort)servicePort);
        AssertionsForInterfaceTypes.assertThat((String)url).isNull();
    }

    @Test
    void getServicePortByName_whenNothingProvided_thenReturnNull() {
        Service service = ((ServiceBuilder)((ServiceFluent.SpecNested)new ServiceBuilder().withNewSpec().withPorts(Collections.emptyList())).endSpec()).build();
        ServicePort port = URLFromServiceUtil.getServicePortByName((Service)service, (String)"http");
        AssertionsForInterfaceTypes.assertThat((Object)port).isNull();
    }

    @Test
    void getServicePortByName_whenPortNameEmpty_thenReturnFirstPort() {
        Service service = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceBuilder)new ServiceBuilder().withNewMetadata().endMetadata()).withNewSpec().addNewPort().withName("http")).withPort(Integer.valueOf(80))).endPort()).endSpec()).build();
        ServicePort port = URLFromServiceUtil.getServicePortByName((Service)service, (String)"");
        ((ObjectAssert)AssertionsForInterfaceTypes.assertThat((Object)port).hasFieldOrPropertyWithValue("name", (Object)"http")).hasFieldOrPropertyWithValue("port", (Object)80);
    }

    @Test
    void getServicePortByName_whenPortNameProvided_thenReturnMatchingPort() {
        Service service = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceBuilder)new ServiceBuilder().withNewMetadata().endMetadata()).withNewSpec().addNewPort().withName("http")).withPort(Integer.valueOf(80))).endPort()).addNewPort().withName("https")).withPort(Integer.valueOf(443))).endPort()).endSpec()).build();
        ServicePort port = URLFromServiceUtil.getServicePortByName((Service)service, (String)"https");
        ((ObjectAssert)AssertionsForInterfaceTypes.assertThat((Object)port).hasFieldOrPropertyWithValue("name", (Object)"https")).hasFieldOrPropertyWithValue("port", (Object)443);
    }

    private IngressBuilder createNewExtensionsV1beta1IngressBuilder() {
        return (IngressBuilder)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((HTTPIngressPathFluent.BackendNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressRuleValueFluent.PathsNested)((IngressSpecFluent.RulesNested)((IngressBuilder)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)new IngressBuilder().withNewMetadata().withName("ing1")).withNamespace("test")).endMetadata()).withNewSpec().addNewRule().withHost("example.com")).withNewHttp().addNewPath().withPath("/testpath")).withPathType("Prefix")).withNewBackend().withServiceName("svc1")).withServicePort(new IntOrString((Object)"http"))).endBackend()).endPath()).endHttp()).endRule()).endSpec();
    }

    private io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder createNewNetworkV1IngressBuilder() {
        return (io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((IngressBackendFluent.ServiceNested)((IngressServiceBackendFluent.PortNested)((IngressServiceBackendFluent.PortNested)((IngressBackendFluent.ServiceNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressRuleValueFluent.PathsNested)((IngressSpecFluent.RulesNested)((IngressFluent.SpecNested)((io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)new io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder().withNewMetadata().withName("ing1")).withNamespace("test")).endMetadata()).withNewSpec().withTls(new IngressTLS[]{((IngressTLSBuilder)((IngressTLSBuilder)new IngressTLSBuilder().addToHosts(new String[]{"example.com"})).withSecretName("testsecret-tls")).build()})).addNewRule().withHost("example.com")).withNewHttp().addNewPath().withPath("/testpath")).withPathType("Prefix")).withNewBackend().withNewService().withName("svc1")).withNewPort().withName("http")).withNumber(Integer.valueOf(80))).endPort()).endService()).endBackend()).endPath()).endHttp()).endRule()).endSpec();
    }
}

