/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.impl.SharedInformerFactoryImpl;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Kind;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.ShortNames;
import io.fabric8.kubernetes.model.annotation.Version;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SharedInformerFactoryImplTest {
    public static final long RESYNC_PERIOD = 10000L;
    private KubernetesClient mockBaseClient;

    SharedInformerFactoryImplTest() {
    }

    @BeforeEach
    void init() {
        this.mockBaseClient = new KubernetesClientBuilder().build();
    }

    @Test
    void testGetExistingSharedIndexInformer() {
        SharedInformerFactoryImpl sharedInformerFactory = new SharedInformerFactoryImpl(this.mockBaseClient);
        sharedInformerFactory.sharedIndexInformerFor(Deployment.class, 10000L);
        sharedInformerFactory.sharedIndexInformerFor(Pod.class, 10000L);
        Assertions.assertThat((Object)sharedInformerFactory.getExistingSharedIndexInformer(Deployment.class)).isNotNull();
        Assertions.assertThat((Object)sharedInformerFactory.getExistingSharedIndexInformer(Pod.class)).isNotNull();
    }

    @Test
    void testGetExistingSharedIndexInformerWithKindDifferentFromClassName() {
        SharedInformerFactoryImpl sharedInformerFactory = new SharedInformerFactoryImpl(this.mockBaseClient);
        SharedIndexInformer createdInformer = sharedInformerFactory.sharedIndexInformerFor(MyAppCustomResource.class, 10000L);
        SharedIndexInformer existingInformer = sharedInformerFactory.getExistingSharedIndexInformer(MyAppCustomResource.class);
        Assertions.assertThat((Object)createdInformer).isNotNull();
        Assertions.assertThat((Object)existingInformer).isNotNull();
        Assertions.assertThat((Object)createdInformer).isEqualTo((Object)existingInformer);
    }

    @Test
    void testGetExistingSharedIndexInformerWithTwoClassesSimilarNames() {
        SharedInformerFactoryImpl sharedInformerFactory = new SharedInformerFactoryImpl(this.mockBaseClient);
        sharedInformerFactory.sharedIndexInformerFor(VirtualService.class, 10000L);
        sharedInformerFactory.sharedIndexInformerFor(Service.class, 10000L);
        SharedIndexInformer sharedIndexInformerSvc = sharedInformerFactory.getExistingSharedIndexInformer(Service.class);
        SharedIndexInformer sharedIndexInformerVSvc = sharedInformerFactory.getExistingSharedIndexInformer(VirtualService.class);
        Assertions.assertThat((Class)sharedIndexInformerSvc.getApiTypeClass()).isEqualTo(Service.class);
        Assertions.assertThat((Class)sharedIndexInformerVSvc.getApiTypeClass()).isEqualTo(VirtualService.class);
    }

    private static class FlinkJobSpec {
        private String flinkJobSpec;

        private FlinkJobSpec() {
        }

        public String getFlinkJobSpec() {
            return this.flinkJobSpec;
        }

        public void setFlinkJobSpec(String flinkJobSpec) {
            this.flinkJobSpec = flinkJobSpec;
        }

        public String toString() {
            return "FlinkJobSpec{flinkJobSpec='" + this.flinkJobSpec + "'}";
        }
    }

    @Group(value="com.acme")
    @Version(value="v1")
    @Kind(value="FlinkJob")
    @Plural(value="flinkjobs")
    @ShortNames(value={"fj"})
    private static class FlinkJobCustomResource
    extends CustomResource<FlinkJobSpec, Void> {
        private FlinkJobCustomResource() {
        }

        protected FlinkJobSpec initSpec() {
            return new FlinkJobSpec();
        }
    }

    @Group(value="networking.istio.io")
    @Version(value="v1alpha3")
    public static class VirtualService
    extends CustomResource<Void, Void> {
    }

    @Group(value="com.acme")
    @Version(value="v1")
    @Kind(value="MyApp")
    @Plural(value="myapps")
    public static class MyAppCustomResourceCopy
    extends CustomResource<Void, Void> {
    }

    @Group(value="com.acme")
    @Version(value="v1")
    @Kind(value="MyApp")
    public static class MyAppCustomResource
    extends CustomResource<Void, Void> {
    }

    @Group(value="io.fabric8")
    @Version(value="v1")
    private static class TestCustomResource
    extends CustomResource<TestCustomResourceSpec, TestCustomResourceStatus> {
        private TestCustomResource() {
        }
    }

    private static class TestCustomResourceStatus {
        private TestCustomResourceStatus() {
        }
    }

    private static class TestCustomResourceSpec {
        private TestCustomResourceSpec() {
        }
    }
}

