/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.uploadable;

import io.fabric8.kubernetes.client.dsl.internal.uploadable.PodUpload;
import io.fabric8.kubernetes.client.utils.InputStreamPumper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class PodUploadTest {
    PodUploadTest() {
    }

    @Test
    void transferTo() throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream("I'LL BE COPIED".getBytes(Charset.defaultCharset()));
        AtomicReference copiedStream = new AtomicReference();
        InputStreamPumper.Writable consumer = (bytes, offset, length) -> {
            Assertions.assertThat((int)length).isEqualTo(14);
            copiedStream.set(new String(Arrays.copyOf(bytes, 14), Charset.defaultCharset()));
        };
        InputStreamPumper.transferTo((InputStream)input, (InputStreamPumper.Writable)consumer);
        Assertions.assertThat(copiedStream).hasValue((Object)"I'LL BE COPIED");
    }

    @Nested
    @DisplayName(value="createExecCommandForUpload")
    class CreateExecCommand {
        CreateExecCommand() {
        }

        @Test
        void withFileInRootPath_shouldCreateValidExecCommandForUpload() {
            String result = PodUpload.createExecCommandForUpload((String)"/cp.log");
            Assertions.assertThat((String)result).isEqualTo("mkdir -p '/' && cat - > '/cp.log'");
        }

        @Test
        void withNormalFile_shouldCreateValidExecCommandForUpload() {
            String result = PodUpload.createExecCommandForUpload((String)"/tmp/foo/cp.log");
            Assertions.assertThat((String)result).isEqualTo("mkdir -p '/tmp/foo/' && cat - > '/tmp/foo/cp.log'");
        }

        @Test
        void withSingleQuoteInPath() {
            String result = PodUpload.createExecCommandForUpload((String)"/tmp/fo'o/cp.log");
            Assertions.assertThat((String)result).isEqualTo("mkdir -p '/tmp/fo'\\''o/' && cat - > '/tmp/fo'\\''o/cp.log'");
        }

        @Test
        void withMultipleSingleQuotesInPath() {
            String result = PodUpload.createExecCommandForUpload((String)"/tmp/f'o'o/c'p.log");
            Assertions.assertThat((String)result).isEqualTo("mkdir -p '/tmp/f'\\''o'\\''o/' && cat - > '/tmp/f'\\''o'\\''o/c'\\''p.log'");
        }
    }
}

