/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.RequestConfigBuilder;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.OperationSupport;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.TestHttpResponse;
import io.fabric8.kubernetes.client.impl.BaseClient;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class OperationSupportTest {
    private OperationSupport operationSupport;

    OperationSupportTest() {
    }

    @BeforeEach
    void setUp() {
        BaseClient mock = (BaseClient)Mockito.mock(BaseClient.class, (Answer)Mockito.RETURNS_SELF);
        Mockito.when((Object)((BaseClient)mock.adapt(BaseClient.class)).getKubernetesSerialization()).thenReturn((Object)new KubernetesSerialization());
        OperationContext context = new OperationContext().withClient((Client)mock);
        Config globalConfig = ((ConfigBuilder)new ConfigBuilder(Config.empty()).withRequestTimeout(313373)).build();
        Mockito.when((Object)context.getClient().getConfiguration()).thenReturn((Object)globalConfig);
        this.operationSupport = new OperationSupport(context);
    }

    @DisplayName(value="checkName, should use operation or item name")
    @ParameterizedTest(name="{index}: operationName: ''{1}'' itemName: ''{2}'', expects: ''{0}''")
    @MethodSource(value={"checkNameInput"})
    void checkName(String expected, String operationName, String itemName) {
        this.operationSupport = new OperationSupport(this.operationSupport.context.withName(operationName));
        Pod item = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(itemName)).endMetadata()).build();
        String result = this.operationSupport.checkName((Object)item);
        Assertions.assertThat((String)result).isEqualTo(expected);
    }

    static Stream<Arguments> checkNameInput() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{null, null, null}), Arguments.arguments((Object[])new Object[]{"operation", "operation", null}), Arguments.arguments((Object[])new Object[]{"item", null, "item"}), Arguments.arguments((Object[])new Object[]{"operation-item-are-the-same", "operation-item-are-the-same", "operation-item-are-the-same"}));
    }

    @Test
    @DisplayName(value="checkName, with different operation and item name, throws Exception")
    void checkNameWithDifferentOperationAndItemNameThrowsException() {
        this.operationSupport = new OperationSupport(this.operationSupport.context.withName("operation-name"));
        Pod item = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("item-name")).endMetadata()).build();
        KubernetesClientException result = (KubernetesClientException)org.junit.jupiter.api.Assertions.assertThrows(KubernetesClientException.class, () -> this.operationSupport.checkName((Object)item));
        Assertions.assertThat((Throwable)result).hasMessageContaining("Name mismatch. Item name:item-name. Operation name:operation-name.");
    }

    @Test
    @DisplayName(value="assertResponse, with successful code, should do nothing")
    void assertResponseCodeSuccessful() {
        HttpRequest request = new StandardHttpRequest.Builder().uri("https://example.com").build();
        TestHttpResponse response = new TestHttpResponse().withCode(200);
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.lambda$assertResponseCodeSuccessful$1(request, (HttpResponse)response));
    }

    @Test
    @DisplayName(value="assertResponse, with client error, should throw exception")
    void assertResponseCodeClientError() throws Exception {
        HttpRequest request = new StandardHttpRequest.Builder().method("GET", null, null).uri(new URI("https://example.com")).build();
        TestHttpResponse response = new TestHttpResponse().withCode(400);
        KubernetesClientException result = (KubernetesClientException)org.junit.jupiter.api.Assertions.assertThrows(KubernetesClientException.class, () -> this.lambda$assertResponseCodeClientError$2(request, (HttpResponse)response));
        Assertions.assertThat((Throwable)result).hasMessageContaining("Failure executing: GET at: https://example.com. Message: Bad Request.");
    }

    @Test
    @DisplayName(value="assertResponse, with client error and custom message, should throw exception")
    void assertResponseCodeClientErrorAndCustomMessage() throws Exception {
        this.operationSupport.getConfig().getErrorMessages().put(400, "Custom message");
        HttpRequest request = new StandardHttpRequest.Builder().method("GET", null, null).uri(new URI("https://example.com")).build();
        TestHttpResponse response = new TestHttpResponse().withCode(400);
        KubernetesClientException result = (KubernetesClientException)org.junit.jupiter.api.Assertions.assertThrows(KubernetesClientException.class, () -> this.lambda$assertResponseCodeClientErrorAndCustomMessage$3(request, (HttpResponse)response));
        Assertions.assertThat((Throwable)result).hasMessageContaining("Failure executing: GET at: https://example.com. Message: Custom message Bad Request.");
    }

    @Test
    @DisplayName(value="assertResponse, with client error, should throw exception with server response body")
    void assertResponseCodeClientErrorAndStatus() throws Exception {
        HttpRequest request = new StandardHttpRequest.Builder().method("GET", null, null).uri(new URI("https://example.com")).build();
        TestHttpResponse response = new TestHttpResponse().withCode(400).withBody((Object)"{\"kind\":\"Status\",\"apiVersion\":\"v1\",\"status\":\"Failure\",\"code\":400,\"message\":\"Invalid\"}");
        KubernetesClientException result = (KubernetesClientException)org.junit.jupiter.api.Assertions.assertThrows(KubernetesClientException.class, () -> this.lambda$assertResponseCodeClientErrorAndStatus$4(request, (HttpResponse)response));
        Assertions.assertThat((Throwable)result).hasMessageContaining("Failure executing: GET at: https://example.com. Message: Invalid. Received status: Status(");
    }

    @Test
    void getResourceURL() throws MalformedURLException {
        Assertions.assertThat((URL)this.operationSupport.getResourceUrl()).hasToString("https://kubernetes.default.svc/api/v1");
        OperationSupport pods = new OperationSupport(this.operationSupport.context.withPlural("pods"));
        Assertions.assertThat((String)pods.getResourceUrl().toString()).hasToString("https://kubernetes.default.svc/api/v1/pods");
        pods = new OperationSupport(pods.context.withName("pod-1"));
        Assertions.assertThat((URL)pods.getResourceUrl()).hasToString("https://kubernetes.default.svc/api/v1/pods/pod-1");
        pods = new OperationSupport(pods.context.withSubresource("ephemeralcontainers"));
        Assertions.assertThat((URL)pods.getResourceUrl()).hasToString("https://kubernetes.default.svc/api/v1/pods/pod-1/ephemeralcontainers");
        pods = new OperationSupport(pods.context.withNamespace("default"));
        Assertions.assertThat((URL)pods.getResourceUrl()).hasToString("https://kubernetes.default.svc/api/v1/namespaces/default/pods/pod-1/ephemeralcontainers");
        OperationSupport subresourceWithoutName = new OperationSupport(this.operationSupport.context.withPlural("Pods").withSubresource("pod-1"));
        org.junit.jupiter.api.Assertions.assertThrows(KubernetesClientException.class, () -> subresourceWithoutName.getResourceUrl());
    }

    @Test
    void getResourceURLStatus() throws MalformedURLException {
        OperationSupport pods = new OperationSupport(this.operationSupport.context.withPlural("pods"));
        OperationSupport podsStatus = new OperationSupport(this.operationSupport.context.withPlural("pods").withSubresource("status"));
        Assertions.assertThat((URL)podsStatus.getResourceUrl("default", "pod-1")).hasToString("https://kubernetes.default.svc/api/v1/namespaces/default/pods/pod-1/status");
        Assertions.assertThat((URL)pods.getResourceUrl("default", "pod-1")).hasToString("https://kubernetes.default.svc/api/v1/namespaces/default/pods/pod-1");
        OperationSupport podsSubresource = new OperationSupport(pods.context.withSubresource("ephemeralcontainers"));
        Assertions.assertThat((URL)podsSubresource.getResourceUrl("default", "pod-1")).hasToString("https://kubernetes.default.svc/api/v1/namespaces/default/pods/pod-1/ephemeralcontainers");
        org.junit.jupiter.api.Assertions.assertThrows(KubernetesClientException.class, () -> podsStatus.getResourceUrl("default", null), (String)"status requires name");
    }

    @Test
    void getRequestConfigReturnsFromGlobalConfigByDefault() {
        Assertions.assertThat((Object)this.operationSupport.getRequestConfig()).hasFieldOrPropertyWithValue("requestTimeout", (Object)313373);
    }

    @Test
    void getRequestConfigReturnsFromContextIfPresent() {
        Assertions.assertThat((Object)this.operationSupport.getOperationContext().withRequestConfig(((RequestConfigBuilder)new RequestConfigBuilder().withRequestTimeout(1337)).build()).getRequestConfig()).hasFieldOrPropertyWithValue("requestTimeout", (Object)1337);
    }

    private /* synthetic */ void lambda$assertResponseCodeClientErrorAndStatus$4(HttpRequest request, HttpResponse response) throws Throwable {
        this.operationSupport.assertResponseCode(request, response);
    }

    private /* synthetic */ void lambda$assertResponseCodeClientErrorAndCustomMessage$3(HttpRequest request, HttpResponse response) throws Throwable {
        this.operationSupport.assertResponseCode(request, response);
    }

    private /* synthetic */ void lambda$assertResponseCodeClientError$2(HttpRequest request, HttpResponse response) throws Throwable {
        this.operationSupport.assertResponseCode(request, response);
    }

    private /* synthetic */ void lambda$assertResponseCodeSuccessful$1(HttpRequest request, HttpResponse response) throws Throwable {
        this.operationSupport.assertResponseCode(request, response);
    }
}

