/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils.internal;

import io.fabric8.kubernetes.client.utils.internal.SerialExecutor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SerialExecutorTest {
    SerialExecutorTest() {
    }

    @Test
    void clearInterrupt() {
        ExecutorService es = Executors.newSingleThreadExecutor();
        SerialExecutor serialExecutor = new SerialExecutor((Executor)es);
        CompletableFuture future = new CompletableFuture();
        serialExecutor.execute(() -> {
            future.complete(Thread.currentThread());
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            throw new RuntimeException();
        });
        CompletableFuture interrupted = new CompletableFuture();
        serialExecutor.execute(() -> interrupted.complete(Thread.currentThread().isInterrupted()));
        Thread t = (Thread)future.join();
        t.interrupt();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((Boolean)interrupted.join()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void taskExecutedInOrderOfInsertion() throws InterruptedException {
        ExecutorService es = Executors.newSingleThreadExecutor();
        try {
            StringBuffer sb = new StringBuffer();
            SerialExecutor se = new SerialExecutor((Executor)es);
            CountDownLatch latch = new CountDownLatch(1);
            se.execute(() -> {
                sb.append("1");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            });
            se.execute(() -> sb.append("2"));
            se.execute(() -> sb.append("3"));
            se.execute(() -> sb.append("4"));
            se.execute(() -> sb.append("5"));
            se.execute(latch::countDown);
            Assertions.assertThat((boolean)latch.await(500L, TimeUnit.MILLISECONDS)).isTrue();
            Assertions.assertThat((StringBuffer)sb).hasToString("12345");
        }
        finally {
            es.shutdownNow();
        }
    }
}

