/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.impl;

import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueFluent;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressList;
import io.fabric8.kubernetes.api.model.extensions.IngressListBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressRuleValueFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressSpecFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressTLS;
import io.fabric8.kubernetes.api.model.networking.v1.IngressTLSBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.ServiceToURLProvider;
import io.fabric8.kubernetes.client.V1NetworkAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.ExtensionsAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NetworkAPIGroupDSL;
import io.fabric8.kubernetes.client.impl.URLFromIngressImpl;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class URLFromIngressImplTest {
    private URLFromIngressImpl urlFromIngress;
    private KubernetesClient kubernetesClient;

    URLFromIngressImplTest() {
    }

    @BeforeEach
    void setUp() {
        this.urlFromIngress = new URLFromIngressImpl();
        this.kubernetesClient = (KubernetesClient)Mockito.mock(KubernetesClient.class);
    }

    @Test
    void getPriority_whenInvoked_shouldReturnThird() {
        AssertionsForInterfaceTypes.assertThat((int)this.urlFromIngress.getPriority()).isEqualTo(ServiceToURLProvider.ServiceToUrlImplPriority.FIRST.getValue());
    }

    @Test
    void getURL_withServiceWithEmptyPorts_shouldThrowException() {
        Service svc = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc1")).endMetadata()).withNewSpec().withPorts(Collections.emptyList())).endSpec()).build();
        Assertions.assertThatRuntimeException().isThrownBy(() -> this.urlFromIngress.getURL(svc, "i-dont-exist", "test", this.kubernetesClient)).withMessage("Couldn't find port: i-dont-exist for service svc1");
    }

    @Test
    void getURL_withValidExtensionsV1beta1Service_shouldReturnUrl() {
        Mockito.when((Object)this.kubernetesClient.supports(Ingress.class)).thenReturn((Object)true);
        this.mockExtensionsV1beta1IngressListCall(((IngressListBuilder)new IngressListBuilder().addToItems(new Ingress[]{this.createNewExtensionsIngressBuilder().build()})).build());
        Service svc = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc1")).endMetadata()).withNewSpec().addNewPort().withPort(Integer.valueOf(80))).withName("http")).endPort()).endSpec()).build();
        String url = this.urlFromIngress.getURL(svc, "http", "test", this.kubernetesClient);
        AssertionsForInterfaceTypes.assertThat((String)url).isEqualTo("http://example.com/testpath");
    }

    @Test
    void getURL_withNoIngressSupported_shouldReturnNull() {
        Mockito.when((Object)this.kubernetesClient.supports(io.fabric8.kubernetes.api.model.networking.v1.Ingress.class)).thenReturn((Object)false);
        Mockito.when((Object)this.kubernetesClient.supports(Ingress.class)).thenReturn((Object)false);
        Service svc = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc1")).endMetadata()).withNewSpec().addNewPort().withPort(Integer.valueOf(80))).withName("http")).endPort()).endSpec()).build();
        String url = this.urlFromIngress.getURL(svc, "http", "test", this.kubernetesClient);
        AssertionsForInterfaceTypes.assertThat((String)url).isNull();
    }

    @Test
    void getURL_withValidNetworkV1beta1Service_shouldReturnUrl() {
        Mockito.when((Object)this.kubernetesClient.supports(io.fabric8.kubernetes.api.model.networking.v1.Ingress.class)).thenReturn((Object)true);
        this.mockNetworkV1beta1IngressListCall(((io.fabric8.kubernetes.api.model.networking.v1.IngressListBuilder)new io.fabric8.kubernetes.api.model.networking.v1.IngressListBuilder().addToItems(new io.fabric8.kubernetes.api.model.networking.v1.Ingress[]{this.createNewNetworkV1IngressBuilder().build()})).build());
        Service svc = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc1")).endMetadata()).withNewSpec().addNewPort().withPort(Integer.valueOf(80))).withName("http")).endPort()).endSpec()).build();
        String url = this.urlFromIngress.getURL(svc, "http", "test", this.kubernetesClient);
        AssertionsForInterfaceTypes.assertThat((String)url).isEqualTo("http://example.com/testpath");
    }

    @Test
    void getURL_withValidNetworkV1beta1ServiceAndIngressTlsEnabled_shouldReturnHttpsUrl() {
        Mockito.when((Object)this.kubernetesClient.supports(io.fabric8.kubernetes.api.model.networking.v1.Ingress.class)).thenReturn((Object)true);
        this.mockNetworkV1beta1IngressListCall(((io.fabric8.kubernetes.api.model.networking.v1.IngressListBuilder)new io.fabric8.kubernetes.api.model.networking.v1.IngressListBuilder().addToItems(new io.fabric8.kubernetes.api.model.networking.v1.Ingress[]{((io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder)((IngressFluent.SpecNested)this.createNewNetworkV1IngressBuilder().editSpec().withTls(new IngressTLS[]{((IngressTLSBuilder)((IngressTLSBuilder)new IngressTLSBuilder().addToHosts(new String[]{"example.com"})).withSecretName("testsecret-tls")).build()})).endSpec()).build()})).build());
        Service svc = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc1")).endMetadata()).withNewSpec().addNewPort().withPort(Integer.valueOf(80))).withName("http")).endPort()).endSpec()).build();
        String url = this.urlFromIngress.getURL(svc, "http", "test", this.kubernetesClient);
        AssertionsForInterfaceTypes.assertThat((String)url).isEqualTo("https://example.com/testpath");
    }

    private void mockNetworkV1beta1IngressListCall(io.fabric8.kubernetes.api.model.networking.v1.IngressList ingList) {
        NetworkAPIGroupDSL networkAPIGroupDSL = (NetworkAPIGroupDSL)Mockito.mock(NetworkAPIGroupDSL.class);
        V1NetworkAPIGroupDSL v1NetworkAPIGroupDSL = (V1NetworkAPIGroupDSL)Mockito.mock(V1NetworkAPIGroupDSL.class);
        MixedOperation mixedOperation = (MixedOperation)Mockito.mock(MixedOperation.class);
        Mockito.when((Object)this.kubernetesClient.network()).thenReturn((Object)networkAPIGroupDSL);
        Mockito.when((Object)networkAPIGroupDSL.v1()).thenReturn((Object)v1NetworkAPIGroupDSL);
        Mockito.when((Object)v1NetworkAPIGroupDSL.ingresses()).thenReturn((Object)mixedOperation);
        Mockito.when((Object)mixedOperation.inNamespace(ArgumentMatchers.anyString())).thenReturn((Object)mixedOperation);
        Mockito.when((Object)mixedOperation.list()).thenReturn((Object)ingList);
    }

    private void mockExtensionsV1beta1IngressListCall(IngressList ingressList) {
        ExtensionsAPIGroupDSL extensionsAPIGroupDSL = (ExtensionsAPIGroupDSL)Mockito.mock(ExtensionsAPIGroupDSL.class);
        MixedOperation mixedOperation = (MixedOperation)Mockito.mock(MixedOperation.class);
        Mockito.when((Object)this.kubernetesClient.extensions()).thenReturn((Object)extensionsAPIGroupDSL);
        Mockito.when((Object)extensionsAPIGroupDSL.ingresses()).thenReturn((Object)mixedOperation);
        Mockito.when((Object)mixedOperation.inNamespace(ArgumentMatchers.anyString())).thenReturn((Object)mixedOperation);
        Mockito.when((Object)mixedOperation.list()).thenReturn((Object)ingressList);
    }

    private IngressBuilder createNewExtensionsIngressBuilder() {
        return (IngressBuilder)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((HTTPIngressPathFluent.BackendNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressRuleValueFluent.PathsNested)((IngressSpecFluent.RulesNested)((IngressBuilder)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)new IngressBuilder().withNewMetadata().withName("ing1")).withNamespace("test")).endMetadata()).withNewSpec().addNewRule().withHost("example.com")).withNewHttp().addNewPath().withPath("/testpath")).withPathType("Prefix")).withNewBackend().withServiceName("svc1")).withServicePort(new IntOrString((Object)80))).endBackend()).endPath()).endHttp()).endRule()).endSpec();
    }

    private io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder createNewNetworkV1IngressBuilder() {
        return (io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((IngressBackendFluent.ServiceNested)((IngressServiceBackendFluent.PortNested)((IngressServiceBackendFluent.PortNested)((IngressBackendFluent.ServiceNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressRuleValueFluent.PathsNested)((IngressSpecFluent.RulesNested)((io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)new io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder().withNewMetadata().withName("ing1")).withNamespace("test")).endMetadata()).withNewSpec().addNewRule().withHost("example.com")).withNewHttp().addNewPath().withPath("/testpath")).withPathType("Prefix")).withNewBackend().withNewService().withName("svc1")).withNewPort().withName("http")).withNumber(Integer.valueOf(80))).endPort()).endService()).endBackend()).endPath()).endHttp()).endRule()).endSpec();
    }
}

