/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.behavior;

import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodListBuilder;
import io.fabric8.kubernetes.api.model.PodListFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodStatusFluent;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.CopyOrReadable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.internal.uploadable.PodUpload;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.StandardWebSocketBuilder;
import io.fabric8.kubernetes.client.http.TestStandardHttpClient;
import io.fabric8.kubernetes.client.http.TestStandardHttpClientFactory;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketResponse;
import io.fabric8.kubernetes.client.http.WebSocketUpgradeResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@DisplayName(value="Pod Upload Behavior")
class UploadTest {
    private TestStandardHttpClientFactory factory;
    private KubernetesClient client;
    private TestStandardHttpClient httpClient;

    UploadTest() {
    }

    @BeforeEach
    void setUp() {
        this.factory = new TestStandardHttpClientFactory();
        this.client = new KubernetesClientBuilder().withHttpClientFactory((HttpClient.Factory)this.factory).build();
        this.httpClient = (TestStandardHttpClient)this.factory.getInstances().iterator().next();
    }

    @Test
    @DisplayName(value="With non-existent source path, should throw exception")
    void uploadInvalidSourcePathShouldThrowException(@TempDir Path pathToUpload) {
        CopyOrReadable podUpload = ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace("namespace")).withName("pod")).file("/target/location");
        Path nonExistentPath = pathToUpload.resolve("non-existent");
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> podUpload.upload(nonExistentPath)).withMessage("Provided arguments are not valid (file, directory, path)");
    }

    @Test
    @DisplayName(value="With valid source file and Pod with no containers, should throw exception")
    void uploadInvalidTargetPodThrowException(@TempDir Path pathToUpload) throws IOException {
        this.factory.expect("/api/v1/namespaces/namespace/pods", 200, "{\"metadata\": {}}");
        this.factory.expect("/api/v1/namespaces/namespace/pods/valid-source", 200, "{\"metadata\": {}}");
        CopyOrReadable podUpload = ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace("namespace")).withName("valid-source")).file("/target/location");
        Path validPath = Files.createFile(pathToUpload.resolve("file.txt"), new FileAttribute[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> podUpload.upload(validPath)).isInstanceOf(KubernetesClientException.class)).hasMessage("Pod has no containers!");
    }

    @Test
    @DisplayName(value="With failed upload, attempts to delete temp file")
    void uploadFailureDeletesTemp() {
        WebSocket webSocket = (WebSocket)Mockito.mock(WebSocket.class);
        Mockito.when((Object)webSocket.send((ByteBuffer)ArgumentMatchers.any())).thenReturn((Object)true);
        TestStandardHttpClient.WsFutureProvider future = (s, l) -> {
            l.onOpen(webSocket);
            l.onMessage(webSocket, ByteBuffer.wrap("\u0003 ".getBytes(StandardCharsets.UTF_8)));
            return CompletableFuture.completedFuture(new WebSocketResponse(new WebSocketUpgradeResponse(null), webSocket));
        };
        this.factory.times(2).forEach(i -> {
            this.informPodReady("failure-pod");
            this.httpClient.wsExpect("/api/v1/namespaces/.+/pods/failure-pod/exec", future);
        });
        ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace("default")).withName("failure-pod")).file("/target/location").upload(new File(Objects.requireNonNull(PodUpload.class.getResource("/upload/upload-sample.txt")).getFile()).toPath());
        ((ObjectAssert)Assertions.assertThat((List)this.httpClient.getRecordedBuildWebSocketDirects()).element(1)).extracting(TestStandardHttpClient.RecordedBuildWebSocketDirect::getStandardWebSocketBuilder).extracting(StandardWebSocketBuilder::asHttpRequest).extracting(StandardHttpRequest::uri).extracting(URI::getQuery).asString().contains(new CharSequence[]{"command=rm /target/fabric8-"});
    }

    private ByteBuffer exitZeroEvent() {
        Status success = ((StatusBuilder)new StatusBuilder().withStatus("Success")).build();
        return ByteBuffer.wrap(("\u0003" + this.client.getKubernetesSerialization().asJson((Object)success)).getBytes(StandardCharsets.UTF_8));
    }

    private void informPodReady(String podName) {
        PodList podReadyList = ((PodListBuilder)((PodListFluent.ItemsNested)((PodFluent.StatusNested)((PodStatusFluent.ConditionsNested)((PodStatusFluent.ConditionsNested)((PodListFluent.ItemsNested)((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodListFluent.ItemsNested)((PodFluent.MetadataNested)((PodListBuilder)new PodListBuilder().withNewMetadata().endMetadata()).addNewItem().withNewMetadata().withName(podName)).endMetadata()).withNewSpec().addNewContainer().withName(podName)).endContainer()).endSpec()).withNewStatus().addNewCondition().withType("Ready")).withStatus("True")).endCondition()).endStatus()).endItem()).build();
        this.factory.expect("/api/v1/namespaces/.+/pods", 200, this.client.getKubernetesSerialization().asJson((Object)podReadyList));
    }

    @Nested
    @DisplayName(value="Successful")
    class Success {
        private ScheduledExecutorService executorService;
        private WebSocket webSocket;
        private Path toUpload;

        Success() {
        }

        @BeforeEach
        void setUp() {
            this.executorService = Executors.newSingleThreadScheduledExecutor();
            AtomicInteger tarByteCount = new AtomicInteger(0);
            this.webSocket = (WebSocket)Mockito.mock(WebSocket.class);
            Mockito.when((Object)this.webSocket.send((ByteBuffer)ArgumentMatchers.any())).thenAnswer(i -> {
                tarByteCount.addAndGet(((ByteBuffer)i.getArgument(0)).remaining() - 1);
                return true;
            });
            TestStandardHttpClient.WsFutureProvider future = (s, l) -> {
                l.onOpen(this.webSocket);
                if (s.asHttpRequest().uri().getQuery().contains("command=wc -c")) {
                    l.onMessage(this.webSocket, ByteBuffer.wrap(("\u0001" + tarByteCount.get() + "\n").getBytes(StandardCharsets.UTF_8)));
                }
                this.executorService.schedule(() -> l.onMessage(this.webSocket, UploadTest.this.exitZeroEvent()), 100L, TimeUnit.MILLISECONDS);
                return CompletableFuture.completedFuture(new WebSocketResponse(new WebSocketUpgradeResponse(null), this.webSocket));
            };
            UploadTest.this.factory.times(3).forEach(i -> {
                UploadTest.this.informPodReady("success-pod");
                UploadTest.this.httpClient.wsExpect("/api/v1/namespaces/.+/pods/success-pod/exec", future);
            });
        }

        @AfterEach
        void tearDown() {
            this.executorService.shutdownNow();
        }

        @Nested
        @DisplayName(value="Input stream")
        class Stream {
            private InputStream toUploadIs;

            Stream() {
            }

            @BeforeEach
            void setUp() {
                this.toUploadIs = PodUpload.class.getResourceAsStream("/upload/upload-sample.txt");
            }

            @Test
            @DisplayName(value="upload, returns true")
            void uploadReturnsTrue() {
                boolean result = ((PodResource)((NonNamespaceOperation)UploadTest.this.client.pods().inNamespace("default")).withName("success-pod")).file("/target/location").upload(this.toUploadIs);
                Assertions.assertThat((boolean)result).isTrue();
            }

            @Test
            @DisplayName(value="creates target directory and pipes compressed file in server")
            void createsTempDirectoryAndPipesFileInServer() {
                ((PodResource)((NonNamespaceOperation)UploadTest.this.client.pods().inNamespace("default")).withName("success-pod")).file("/target/location").upload(this.toUploadIs);
                ((ObjectAssert)Assertions.assertThat((List)UploadTest.this.httpClient.getRecordedBuildWebSocketDirects()).element(0)).extracting(TestStandardHttpClient.RecordedBuildWebSocketDirect::getStandardWebSocketBuilder).extracting(StandardWebSocketBuilder::asHttpRequest).extracting(StandardHttpRequest::uri).extracting(URI::getQuery).asString().contains(new CharSequence[]{"command=mkdir -p '/target/' && cat - > '/target/location"});
            }

            @Test
            @DisplayName(value="verifies uploaded file size in server")
            void verifiesUploadedTarSize() {
                ((PodResource)((NonNamespaceOperation)UploadTest.this.client.pods().inNamespace("default")).withName("success-pod")).file("/target/location").upload(this.toUploadIs);
                ((ObjectAssert)Assertions.assertThat((List)UploadTest.this.httpClient.getRecordedBuildWebSocketDirects()).element(1)).extracting(TestStandardHttpClient.RecordedBuildWebSocketDirect::getStandardWebSocketBuilder).extracting(StandardWebSocketBuilder::asHttpRequest).extracting(StandardHttpRequest::uri).extracting(URI::getQuery).asString().contains(new CharSequence[]{"command=wc -c < '/target/location"});
            }
        }

        @Nested
        @DisplayName(value="Directory")
        class Directory {
            Directory() {
            }

            @BeforeEach
            void setUp() {
                Success.this.toUpload = new File(Objects.requireNonNull(PodUpload.class.getResource("/upload_long")).getFile()).toPath();
                Assertions.assertThat((Path)Success.this.toUpload).isDirectory();
            }

            @Test
            @DisplayName(value="upload, returns true")
            void uploadReturnsTrue() {
                boolean result = ((PodResource)((NonNamespaceOperation)UploadTest.this.client.pods().inNamespace("default")).withName("success-pod")).dir("/target/location").upload(Success.this.toUpload);
                Assertions.assertThat((boolean)result).isTrue();
            }

            @Test
            @DisplayName(value="creates temp directory and pipes compressed directory in server")
            void createsTempDirectoryAndPipesDirInServer() {
                ((PodResource)((NonNamespaceOperation)UploadTest.this.client.pods().inNamespace("default")).withName("success-pod")).dir("/target/location").upload(Success.this.toUpload);
                ((ObjectAssert)Assertions.assertThat((List)UploadTest.this.httpClient.getRecordedBuildWebSocketDirects()).element(0)).extracting(TestStandardHttpClient.RecordedBuildWebSocketDirect::getStandardWebSocketBuilder).extracting(StandardWebSocketBuilder::asHttpRequest).extracting(StandardHttpRequest::uri).extracting(URI::getQuery).asString().contains(new CharSequence[]{"command=mkdir -p '/target/location/' && cat - > '/target/location/fabric8-"});
            }

            @Test
            @DisplayName(value="verifies uploaded tar size in server")
            void verifiesUploadedTarSize() {
                ((PodResource)((NonNamespaceOperation)UploadTest.this.client.pods().inNamespace("default")).withName("success-pod")).dir("/target/location").upload(Success.this.toUpload);
                ((ObjectAssert)Assertions.assertThat((List)UploadTest.this.httpClient.getRecordedBuildWebSocketDirects()).element(1)).extracting(TestStandardHttpClient.RecordedBuildWebSocketDirect::getStandardWebSocketBuilder).extracting(StandardWebSocketBuilder::asHttpRequest).extracting(StandardHttpRequest::uri).extracting(URI::getQuery).asString().contains(new CharSequence[]{"command=wc -c < '/target/location/fabric8-"});
            }

            @Test
            @DisplayName(value="extracts tar with file to final location in server")
            void extractsTar() {
                ((PodResource)((NonNamespaceOperation)UploadTest.this.client.pods().inNamespace("default")).withName("success-pod")).dir("/target-dir/location").upload(Success.this.toUpload);
                ((ObjectAssert)Assertions.assertThat((List)UploadTest.this.httpClient.getRecordedBuildWebSocketDirects()).element(2)).extracting(TestStandardHttpClient.RecordedBuildWebSocketDirect::getStandardWebSocketBuilder).extracting(StandardWebSocketBuilder::asHttpRequest).extracting(StandardHttpRequest::uri).extracting(URI::getQuery).asString().matches((CharSequence)".+command=mkdir -p '/target-dir/location/'; tar -C '/target-dir/location/' -xmf /target-dir/location/fabric8-.+\\.tar; e=\\$\\?; rm /target-dir/location/fabric8-.+");
            }
        }

        @Nested
        @DisplayName(value="File")
        class SingleFile {
            SingleFile() {
            }

            @BeforeEach
            void setUp() {
                Success.this.toUpload = new File(Objects.requireNonNull(PodUpload.class.getResource("/upload/upload-sample.txt")).getFile()).toPath();
            }

            @Test
            @DisplayName(value="upload, returns true")
            void uploadReturnsTrue() {
                boolean result = ((PodResource)((NonNamespaceOperation)UploadTest.this.client.pods().inNamespace("default")).withName("success-pod")).file("/target/location").upload(Success.this.toUpload);
                Assertions.assertThat((boolean)result).isTrue();
            }

            @Test
            @DisplayName(value="creates temp directory and pipes compressed file in server")
            void createsTempDirectoryAndPipesFileInServer() {
                ((PodResource)((NonNamespaceOperation)UploadTest.this.client.pods().inNamespace("default")).withName("success-pod")).file("/target/location").upload(Success.this.toUpload);
                ((ObjectAssert)Assertions.assertThat((List)UploadTest.this.httpClient.getRecordedBuildWebSocketDirects()).element(0)).extracting(TestStandardHttpClient.RecordedBuildWebSocketDirect::getStandardWebSocketBuilder).extracting(StandardWebSocketBuilder::asHttpRequest).extracting(StandardHttpRequest::uri).extracting(URI::getQuery).asString().contains(new CharSequence[]{"command=mkdir -p '/target/' && cat - > '/target/fabric8-"});
            }

            @Test
            @DisplayName(value="verifies uploaded tar size in server")
            void verifiesUploadedTarSize() {
                ((PodResource)((NonNamespaceOperation)UploadTest.this.client.pods().inNamespace("default")).withName("success-pod")).file("/target/location").upload(Success.this.toUpload);
                ((ObjectAssert)Assertions.assertThat((List)UploadTest.this.httpClient.getRecordedBuildWebSocketDirects()).element(1)).extracting(TestStandardHttpClient.RecordedBuildWebSocketDirect::getStandardWebSocketBuilder).extracting(StandardWebSocketBuilder::asHttpRequest).extracting(StandardHttpRequest::uri).extracting(URI::getQuery).asString().contains(new CharSequence[]{"command=wc -c < '/target/fabric8-"});
            }

            @Test
            @DisplayName(value="extracts tar with file to final location in server")
            void extractsTar() {
                ((PodResource)((NonNamespaceOperation)UploadTest.this.client.pods().inNamespace("default")).withName("success-pod")).file("/target-dir/location").upload(Success.this.toUpload);
                ((ObjectAssert)Assertions.assertThat((List)UploadTest.this.httpClient.getRecordedBuildWebSocketDirects()).element(2)).extracting(TestStandardHttpClient.RecordedBuildWebSocketDirect::getStandardWebSocketBuilder).extracting(StandardWebSocketBuilder::asHttpRequest).extracting(StandardHttpRequest::uri).extracting(URI::getQuery).asString().matches((CharSequence)".+command=mkdir -p '/target-dir/'; tar -C '/target-dir/' -xmf /target-dir/fabric8-.+\\.tar; e=\\$\\?; rm /target-dir/fabric8-.+");
            }

            @Nested
            @DisplayName(value="Tar compression")
            class TarCompression {
                private ArgumentCaptor<ByteBuffer> sendCaptor;

                TarCompression() {
                }

                @BeforeEach
                void setUp() {
                    this.sendCaptor = ArgumentCaptor.forClass(ByteBuffer.class);
                }

                @Test
                @DisplayName(value="Creates a valid Tar archive from file")
                void validTarArchive() throws Exception {
                    ((PodResource)((NonNamespaceOperation)UploadTest.this.client.pods().inNamespace("default")).withName("success-pod")).file("/target-dir/file-name.txt").upload(Success.this.toUpload);
                    ((WebSocket)Mockito.verify((Object)Success.this.webSocket)).send((ByteBuffer)this.sendCaptor.capture());
                    byte[] tarBytes = new byte[((ByteBuffer)this.sendCaptor.getValue()).remaining() - 1];
                    System.arraycopy(((ByteBuffer)this.sendCaptor.getValue()).array(), 1, tarBytes, 0, tarBytes.length);
                    TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(tarBytes));
                    ((ObjectAssert)Assertions.assertThat((Object)tar.getNextEntry()).hasFieldOrPropertyWithValue("name", (Object)"file-name.txt")).hasFieldOrPropertyWithValue("size", (Object)Success.this.toUpload.toFile().length());
                }

                @Test
                @DisplayName(value="Long file names supported (POSIX)")
                void longFileNamesSupported() throws Exception {
                    String longFileName = String.format("long-file%-100s.txt", "-");
                    ((PodResource)((NonNamespaceOperation)UploadTest.this.client.pods().inNamespace("default")).withName("success-pod")).file("/target-dir/" + longFileName).upload(Success.this.toUpload);
                    ((WebSocket)Mockito.verify((Object)Success.this.webSocket)).send((ByteBuffer)this.sendCaptor.capture());
                    byte[] tarBytes = new byte[((ByteBuffer)this.sendCaptor.getValue()).remaining() - 1];
                    System.arraycopy(((ByteBuffer)this.sendCaptor.getValue()).array(), 1, tarBytes, 0, tarBytes.length);
                    TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(tarBytes));
                    Assertions.assertThat((Object)tar.getNextEntry()).hasFieldOrPropertyWithValue("name", (Object)longFileName);
                }

                @Test
                @DisplayName(value="Big numbers supported (POSIX)")
                void bigNumbersSupported(@TempDir Path tempDir) throws Exception {
                    Path toUploadWithModifiedDate = Files.copy(Success.this.toUpload, tempDir.resolve("upload-sample.txt"), new CopyOption[0]);
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)toUploadWithModifiedDate.toFile().setLastModified(9999999999999L));
                    ((PodResource)((NonNamespaceOperation)UploadTest.this.client.pods().inNamespace("default")).withName("success-pod")).file("/target-dir/file-name.txt").upload(toUploadWithModifiedDate);
                    ((WebSocket)Mockito.verify((Object)Success.this.webSocket)).send((ByteBuffer)this.sendCaptor.capture());
                    byte[] tarBytes = new byte[((ByteBuffer)this.sendCaptor.getValue()).remaining() - 1];
                    System.arraycopy(((ByteBuffer)this.sendCaptor.getValue()).array(), 1, tarBytes, 0, tarBytes.length);
                    TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(tarBytes));
                    ((ObjectAssert)Assertions.assertThat((Object)tar.getNextEntry()).hasFieldOrPropertyWithValue("name", (Object)"file-name.txt")).hasFieldOrPropertyWithValue("lastModifiedTime", (Object)FileTime.fromMillis(9999999999999L));
                }
            }
        }
    }
}

