/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.impl.cache;

import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodListBuilder;
import io.fabric8.kubernetes.api.model.PodListFluent;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.informers.impl.ListerWatcher;
import io.fabric8.kubernetes.client.informers.impl.cache.Reflector;
import io.fabric8.kubernetes.client.informers.impl.cache.SyncableStore;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ReflectorTest {
    ReflectorTest() {
    }

    @Test
    void testStateFlags() {
        ListerWatcher mock = (ListerWatcher)Mockito.mock(ListerWatcher.class);
        PodList list = ((PodListBuilder)((PodListFluent.MetadataNested)new PodListBuilder().withNewMetadata().withResourceVersion("1")).endMetadata()).build();
        Mockito.when((Object)mock.submitList((ListOptions)Mockito.any())).thenReturn(CompletableFuture.completedFuture(list));
        Reflector reflector = new Reflector(mock, (SyncableStore)Mockito.mock(SyncableStore.class));
        Assertions.assertFalse((boolean)reflector.isWatching());
        Assertions.assertFalse((boolean)reflector.isRunning());
        Mockito.when((Object)mock.submitWatch((ListOptions)Mockito.any(), (Watcher)Mockito.any())).thenThrow(new Throwable[]{new KubernetesClientException("error")}).thenReturn(CompletableFuture.completedFuture(Mockito.mock(Watch.class)));
        CompletableFuture future = reflector.start();
        Assertions.assertThrows(CompletionException.class, future::join);
        Assertions.assertFalse((boolean)reflector.isWatching());
        Assertions.assertTrue((boolean)reflector.isRunning());
        reflector.listSyncAndWatch().join();
        Assertions.assertTrue((boolean)reflector.isWatching());
        Assertions.assertTrue((boolean)reflector.isRunning());
        reflector.stop();
        Assertions.assertFalse((boolean)reflector.isWatching());
        Assertions.assertFalse((boolean)reflector.isRunning());
    }

    @Test
    void testNonHttpGone() {
        ListerWatcher mock = (ListerWatcher)Mockito.mock(ListerWatcher.class);
        PodList list = ((PodListBuilder)((PodListFluent.MetadataNested)new PodListBuilder().withNewMetadata().withResourceVersion("1")).endMetadata()).build();
        Mockito.when((Object)mock.submitList((ListOptions)Mockito.any())).thenReturn(CompletableFuture.completedFuture(list));
        Reflector reflector = new Reflector(mock, (SyncableStore)Mockito.mock(SyncableStore.class));
        Mockito.when((Object)mock.submitWatch((ListOptions)Mockito.any(), (Watcher)Mockito.any())).thenReturn(CompletableFuture.completedFuture(Mockito.mock(Watch.class)));
        reflector.start();
        Assertions.assertTrue((boolean)reflector.isWatching());
        Assertions.assertTrue((boolean)reflector.isRunning());
        reflector.getWatcher().onClose(new WatcherException(null));
        Assertions.assertFalse((boolean)reflector.isWatching());
        Assertions.assertFalse((boolean)reflector.isRunning());
    }
}

