/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.impl.cache;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.informers.cache.Cache;
import io.fabric8.kubernetes.client.informers.impl.cache.CacheImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class CacheTest {
    private CacheImpl<Pod> cache;

    CacheTest() {
    }

    @BeforeEach
    void setUp() {
        this.cache = new CacheImpl("mock", CacheTest::mockIndexFunction, CacheTest::mockKeyFunction);
    }

    @Test
    void testCacheIndex() {
        Pod testPodObj = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test-pod")).withResourceVersion("1")).endMetadata()).build();
        this.cache.put((HasMetadata)testPodObj);
        this.replace(this.cache, Collections.singletonList(testPodObj));
        String index = CacheTest.mockIndexFunction(testPodObj).get(0);
        String key = CacheTest.mockKeyFunction(testPodObj);
        List indexedObjectList = this.cache.byIndex("mock", index);
        Assertions.assertEquals((Object)testPodObj, indexedObjectList.get(0));
        indexedObjectList = this.cache.index("mock", (HasMetadata)testPodObj);
        Assertions.assertEquals((Object)testPodObj, indexedObjectList.get(0));
        List allExistingKeys = this.cache.listKeys();
        Assertions.assertEquals((int)1, (int)allExistingKeys.size());
        Assertions.assertEquals((Object)key, allExistingKeys.get(0));
        this.replace(this.cache, Collections.emptyList());
        Assertions.assertEquals((int)0, (int)this.cache.byIndex("mock", "y").size());
    }

    void replace(CacheImpl<Pod> cache, Collection<Pod> replacement) {
        List list = cache.list();
        list.removeAll(replacement);
        for (Pod pod : list) {
            cache.remove((HasMetadata)pod);
        }
        for (Pod pod : replacement) {
            cache.put((HasMetadata)pod);
        }
    }

    @Test
    void testCacheStore() {
        Pod testPodObj = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test-pod2")).withResourceVersion("1")).endMetadata()).build();
        String index = CacheTest.mockIndexFunction(testPodObj).get(0);
        this.replace(this.cache, Collections.singletonList(testPodObj));
        this.cache.remove((HasMetadata)testPodObj);
        List indexedObjectList = this.cache.byIndex("mock", index);
        Assertions.assertEquals((int)0, (int)indexedObjectList.size());
        this.cache.put((HasMetadata)testPodObj);
        String newClusterName = "test_cluster";
        testPodObj.getMetadata().setClusterName(newClusterName);
        this.cache.put((HasMetadata)testPodObj);
        Assertions.assertEquals((int)1, (int)this.cache.list().size());
        Assertions.assertEquals((Object)newClusterName, (Object)testPodObj.getMetadata().getClusterName());
    }

    @Test
    void testDefaultNamespaceIndex() {
        Pod testPodObj = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test-pod3")).withNamespace("default")).endMetadata()).build();
        this.cache.put((HasMetadata)testPodObj);
        List indices = Cache.metaNamespaceIndexFunc((Object)testPodObj);
        Assertions.assertEquals((Object)testPodObj.getMetadata().getNamespace(), indices.get(0));
    }

    @Test
    void testDefaultNamespaceKey() {
        Pod testPodObj = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test-pod4")).withNamespace("default")).endMetadata()).build();
        this.cache.put((HasMetadata)testPodObj);
        Assertions.assertEquals((Object)"", (Object)Cache.metaNamespaceKeyFunc(null));
        Assertions.assertEquals((Object)"default/test-pod4", (Object)Cache.metaNamespaceKeyFunc((Object)testPodObj));
        Assertions.assertEquals((Object)"default/test-pod4", (Object)Cache.namespaceKeyFunc((String)"default", (String)"test-pod4"));
    }

    @Test
    void testEmptyNamespaceKey() {
        Assertions.assertEquals((Object)"test-pod4", (Object)Cache.namespaceKeyFunc((String)"", (String)"test-pod4"));
        Assertions.assertEquals((Object)"test-pod4", (Object)Cache.namespaceKeyFunc(null, (String)"test-pod4"));
    }

    @Test
    void testAddIndexers() {
        CacheImpl podCache = new CacheImpl();
        String nodeIndex = "node-index";
        String clusterIndex = "cluster-index";
        HashMap<String, Function<Pod, List>> indexers = new HashMap<String, Function<Pod, List>>();
        indexers.put(nodeIndex, pod -> Collections.singletonList(pod.getSpec().getNodeName()));
        indexers.put(clusterIndex, pod -> Collections.singletonList(pod.getMetadata().getClusterName()));
        podCache.addIndexers(indexers);
        Pod testPod = ((PodBuilder)((PodFluent.SpecNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withNamespace("test")).withName("test-pod")).withClusterName("test-cluster")).endMetadata()).withNewSpec().withNodeName("test-node")).endSpec()).build();
        podCache.put((HasMetadata)testPod);
        List namespaceIndexedPods = podCache.byIndex("namespace", "test");
        Assertions.assertEquals((int)1, (int)namespaceIndexedPods.size());
        List nodeNameIndexedPods = podCache.byIndex(nodeIndex, "test-node");
        Assertions.assertEquals((int)1, (int)nodeNameIndexedPods.size());
        List clusterNameIndexedPods = podCache.byIndex(clusterIndex, "test-cluster");
        Assertions.assertEquals((int)1, (int)clusterNameIndexedPods.size());
    }

    private static List<String> mockIndexFunction(Object obj) {
        if (obj == null) {
            return Collections.singletonList("null");
        }
        return Collections.singletonList(obj.getClass().getName());
    }

    private static String mockKeyFunction(Object obj) {
        if (obj == null) {
            return "null";
        }
        return String.valueOf(System.identityHashCode(obj));
    }
}

