/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.impl;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.informers.impl.DefaultSharedIndexInformer;
import io.fabric8.kubernetes.client.informers.impl.ListerWatcher;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class DefaultSharedIndexInformerResyncTest {
    private static final Long WAIT_TIME = 500L;
    private final ListerWatcher<Pod, PodList> listerWatcher = (ListerWatcher)Mockito.mock(AbstractPodListerWatcher.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    DefaultSharedIndexInformer<Pod, PodList> defaultSharedIndexInformer;

    DefaultSharedIndexInformerResyncTest() {
    }

    private DefaultSharedIndexInformer<Pod, PodList> createDefaultSharedIndexInformer(long resyncPeriod) {
        this.defaultSharedIndexInformer = new DefaultSharedIndexInformer(Pod.class, this.listerWatcher, resyncPeriod, Runnable::run);
        return this.defaultSharedIndexInformer;
    }

    @AfterEach
    void afterEach() {
        if (this.defaultSharedIndexInformer != null) {
            this.defaultSharedIndexInformer.stop();
        }
    }

    @Test
    @DisplayName(value="Controller initialized with resync period greater than zero should use provided resync period")
    void testControllerCreationWithResyncPeriodMoreThanZero() {
        DefaultSharedIndexInformer<Pod, PodList> controller = this.createDefaultSharedIndexInformer(1000L);
        Assertions.assertEquals((long)1000L, (long)controller.getFullResyncPeriod());
    }

    @Test
    @DisplayName(value="Controller initialized with resync period less than zero should throw exception")
    void testControllerCreationWithResyncPeriodLessThanZero() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.createDefaultSharedIndexInformer(-1L));
    }

    @Test
    @DisplayName(value="Controller initialized with resync period 0 should use provided resync period")
    void testControllerCreationWithResyncPeriodZero() {
        DefaultSharedIndexInformer<Pod, PodList> controller = this.createDefaultSharedIndexInformer(0L);
        Assertions.assertEquals((long)0L, (long)controller.getFullResyncPeriod());
    }

    @Test
    @DisplayName(value="Controller stop shut downs/cancels all executor services")
    void testStop() {
        DefaultSharedIndexInformer<Pod, PodList> controller = this.createDefaultSharedIndexInformer(0L);
        controller.run();
        controller.stop();
        AssertionsForClassTypes.assertThat((boolean)controller.isRunning()).isFalse();
    }

    @Test
    @DisplayName(value="Controller initialized with resync period should initialize resyncExecutor")
    void testControllerRunWithResyncPeriodGreaterThanZero() throws InterruptedException {
        DefaultSharedIndexInformer<Pod, PodList> controller = this.createDefaultSharedIndexInformer(1L);
        controller.run();
        Assertions.assertNotNull((Object)controller.getResyncFuture());
        controller.stop();
        Assertions.assertNull((Object)controller.getResyncFuture());
    }

    @Test
    @DisplayName(value="Controller with resync function throwing exception")
    void testControllerRunsResyncFunctionThrowingException() throws InterruptedException {
        long fullResyncPeriod = 10L;
        int numberOfResyncs = 10;
        CountDownLatch countDown = new CountDownLatch(numberOfResyncs);
        DefaultSharedIndexInformer<Pod, PodList> controller = this.createDefaultSharedIndexInformer(fullResyncPeriod);
        controller.scheduleResync(() -> {
            countDown.countDown();
            if (countDown.getCount() == 2L) {
                throw new RuntimeException("make it fail");
            }
            return true;
        });
        countDown.await(WAIT_TIME, TimeUnit.MILLISECONDS);
        controller.stop();
        AssertionsForClassTypes.assertThat((long)countDown.getCount()).isLessThanOrEqualTo(2L);
    }

    @Test
    @DisplayName(value="Controller initialized with resync period to 0 should not initialize resyncExecutor")
    void testControllerRunWithResyncPeriodToZero() throws InterruptedException {
        DefaultSharedIndexInformer<Pod, PodList> controller = this.createDefaultSharedIndexInformer(0L);
        controller.run();
        Assertions.assertNull((Object)controller.getResyncFuture());
    }

    @Test
    @DisplayName(value="Controller initialized with resync period should run, initialize resyncExecutor and resync at least a given number of times")
    void testControllerRunsReyncFunctionExpectedNumberOfTime() throws InterruptedException {
        long fullResyncPeriod = 10L;
        int numberOfResyncs = 10;
        CountDownLatch countDown = new CountDownLatch(numberOfResyncs);
        DefaultSharedIndexInformer<Pod, PodList> controller = this.createDefaultSharedIndexInformer(fullResyncPeriod);
        controller.scheduleResync(() -> {
            countDown.countDown();
            return true;
        });
        countDown.await(WAIT_TIME, TimeUnit.MILLISECONDS);
        controller.stop();
        Assertions.assertNull((Object)controller.getResyncFuture());
        AssertionsForClassTypes.assertThat((long)countDown.getCount()).isLessThanOrEqualTo(1L);
    }

    @Test
    @DisplayName(value="Controller initialized with resync period to 0 should run but never resync")
    void testControllerNeverRunsReyncFunctionWhenPeriodIsZero() throws InterruptedException {
        int count = 10;
        CountDownLatch countDown = new CountDownLatch(count);
        DefaultSharedIndexInformer<Pod, PodList> controller = this.createDefaultSharedIndexInformer(0L);
        controller.scheduleResync(() -> {
            countDown.countDown();
            return true;
        });
        countDown.await(1000L, TimeUnit.MILLISECONDS);
        controller.stop();
        Assertions.assertNull((Object)controller.getResyncFuture());
        AssertionsForClassTypes.assertThat((long)countDown.getCount()).isEqualTo((long)count);
    }

    private static abstract class AbstractPodListerWatcher
    implements ListerWatcher<Pod, PodList> {
        private AbstractPodListerWatcher() {
        }
    }
}

