/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.OperationSupport;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.TestHttpRequest;
import io.fabric8.kubernetes.client.http.TestHttpResponse;
import java.net.URI;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class OperationSupportTest {
    private OperationSupport operationSupport;

    OperationSupportTest() {
    }

    @BeforeEach
    void setUp() {
        OperationContext context = new OperationContext().withClient((Client)Mockito.mock(Client.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        Mockito.when((Object)context.getClient().getConfiguration()).thenReturn((Object)Config.empty());
        this.operationSupport = new OperationSupport(context);
    }

    @DisplayName(value="checkName, should use operation or item name")
    @ParameterizedTest(name="{index}: operationName: ''{1}'' itemName: ''{2}'', expects: ''{0}''")
    @MethodSource(value={"checkNameInput"})
    void checkName(String expected, String operationName, String itemName) {
        this.operationSupport = new OperationSupport(this.operationSupport.context.withName(operationName));
        Pod item = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(itemName)).endMetadata()).build();
        String result = this.operationSupport.checkName((Object)item);
        Assertions.assertThat((String)result).isEqualTo(expected);
    }

    static Stream<Arguments> checkNameInput() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{null, null, null}), Arguments.arguments((Object[])new Object[]{"operation", "operation", null}), Arguments.arguments((Object[])new Object[]{"item", null, "item"}), Arguments.arguments((Object[])new Object[]{"operation-item-are-the-same", "operation-item-are-the-same", "operation-item-are-the-same"}));
    }

    @Test
    @DisplayName(value="checkName, with different operation and item name, throws Exception")
    void checkNameWithDifferentOperationAndItemNameThrowsException() {
        this.operationSupport = new OperationSupport(this.operationSupport.context.withName("operation-name"));
        Pod item = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("item-name")).endMetadata()).build();
        KubernetesClientException result = (KubernetesClientException)org.junit.jupiter.api.Assertions.assertThrows(KubernetesClientException.class, () -> this.operationSupport.checkName((Object)item));
        Assertions.assertThat((Throwable)result).hasMessageContaining("Name mismatch. Item name:item-name. Operation name:operation-name.");
    }

    @Test
    @DisplayName(value="assertResponse, with successful code, should do nothing")
    void assertResponseCodeSuccessful() {
        TestHttpRequest request = new TestHttpRequest();
        TestHttpResponse response = new TestHttpResponse().withCode(200);
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.lambda$assertResponseCodeSuccessful$1((HttpRequest)request, (HttpResponse)response));
    }

    @Test
    @DisplayName(value="assertResponse, with client error, should throw exception")
    void assertResponseCodeClientError() throws Exception {
        TestHttpRequest request = new TestHttpRequest().withMethod("GET").withUri(new URI("https://example.com"));
        TestHttpResponse response = new TestHttpResponse().withCode(400);
        KubernetesClientException result = (KubernetesClientException)org.junit.jupiter.api.Assertions.assertThrows(KubernetesClientException.class, () -> this.lambda$assertResponseCodeClientError$2((HttpRequest)request, (HttpResponse)response));
        Assertions.assertThat((Throwable)result).hasMessageContaining("Failure executing: GET at: https://example.com. Message: Bad Request.");
    }

    @Test
    @DisplayName(value="assertResponse, with client error and custom message, should throw exception")
    void assertResponseCodeClientErrorAndCustomMessage() throws Exception {
        this.operationSupport.getConfig().getErrorMessages().put(400, "Custom message");
        TestHttpRequest request = new TestHttpRequest().withMethod("GET").withUri(new URI("https://example.com"));
        TestHttpResponse response = new TestHttpResponse().withCode(400);
        KubernetesClientException result = (KubernetesClientException)org.junit.jupiter.api.Assertions.assertThrows(KubernetesClientException.class, () -> this.lambda$assertResponseCodeClientErrorAndCustomMessage$3((HttpRequest)request, (HttpResponse)response));
        Assertions.assertThat((Throwable)result).hasMessageContaining("Failure executing: GET at: https://example.com. Message: Custom message Bad Request.");
    }

    private /* synthetic */ void lambda$assertResponseCodeClientErrorAndCustomMessage$3(HttpRequest request, HttpResponse response) throws Throwable {
        this.operationSupport.assertResponseCode(request, response);
    }

    private /* synthetic */ void lambda$assertResponseCodeClientError$2(HttpRequest request, HttpResponse response) throws Throwable {
        this.operationSupport.assertResponseCode(request, response);
    }

    private /* synthetic */ void lambda$assertResponseCodeSuccessful$1(HttpRequest request, HttpResponse response) throws Throwable {
        this.operationSupport.assertResponseCode(request, response);
    }
}

