/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.CustomResourceList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class HasMetadataOperationsImplTest {
    HasMetadataOperationsImplTest() {
    }

    @Test
    void shouldBeAbleToReturnOperationsWithoutSpecificList() {
        MixedOperation operation = new DefaultKubernetesClient().resources(Bar.class, BarList.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)operation);
    }

    @Test
    void shouldReturnGenericKubernetesResourceWhenNotRegistered() {
        KubernetesResource resource = (KubernetesResource)Serialization.unmarshal((String)"{\n    \"apiVersion\": \"sample.fabric8.io/v1\",\n    \"kind\": \"Bar\"\n}");
        ((ObjectAssert)Assertions.assertThat((Object)resource).isInstanceOf(GenericKubernetesResource.class)).hasFieldOrPropertyWithValue("apiVersion", (Object)"sample.fabric8.io/v1");
    }

    @DisplayName(value="HasMetadataOperationsImpl registers custom kind")
    @ParameterizedTest(name="{index}: {1}")
    @MethodSource(value={"registerCustomKindInput"})
    void hasMetadataOperationsImplRegistersCustomKind(String description, ResourceDefinitionContext resourceDefinitionContext, Class<? extends CustomResource<?, ?>> resourceClazz, Class<? extends CustomResourceList<?>> resourceListClazz) {
        new HasMetadataOperationsImpl(new OperationContext(), resourceDefinitionContext, resourceClazz, resourceListClazz);
        KubernetesResource resource = (KubernetesResource)Serialization.unmarshal((String)"{\n    \"apiVersion\": \"custom.group/v1alpha1\",\n    \"kind\": \"MyCustomResource\"\n}");
        ((ObjectAssert)Assertions.assertThat((Object)resource).isInstanceOf(MyCustomResource.class)).hasFieldOrPropertyWithValue("apiVersion", (Object)"custom.group/v1alpha1");
    }

    static Stream<Arguments> registerCustomKindInput() {
        CustomResourceDefinition myCustomResourceCrd = CustomResourceDefinitionContext.v1beta1CRDFromCustomResourceType(MyCustomResource.class).build();
        return Stream.of(Arguments.arguments((Object[])new Object[]{"with typed custom resource and list", CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)myCustomResourceCrd), MyCustomResource.class, MyCustomResourceList.class}), Arguments.arguments((Object[])new Object[]{"with typed custom resource and generic list", CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)myCustomResourceCrd), MyCustomResource.class, CustomResourceList.class}), Arguments.arguments((Object[])new Object[]{"with manual ResourceDefinitionContext", new ResourceDefinitionContext.Builder().withGroup("custom.group").withVersion("v1alpha1").withPlural("mycustomresources").build(), MyCustomResource.class, MyCustomResourceList.class}));
    }

    public static class BarList
    extends CustomResourceList<Bar> {
    }

    @Group(value="sample.fabric8.io")
    @Version(value="v1")
    public static class Bar
    extends CustomResource<Object, Object> {
    }

    public static class MyCustomResourceList
    extends CustomResourceList<MyCustomResource> {
    }

    @Group(value="custom.group")
    @Version(value="v1alpha1")
    public static class MyCustomResource
    extends CustomResource<Object, Object> {
        public static final String GROUP = "custom.group";
        public static final String VERSION = "v1alpha1";
    }
}

