/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.core.v1;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.PodOperationsImpl;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;

class PodOperationsImpl_CVE2021_20218_Test {
    private PodOperationContext baseContext;

    PodOperationsImpl_CVE2021_20218_Test() {
    }

    @BeforeEach
    void setUp() {
        this.baseContext = new PodOperationContext();
    }

    @Test
    void testWithForgedTar(@TempDir Path targetDirParent) throws Exception {
        Path targetDir = targetDirParent.resolve("target");
        PodOperationsImpl poi = (PodOperationsImpl)Mockito.spy((Object)new PodOperationsImpl(this.baseContext.withDir("/var/source-dir"), new OperationContext()));
        ((PodOperationsImpl)Mockito.doReturn((Object)PodOperationsImpl_CVE2021_20218_Test.class.getResourceAsStream("/2021_20218/tar-with-parent-traversal.tar")).when((Object)poi)).readTar("/var/source-dir");
        KubernetesClientException exception = (KubernetesClientException)org.junit.jupiter.api.Assertions.assertThrows(KubernetesClientException.class, () -> poi.copy(targetDir));
        Assertions.assertThat((Throwable)exception).getCause().hasMessage("Tar entry '../youve-been-hacked' has an invalid name");
        Assertions.assertThat((Path)targetDirParent).isDirectoryNotContaining("glob:**/youve-been-hacked");
    }

    @Test
    void testWithValidTar(@TempDir Path targetDirParent) throws Exception {
        Path targetDir = targetDirParent.resolve("target");
        PodOperationsImpl poi = (PodOperationsImpl)Mockito.spy((Object)new PodOperationsImpl(this.baseContext.withDir("/var/source-dir"), new OperationContext()));
        ((PodOperationsImpl)Mockito.doReturn((Object)PodOperationsImpl_CVE2021_20218_Test.class.getResourceAsStream("/2021_20218/valid.tar")).when((Object)poi)).readTar("/var/source-dir");
        boolean result = poi.copy(targetDir);
        Assertions.assertThat((boolean)result).isTrue();
        Assertions.assertThat((Path)targetDir).isDirectoryContaining("glob:**/hello.txt").isDirectoryRecursivelyContaining("glob:**/very/nested/dir/answer.txt");
    }
}

