/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.WatchHTTPManager;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class WatchHttpManagerTest {
    WatchHttpManagerTest() {
    }

    @Test
    void testReconnectOnException() throws MalformedURLException, InterruptedException {
        HttpClient client = (HttpClient)Mockito.mock(HttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        HttpClient.DerivedClientBuilder builder = (HttpClient.DerivedClientBuilder)Mockito.mock(HttpClient.DerivedClientBuilder.class, (Answer)Mockito.RETURNS_SELF);
        Mockito.when((Object)client.newBuilder()).thenReturn((Object)builder);
        Mockito.when((Object)builder.build()).thenReturn((Object)client);
        BaseOperation baseOperation = (BaseOperation)Mockito.mock(BaseOperation.class);
        Mockito.when((Object)baseOperation.getNamespacedUrl()).thenReturn((Object)new URL("http://localhost"));
        CompletableFuture future = new CompletableFuture();
        Mockito.when((Object)client.consumeLines((HttpRequest)Mockito.any(), (HttpClient.BodyConsumer)Mockito.any())).thenReturn(future);
        final CountDownLatch reconnect = new CountDownLatch(1);
        WatchHTTPManager watch = new WatchHTTPManager(client, baseOperation, (ListOptions)Mockito.mock(ListOptions.class), (Watcher)Mockito.mock(Watcher.class), 1, 0){

            void scheduleReconnect() {
                reconnect.countDown();
            }
        };
        future.completeExceptionally(new IOException());
        Assertions.assertTrue((boolean)reconnect.await(1L, TimeUnit.SECONDS));
    }
}

