/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.extensions.v1beta1;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetList;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollableScalableResourceOperation;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.client.dsl.internal.extensions.v1beta1.ReplicaSetRollingUpdater;
import io.fabric8.kubernetes.client.utils.internal.PodOperationUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ReplicaSetOperationsImpl
extends RollableScalableResourceOperation<ReplicaSet, ReplicaSetList, RollableScalableResource<ReplicaSet>>
implements TimeoutImageEditReplacePatchable<ReplicaSet> {
    public ReplicaSetOperationsImpl(Client client) {
        this(new RollingOperationContext(), HasMetadataOperationsImpl.defaultContext(client));
    }

    ReplicaSetOperationsImpl(RollingOperationContext context, OperationContext superContext) {
        super(context, superContext.withApiGroupName("extensions").withApiGroupVersion("v1beta1").withPlural("replicasets"), ReplicaSet.class, ReplicaSetList.class);
    }

    @Override
    public ReplicaSetOperationsImpl newInstance(OperationContext context) {
        return new ReplicaSetOperationsImpl(this.rollingOperationContext, context);
    }

    public ReplicaSetOperationsImpl newInstance(RollingOperationContext context) {
        return new ReplicaSetOperationsImpl(context, this.context);
    }

    @Override
    public ReplicaSet pause() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" pausing is not supported");
    }

    @Override
    public ReplicaSet resume() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" resuming is not supported");
    }

    @Override
    public ReplicaSet restart() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" restarting is not supported");
    }

    @Override
    public ReplicaSet undo() {
        throw new UnsupportedOperationException("no rollbacker has been implemented for \"" + ((ReplicaSet)this.get()).getKind() + "\"");
    }

    @Override
    public ReplicaSet withReplicas(int count) {
        return this.accept((T r) -> r.getSpec().setReplicas(Integer.valueOf(count)));
    }

    @Override
    public RollingUpdater<ReplicaSet, ReplicaSetList> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new ReplicaSetRollingUpdater(this.context.getClient(), this.getNamespace(), rollingTimeUnit.toMillis(rollingTimeout), this.config.getLoggingInterval());
    }

    @Override
    public int getCurrentReplicas(ReplicaSet current) {
        return current.getStatus().getReplicas();
    }

    @Override
    public int getDesiredReplicas(ReplicaSet item) {
        return item.getSpec().getReplicas();
    }

    @Override
    public long getObservedGeneration(ReplicaSet current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }

    @Override
    public Status rollback(DeploymentRollback deploymentRollback) {
        throw new KubernetesClientException("rollback not supported in case of ReplicaSets");
    }

    @Override
    public String getLog(boolean isPretty) {
        StringBuilder stringBuilder = new StringBuilder();
        List<PodResource> podOperationList = this.doGetLog(isPretty);
        for (PodResource podOperation : podOperationList) {
            stringBuilder.append(podOperation.getLog(isPretty));
        }
        return stringBuilder.toString();
    }

    private List<PodResource> doGetLog(boolean isPretty) {
        ReplicaSet replicaSet = (ReplicaSet)this.requireFromServer();
        return PodOperationUtil.getPodOperationsForController(this.context, replicaSet.getMetadata().getUid(), ReplicaSetOperationsImpl.getReplicaSetSelectorLabels(replicaSet), isPretty, this.rollingOperationContext.getLogWaitTimeout(), this.rollingOperationContext.getContainerId());
    }

    @Override
    public Reader getLogReader() {
        return PodOperationUtil.getLogReader(this.doGetLog(false));
    }

    @Override
    public InputStream getLogInputStream() {
        return PodOperationUtil.getLogInputStream(this.doGetLog(false));
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        return PodOperationUtil.watchLog(this.doGetLog(false), out);
    }

    static Map<String, String> getReplicaSetSelectorLabels(ReplicaSet replicaSet) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (replicaSet != null && replicaSet.getSpec() != null && replicaSet.getSpec().getSelector() != null) {
            labels.putAll(replicaSet.getSpec().getSelector().getMatchLabels());
        }
        return labels;
    }

    @Override
    protected List<Container> getContainers(ReplicaSet value) {
        return value.getSpec().getTemplate().getSpec().getContainers();
    }
}

