/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.certificates.v1;

import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequest;
import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestCondition;
import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestList;
import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestStatus;
import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestStatusBuilder;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.CertificateSigningRequestResource;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import java.io.IOException;

public class CertificateSigningRequestOperationsImpl
extends HasMetadataOperation<CertificateSigningRequest, CertificateSigningRequestList, CertificateSigningRequestResource<CertificateSigningRequest>>
implements CertificateSigningRequestResource<CertificateSigningRequest> {
    public CertificateSigningRequestOperationsImpl(Client client) {
        this(HasMetadataOperationsImpl.defaultContext(client));
    }

    CertificateSigningRequestOperationsImpl(OperationContext context) {
        super(context.withApiGroupName("certificates.k8s.io").withApiGroupVersion("v1").withPlural("certificatesigningrequests"), CertificateSigningRequest.class, CertificateSigningRequestList.class);
    }

    @Override
    public CertificateSigningRequestOperationsImpl newInstance(OperationContext context) {
        return new CertificateSigningRequestOperationsImpl(context);
    }

    @Override
    public CertificateSigningRequest approve(CertificateSigningRequestCondition certificateSigningRequestCondition) {
        return this.addStatusToCSRAndSubmit(certificateSigningRequestCondition);
    }

    @Override
    public CertificateSigningRequest deny(CertificateSigningRequestCondition certificateSigningRequestCondition) {
        return this.addStatusToCSRAndSubmit(certificateSigningRequestCondition);
    }

    private CertificateSigningRequest addStatusToCSRAndSubmit(CertificateSigningRequestCondition certificateSigningRequestCondition) {
        try {
            CertificateSigningRequest fromServerCsr = (CertificateSigningRequest)this.fromServer().get();
            fromServerCsr.setStatus(this.createCertificateSigningRequestStatus(certificateSigningRequestCondition));
            return this.handleApproveOrDeny(fromServerCsr, CertificateSigningRequest.class);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("approval " + this.type), (Throwable)ie);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("approval " + this.type), (Throwable)e);
        }
    }

    private CertificateSigningRequestStatus createCertificateSigningRequestStatus(CertificateSigningRequestCondition certificateSigningRequestCondition) {
        return ((CertificateSigningRequestStatusBuilder)new CertificateSigningRequestStatusBuilder().addToConditions(new CertificateSigningRequestCondition[]{certificateSigningRequestCondition})).build();
    }
}

