/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.OperationSupport;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchHTTPManager<T extends HasMetadata, L extends KubernetesResourceList<T>>
extends AbstractWatchManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(WatchHTTPManager.class);
    private CompletableFuture<HttpResponse<HttpClient.AsyncBody>> call;

    public WatchHTTPManager(HttpClient client, BaseOperation<T, L, ?> baseOperation, ListOptions listOptions, Watcher<T> watcher, int reconnectInterval, int reconnectLimit) throws MalformedURLException {
        this(client, baseOperation, listOptions, watcher, reconnectInterval, reconnectLimit, 5);
    }

    public WatchHTTPManager(HttpClient client, BaseOperation<T, L, ?> baseOperation, ListOptions listOptions, Watcher<T> watcher, int reconnectInterval, int reconnectLimit, int maxIntervalExponent) throws MalformedURLException {
        super(watcher, baseOperation, listOptions, reconnectLimit, reconnectInterval, maxIntervalExponent, () -> client.newBuilder().readTimeout(0L, TimeUnit.MILLISECONDS).forStreaming().build());
    }

    @Override
    protected synchronized void start(URL url, Map<String, String> headers) {
        HttpRequest.Builder builder = this.client.newHttpRequestBuilder().url(url);
        headers.forEach(builder::header);
        this.call = this.client.consumeLines(builder.build(), (s, a) -> {
            this.onMessage((String)s);
            a.consume();
        });
        this.call.whenComplete((response, t) -> {
            if (!this.call.isCancelled() && t != null) {
                logger.info("Watch connection failed. reason: {}", (Object)t.getMessage());
                this.scheduleReconnect();
            }
            if (response != null) {
                HttpClient.AsyncBody body = (HttpClient.AsyncBody)response.body();
                if (!response.isSuccessful()) {
                    body.cancel();
                    if (this.onStatus(OperationSupport.createStatus(response.code(), response.message()))) {
                        return;
                    }
                    if (!this.call.isCancelled()) {
                        this.scheduleReconnect();
                    }
                } else {
                    this.resetReconnectAttempts();
                    body.consume();
                    body.done().whenComplete((v, e) -> {
                        if (e != null) {
                            logger.info("Watch terminated unexpectedly. reason: {}", (Object)e.getMessage());
                        }
                        if (!this.call.isCancelled()) {
                            this.scheduleReconnect();
                        }
                    });
                }
            }
        });
    }

    @Override
    protected synchronized void closeRequest() {
        if (this.call != null) {
            this.call.cancel(true);
            this.call = null;
        }
    }
}

