/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.APIResourceList;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.ResourceHandlerImpl;
import io.fabric8.kubernetes.client.dsl.NamespacedInOutCreateable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class Handlers {
    private final Map<Class<?>, ResourceHandler<?, ?>> resourceHandlers = new ConcurrentHashMap();
    private final Map<List<String>, ResourceDefinitionContext> genericDefinitions = new ConcurrentHashMap<List<String>, ResourceDefinitionContext>();

    public <T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>> void register(Class<T> type, Function<Client, HasMetadataOperation<T, L, R>> operationConstructor) {
        if (this.resourceHandlers.put(type, new ResourceHandlerImpl(type, operationConstructor)) != null) {
            throw new AssertionError((Object)String.format("%s already registered", type.getName()));
        }
    }

    public <T extends HasMetadata> void unregister(Class<T> type) {
        this.resourceHandlers.remove(type);
    }

    public <T extends HasMetadata, V extends VisitableBuilder<T, V>> ResourceHandler<T, V> get(T meta, Client client) {
        ResourceDefinitionContext rdc;
        Class<?> type = meta.getClass();
        if (type.equals(GenericKubernetesResource.class) && (rdc = this.getResourceDefinitionContext((GenericKubernetesResource)meta, client)) != null) {
            return new ResourceHandlerImpl(GenericKubernetesResource.class, GenericKubernetesResourceList.class, rdc);
        }
        ResourceHandler<?, V> result = this.get(type);
        if (result == null) {
            throw new KubernetesClientException("Could not find a registered handler for item: [" + meta + "].");
        }
        return result;
    }

    public ResourceDefinitionContext getResourceDefinitionContext(String apiVersion, String kind, BaseClient client) {
        GenericKubernetesResource resource = new GenericKubernetesResource();
        resource.setKind(kind);
        resource.setApiVersion(apiVersion);
        return this.getResourceDefinitionContext(resource, client);
    }

    public <T extends HasMetadata> ResourceDefinitionContext getResourceDefinitionContext(GenericKubernetesResource meta, Client client) {
        Object value = Serialization.unmarshal(Serialization.asJson(meta));
        Class<?> parsedType = value.getClass();
        ResourceDefinitionContext rdc = null;
        if (!parsedType.equals(GenericKubernetesResource.class)) {
            rdc = ResourceDefinitionContext.fromResourceType(parsedType);
        } else if (client != null) {
            String kind = meta.getKind();
            String apiVersion = meta.getApiVersion();
            if (kind == null || apiVersion == null) {
                return null;
            }
            String api = ApiVersionUtil.trimGroupOrNull(apiVersion);
            if (api == null) {
                return null;
            }
            String version = ApiVersionUtil.trimVersion(apiVersion);
            rdc = this.genericDefinitions.computeIfAbsent(Arrays.asList(kind, apiVersion), k -> {
                APIResourceList resourceList = client.getApiResources(apiVersion);
                if (resourceList == null) {
                    return null;
                }
                return resourceList.getResources().stream().filter(r -> kind.equals(r.getKind())).findFirst().map(resource -> new ResourceDefinitionContext.Builder().withGroup(api).withKind(kind).withNamespaced(Boolean.TRUE.equals(resource.getNamespaced())).withPlural(resource.getName()).withVersion(version).build()).orElse(null);
            });
        }
        return rdc;
    }

    private <T extends HasMetadata, V extends VisitableBuilder<T, V>> ResourceHandler<T, V> get(Class<T> type) {
        if (type.equals(GenericKubernetesResource.class)) {
            return null;
        }
        return this.resourceHandlers.computeIfAbsent(type, k -> new ResourceHandlerImpl(type, null));
    }

    public <T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>> HasMetadataOperation<T, L, R> getOperation(Class<T> type, Class<L> listType, Client client) {
        ResourceHandler resourceHandler = this.get(type);
        if (resourceHandler == null) {
            throw new IllegalStateException();
        }
        return resourceHandler.operation(client, listType);
    }

    public <T extends HasMetadata> HasMetadataOperation<T, ?, Resource<T>> getNonListingOperation(Class<T> type, Client client) {
        return this.getOperation(type, KubernetesResourceUtil.inferListType(type), client);
    }

    public <T extends HasMetadata> NamespacedInOutCreateable<T, T> getNamespacedHasMetadataCreateOnlyOperation(Class<T> type, Client client) {
        HasMetadataOperation<T, ?, Resource<T>> operation = this.getNonListingOperation(type, client);
        return operation::inNamespace;
    }
}

