/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.client.internal.KubeConfigUtils;
import io.fabric8.kubernetes.client.utils.OpenIDConnectionUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class OpenIDConnectionUtilsTest {
    OkHttpClient mockClient = (OkHttpClient)Mockito.mock(OkHttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);

    OpenIDConnectionUtilsTest() {
    }

    @Test
    void testLoadTokenURL() throws IOException {
        String openIdIssuer = "https://accounts.example.com";
        String tokenEndpointResponse = "{\"issuer\": \"https://accounts.example.com\", \"token_endpoint\": \"https://oauth2.exampleapis.com/token\"}";
        this.mockOkHttpClient(200, tokenEndpointResponse);
        Map discoveryDocumentMap = OpenIDConnectionUtils.getOIDCDiscoveryDocumentAsMap((OkHttpClient)this.mockClient, (String)openIdIssuer);
        Assertions.assertNotNull((Object)discoveryDocumentMap);
        Assertions.assertEquals((Object)"https://oauth2.exampleapis.com/token", discoveryDocumentMap.get("token_endpoint"));
    }

    @Test
    void testLoadTokenURLWhenNotFound() throws IOException {
        String openIdIssuer = "https://accounts.example.com";
        String tokenEndpointResponse = "{}";
        this.mockOkHttpClient(404, tokenEndpointResponse);
        Map discoveryDocumentAsMap = OpenIDConnectionUtils.getOIDCDiscoveryDocumentAsMap((OkHttpClient)this.mockClient, (String)openIdIssuer);
        Assertions.assertTrue((boolean)discoveryDocumentAsMap.isEmpty());
    }

    @Test
    void testGetWellKnownUrlForOpenIDIssuer() {
        String openIdIssuer = "https://accounts.example.com";
        String wellKnownUrl = OpenIDConnectionUtils.getWellKnownUrlForOpenIDIssuer((String)openIdIssuer);
        Assertions.assertEquals((Object)"https://accounts.example.com/.well-known/openid-configuration", (Object)wellKnownUrl);
    }

    @Test
    void testRefreshOidcToken() throws IOException {
        String clientId = "test-client-id";
        String refreshToken = "test-refresh-token";
        String clientSecret = "test-client-secret";
        String tokenEndpointUrl = "https://oauth2.exampleapis.com/token";
        this.mockOkHttpClient(200, "{\"id_token\":\"thisisatesttoken\",\"access_token\": \"thisisrefreshtoken\",\"expires_in\": 3599,\"scope\": \"openid https://www.exampleapis.com/auth/userinfo.email\",\"token_type\": \"Bearer\"}");
        Map response = OpenIDConnectionUtils.refreshOidcToken((OkHttpClient)this.mockClient, (String)clientId, (String)refreshToken, (String)clientSecret, (String)tokenEndpointUrl);
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((Object)"thisisatesttoken", response.get("id_token"));
    }

    @Test
    void testFetchOIDCProviderDiscoveryDocumentAndRefreshToken() throws IOException {
        HashMap<String, String> discoveryDocument = new HashMap<String, String>();
        discoveryDocument.put("token_endpoint", "https://oauth2.exampleapis.com/token");
        String accessToken = "some.access.token";
        String clientId = "test-client-id";
        String refreshToken = "test-refresh-token";
        String clientSecret = "test-client-secret";
        this.mockOkHttpClient(200, "{\"id_token\":\"thisisatesttoken\",\"access_token\": \"thisisrefreshtoken\",\"expires_in\": 3599,\"scope\": \"openid https://www.exampleapis.com/auth/userinfo.email\",\"token_type\": \"Bearer\"}");
        String newAccessToken = OpenIDConnectionUtils.getOIDCProviderTokenEndpointAndRefreshToken((OkHttpClient)this.mockClient, discoveryDocument, (String)clientId, (String)refreshToken, (String)clientSecret, (String)accessToken, (boolean)false);
        Assertions.assertNotNull((Object)newAccessToken);
        Assertions.assertEquals((Object)"thisisatesttoken", (Object)newAccessToken);
    }

    @Test
    void testPersistKubeConfigWithUpdatedToken() throws IOException {
        HashMap<String, String> openIdProviderResponse = new HashMap<String, String>();
        openIdProviderResponse.put("id_token", "id-token-updated");
        openIdProviderResponse.put("refresh_token", "refresh-token-updated");
        File tempFile = Files.createTempFile("test", "kubeconfig", new FileAttribute[0]).toFile();
        Files.copy(this.getClass().getResourceAsStream("/test-kubeconfig-oidc"), Paths.get(tempFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        boolean isPersisted = OpenIDConnectionUtils.persistKubeConfigWithUpdatedToken((String)tempFile.getAbsolutePath(), openIdProviderResponse);
        Assertions.assertTrue((boolean)isPersisted);
        Config config = KubeConfigUtils.parseConfig((File)tempFile);
        Assertions.assertNotNull((Object)config);
        NamedContext currentNamedContext = KubeConfigUtils.getCurrentContext((Config)config);
        Assertions.assertNotNull((Object)currentNamedContext);
        int currentUserIndex = KubeConfigUtils.getNamedUserIndexFromConfig((Config)config, (String)currentNamedContext.getContext().getUser());
        Assertions.assertTrue((currentUserIndex > 0 ? 1 : 0) != 0);
        Map authProviderConfig = ((NamedAuthInfo)config.getUsers().get(currentUserIndex)).getUser().getAuthProvider().getConfig();
        Assertions.assertFalse((boolean)authProviderConfig.isEmpty());
        Assertions.assertEquals((Object)"id-token-updated", authProviderConfig.get("id-token"));
        Assertions.assertEquals((Object)"refresh-token-updated", authProviderConfig.get("refresh-token"));
    }

    @Test
    void testResolveOIDCTokenFromAuthConfigShouldReturnOldTokenWhenRefreshNotSupported() {
        HashMap<String, String> currentAuthProviderConfig = new HashMap<String, String>();
        currentAuthProviderConfig.put("client-id", "client-id");
        currentAuthProviderConfig.put("client-secret", "client-secret");
        currentAuthProviderConfig.put("id-token", "id-token");
        String token = OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig(currentAuthProviderConfig);
        Assertions.assertEquals((Object)"id-token", (Object)token);
    }

    @Test
    void testgetParametersFromDiscoveryResponse() {
        HashMap<String, String> discoveryDocument = new HashMap<String, String>();
        discoveryDocument.put("issuer", "https://api.login.example.com");
        discoveryDocument.put("token_endpoint", "https//api.login.example.com/oauth2/get_token");
        discoveryDocument.put("jwks_uri", "https//api.login.example.com/openid/v1/certs");
        Assertions.assertEquals((Object)"https//api.login.example.com/oauth2/get_token", (Object)OpenIDConnectionUtils.getParametersFromDiscoveryResponse(discoveryDocument, (String)"token_endpoint"));
        Assertions.assertEquals((Object)"", (Object)OpenIDConnectionUtils.getParametersFromDiscoveryResponse(discoveryDocument, (String)"userinfo_endpoint"));
    }

    private void mockOkHttpClient(int responseCode, String responseAsStr) throws IOException {
        Call mockCall = (Call)Mockito.mock(Call.class);
        Response mockSuccessResponse = this.mockResponse(responseCode, responseAsStr);
        Mockito.when((Object)mockCall.execute()).thenReturn((Object)mockSuccessResponse);
        Mockito.when((Object)this.mockClient.newCall((Request)ArgumentMatchers.any())).thenReturn((Object)mockCall);
    }

    private Response mockResponse(int responseCode, String responseBody) {
        return new Response.Builder().request(new Request.Builder().url("http://mock").build()).protocol(Protocol.HTTP_1_1).code(responseCode).body(ResponseBody.create((MediaType)MediaType.get((String)"application/json"), (String)responseBody)).message("mock").build();
    }
}

