/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.utils.ReflectUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReflectUtilsTest {
    @Test
    public void testDirectReflection() throws ReflectiveOperationException {
        ObjectMeta meta = new ObjectMeta();
        Foo foo = new Foo();
        foo.setMetadata(meta);
        Assertions.assertSame((Object)meta, (Object)ReflectUtils.objectMetadata((Object)foo));
    }

    @Test
    public void testDerivedReflection() throws ReflectiveOperationException {
        ObjectMeta meta = new ObjectMeta();
        Bar bar = new Bar();
        bar.setMetadata(meta);
        Assertions.assertSame((Object)meta, (Object)ReflectUtils.objectMetadata((Object)bar));
    }

    @Test
    public void testInstanceOf() throws ReflectiveOperationException {
        ObjectMeta meta = new ObjectMeta();
        Baz baz = new Baz();
        baz.setMetadata(meta);
        Assertions.assertSame((Object)meta, (Object)ReflectUtils.objectMetadata((Object)baz));
    }

    @Test
    void testObjectMetadataReturnsNullOnNull() throws ReflectiveOperationException {
        Object input = null;
        ObjectMeta result = ReflectUtils.objectMetadata(input);
        AssertionsForClassTypes.assertThat((Object)result).isNull();
    }

    @Test
    void testNamespaceReturnsValidNamespace() throws ReflectiveOperationException {
        ConfigMap input = ((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withNamespace("ns1")).endMetadata()).build();
        String result = ReflectUtils.namespace((Object)input);
        ((AbstractStringAssert)AssertionsForClassTypes.assertThat((String)result).isNotNull()).isEqualTo("ns1");
    }

    @Test
    void testNamespaceReturnsBlankNamespace() throws ReflectiveOperationException {
        Object input = null;
        String result = ReflectUtils.namespace(input);
        ((AbstractStringAssert)AssertionsForClassTypes.assertThat((String)result).isNotNull()).isBlank();
    }

    static class Baz
    extends AbstractBaz {
        Baz() {
        }

        public String getKind() {
            return Baz.class.getSimpleName();
        }
    }

    static abstract class AbstractBaz
    implements HasMetadata {
        private ObjectMeta metadata;
        private String apiVersion;

        AbstractBaz() {
        }

        public void setMetadata(ObjectMeta metadata) {
            this.metadata = metadata;
        }

        public ObjectMeta getMetadata() {
            return this.metadata;
        }

        public void setApiVersion(String version) {
            this.apiVersion = version;
        }

        public String getApiVersion() {
            return this.apiVersion;
        }
    }

    static class Bar
    extends Foo {
        Bar() {
        }
    }

    static class Foo {
        private ObjectMeta metadata;

        Foo() {
        }

        public void setMetadata(ObjectMeta metadata) {
            this.metadata = metadata;
        }

        public ObjectMeta getMetadata() {
            return this.metadata;
        }
    }
}

