/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.DeleteOptionsBuilder;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.internal.RawCustomResourceOperationsImpl;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.Buffer;
import okio.BufferedSink;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class RawCustomResourceOperationsImplTest {
    private OkHttpClient mockClient;
    private Config config;
    private CustomResourceDefinitionContext namespacedCustomResourceDefinitionContext;
    private RawCustomResourceOperationsImpl namespacedOperations;
    private RawCustomResourceOperationsImpl clusterOperations;
    private ArgumentCaptor<Request> captor;

    RawCustomResourceOperationsImplTest() {
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.mockClient = (OkHttpClient)Mockito.mock(OkHttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://localhost:8443/")).build();
        this.namespacedCustomResourceDefinitionContext = new CustomResourceDefinitionContext.Builder().withGroup("test.fabric8.io").withName("hellos.test.fabric8.io").withPlural("hellos").withScope("Namespaced").withVersion("v1alpha1").build();
        CustomResourceDefinitionContext clusterCustomResourceDefinitionContext = new CustomResourceDefinitionContext.Builder().withGroup("test.fabric8.io").withName("hellos.test.fabric8.io").withPlural("hellos").withScope("Cluster").withVersion("v1alpha1").build();
        this.namespacedOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, this.namespacedCustomResourceDefinitionContext);
        this.clusterOperations = new RawCustomResourceOperationsImpl(this.mockClient, this.config, clusterCustomResourceDefinitionContext);
        this.captor = ArgumentCaptor.forClass(Request.class);
    }

    @Test
    @DisplayName(value="load, with valid InputStream, should load a valid Map")
    void loadWithInputStream() throws IOException {
        Map result = this.namespacedOperations.load(RawCustomResourceOperationsImplTest.class.getResourceAsStream("/raw-custom-resource-operations/custom-resource.yml"));
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)result).isNotNull()).hasFieldOrPropertyWithValue("metadata.name", (Object)"custom-resource-example")).hasFieldOrPropertyWithValue("spec.field", (Object)"value");
    }

    @Test
    @DisplayName(value="load, with valid object string, should load a valid Map")
    void loadWithObjectString() throws IOException {
        Map result = this.namespacedOperations.load("{\"metadata\":{\"name\":\"custom-resource-example\"}, \"spec\": {\"field\": \"value\"}}");
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)result).isNotNull()).hasFieldOrPropertyWithValue("metadata.name", (Object)"custom-resource-example")).hasFieldOrPropertyWithValue("spec.field", (Object)"value");
    }

    @Test
    @DisplayName(value="create, with valid object string, should create")
    void createFromObjectString() throws IOException {
        this.mockCallWithResponse(i -> this.buildResponse(201, "{\"metadata\": {\"resourceVersion\": \"created\"}}"), new Function[0]);
        Map result = this.clusterOperations.create("{\"metadata\":{\"name\":\"custom-resource-example\"}}");
        ((MapAssert)Assertions.assertThat((Map)result).isNotNull()).hasFieldOrPropertyWithValue("metadata.resourceVersion", (Object)"created");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/hellos", "POST");
    }

    @Test
    @DisplayName(value="create, with valid Map, should create")
    void createFromMap() throws IOException {
        this.mockCallWithResponse(i -> this.buildResponse(201, "{\"metadata\": {\"resourceVersion\": \"created\"}}"), new Function[0]);
        Map result = this.clusterOperations.create(Collections.singletonMap("metadata", Collections.singletonMap("name", "custom-resource-example")));
        ((MapAssert)Assertions.assertThat((Map)result).isNotNull()).hasFieldOrPropertyWithValue("metadata.resourceVersion", (Object)"created");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/hellos", "POST");
    }

    @Test
    @DisplayName(value="create, with valid InputStream, should create")
    void createFromInputStream() throws IOException {
        this.mockCallWithResponse(i -> this.buildResponse(201, "{\"metadata\": {\"resourceVersion\": \"created\"}}"), new Function[0]);
        Map result = this.clusterOperations.create(RawCustomResourceOperationsImplTest.class.getResourceAsStream("/raw-custom-resource-operations/custom-resource.yml"));
        ((MapAssert)Assertions.assertThat((Map)result).isNotNull()).hasFieldOrPropertyWithValue("metadata.resourceVersion", (Object)"created");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/hellos", "POST");
    }

    @Test
    @DisplayName(value="create, with namespace and valid InputStream, should create")
    void createWithNamespaceFromInputStream() throws IOException {
        this.mockCallWithResponse(i -> this.buildResponse(201, "{\"metadata\": {\"resourceVersion\": \"created\"}}"), new Function[0]);
        Map result = this.namespacedOperations.create("other-namespace", RawCustomResourceOperationsImplTest.class.getResourceAsStream("/raw-custom-resource-operations/custom-resource.yml"));
        ((MapAssert)Assertions.assertThat((Map)result).isNotNull()).hasFieldOrPropertyWithValue("metadata.resourceVersion", (Object)"created");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/other-namespace/hellos", "POST");
    }

    @Test
    @DisplayName(value="create, with namespace and valid Map, should create")
    void createWithNamespaceFromMap() throws IOException {
        this.mockCallWithResponse(i -> this.buildResponse(201, "{\"metadata\": {\"resourceVersion\": \"created\"}}"), new Function[0]);
        Map result = this.namespacedOperations.create("other-namespace", Collections.singletonMap("metadata", Collections.singletonMap("name", "custom-resource-example")));
        ((MapAssert)Assertions.assertThat((Map)result).isNotNull()).hasFieldOrPropertyWithValue("metadata.resourceVersion", (Object)"created");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/other-namespace/hellos", "POST");
    }

    @Test
    @DisplayName(value="createOrReplace, with valid object string, should create")
    void createOrReplaceFromString() throws IOException {
        String resourceAsString = "{\"metadata\":{\"name\":\"myresource\",\"namespace\":\"myns\",\"resourceVersion\":\"111\"}, \"kind\":\"raw\", \"apiVersion\":\"v1\"}";
        this.mockCallWithResponse(i -> this.buildResponse(201, "{\"kind\": \"raw\", \"metadata\": {\"resourceVersion\": \"created\"}}"), new Function[0]);
        Map result = this.namespacedOperations.inNamespace("myns").createOrReplace(resourceAsString);
        ((MapAssert)Assertions.assertThat((Map)result).isNotNull()).hasFieldOrPropertyWithValue("metadata.resourceVersion", (Object)"created");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos", "POST");
    }

    @Test
    @DisplayName(value="createOrReplace, with valid Map, should create")
    void createOrReplaceFromMap() throws IOException {
        this.mockCallWithResponse(i -> this.buildResponse(201, "{\"metadata\": {\"resourceVersion\": \"created\"}}"), new Function[0]);
        Map result = this.clusterOperations.inNamespace("myns").createOrReplace(Collections.singletonMap("metadata", Collections.singletonMap("name", "custom-resource-example")));
        ((MapAssert)Assertions.assertThat((Map)result).isNotNull()).hasFieldOrPropertyWithValue("metadata.resourceVersion", (Object)"created");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/hellos", "POST");
    }

    @Test
    void testCreateOrReplaceWithConflict() throws IOException {
        String resourceAsString = "{\"metadata\":{\"name\":\"myresource\",\"namespace\":\"myns\",\"resourceVersion\":\"111\"}, \"kind\":\"raw\", \"apiVersion\":\"v1\"}";
        this.mockCallWithResponse(i -> this.buildResponse(409), i -> this.buildResponse(200, "{\"kind\": \"raw\", \"metadata\": {\"resourceVersion\": \"replaced\"}}"));
        Map result = this.namespacedOperations.inNamespace("myns").createOrReplace(resourceAsString);
        ((MapAssert)Assertions.assertThat((Map)result).isNotNull()).hasFieldOrPropertyWithValue("metadata.resourceVersion", (Object)"replaced");
        this.assertRequestCaptured(0, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos", "POST");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/myresource", "PUT");
    }

    @Test
    void testDeleteWithNamespaceAndNameForNonExistentResource() throws IOException {
        this.mockCallWithResponse(404, "{\"kind\":\"Status\",\"status\":\"Failure\"}");
        boolean result = this.namespacedOperations.delete("ns1", "foo");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result);
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/ns1/hellos/foo", "DELETE");
    }

    @Test
    void testDeleteWithNamespaceForNonExistentResource() throws IOException {
        this.mockCallWithResponse(i -> this.buildResponse(200, "{\"items\": [{\"metadata\": {\"name\": \"hello\", \"namespace\": \"ns1\"}}]}"), i -> this.buildResponse(404, "{\"kind\":\"Status\",\"status\":\"Failure\"}"));
        boolean result = this.namespacedOperations.delete("ns1");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result);
        this.assertRequestCaptured(0, "/apis/test.fabric8.io/v1alpha1/namespaces/ns1/hellos", "GET");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/ns1/hellos/hello", "DELETE");
    }

    @Test
    void testDeleteWithNamespaceAndCascadingForNonExistentResource() throws IOException {
        this.mockCallWithResponse(i -> this.buildResponse(200, "{\"items\": [{\"metadata\": {\"name\": \"hello\", \"namespace\": \"ns1\"}}]}"), i -> this.buildResponse(404, "{\"kind\":\"Status\",\"status\":\"Failure\"}"));
        boolean result = this.namespacedOperations.delete("ns1", true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result);
        this.assertRequestCaptured(0, "/apis/test.fabric8.io/v1alpha1/namespaces/ns1/hellos", "GET");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/ns1/hellos/hello", "DELETE");
    }

    @Test
    void testDeleteWithNamespaceAndDeleteOptionsForNonExistentResource() throws IOException {
        this.mockCallWithResponse(i -> this.buildResponse(200, "{\"items\": [{\"metadata\": {\"name\": \"hello\", \"namespace\": \"ns1\"}}]}"), i -> this.buildResponse(404, "{\"kind\":\"Status\",\"status\":\"Failure\"}"));
        boolean result = this.namespacedOperations.delete("ns1", ((DeleteOptionsBuilder)new DeleteOptionsBuilder().withOrphanDependents(Boolean.valueOf(true))).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result);
        this.assertRequestCaptured(0, "/apis/test.fabric8.io/v1alpha1/namespaces/ns1/hellos", "GET");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/ns1/hellos/hello", "DELETE");
    }

    @Test
    void testDeleteWithNamespaceNameAndCascading() throws IOException {
        this.mockCallWithResponse(200, "{\"kind\":\"Hello\",\"metadata\":{\"name\":\"Failure\"}}");
        boolean result = this.namespacedOperations.delete("ns1", "foo", true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result);
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/ns1/hellos/foo", "DELETE");
    }

    @Test
    void testDeleteWithNamespaceNameAndCascadingForNonExistentResource() throws IOException {
        this.mockCallWithResponse(404, "{\"kind\":\"Status\",\"status\":\"Failure\"}");
        boolean result = this.namespacedOperations.delete("ns1", "foo", true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result);
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/ns1/hellos/foo", "DELETE");
    }

    @Test
    void testDeleteWithNamespaceNameAndPropagationPolicyForNonExistentResource() throws IOException {
        this.mockCallWithResponse(404, "{\"kind\":\"Status\",\"status\":\"Failure\"}");
        boolean result = this.namespacedOperations.delete("ns1", "foo", DeletionPropagation.BACKGROUND.toString());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result);
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/ns1/hellos/foo", "DELETE");
    }

    @Test
    void testDeleteWithNamespaceNameAndDeleteOptionsForNonExistentResource() throws IOException {
        this.mockCallWithResponse(404, "{\"kind\":\"Status\",\"status\":\"Failure\"}");
        boolean result = this.namespacedOperations.delete("ns1", "foo", ((DeleteOptionsBuilder)new DeleteOptionsBuilder().withPropagationPolicy(DeletionPropagation.FOREGROUND.toString())).build());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result);
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/ns1/hellos/foo", "DELETE");
    }

    @Test
    void testGetUrl() throws IOException {
        this.mockCallWithResponse(200, "{}");
        this.namespacedOperations.get("myns", "myresource");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/myresource", "GET");
    }

    @Test
    void testDeleteUrl() throws IOException {
        this.mockCallWithResponse(200, "{\"kind\":\"Status\",\"status\":\"Success\"}");
        boolean result = this.namespacedOperations.delete("myns", "myresource");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result);
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/myresource", "DELETE");
    }

    @Test
    void testGetConfigShouldNotReturnNull() {
        Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withRequestTimeout(5)).withWebsocketTimeout(10L)).withWebsocketPingInterval(10L)).withConnectionTimeout(10)).withWatchReconnectLimit(1)).withWatchReconnectInterval(10)).build();
        RawCustomResourceOperationsImpl rawOp = new RawCustomResourceOperationsImpl(this.mockClient, config, this.namespacedCustomResourceDefinitionContext);
        Config configFromRawOp = rawOp.getConfig();
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)configFromRawOp).isNotNull()).hasFieldOrPropertyWithValue("requestTimeout", (Object)5)).hasFieldOrPropertyWithValue("websocketTimeout", (Object)10L)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)10L)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)10)).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)10)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)1);
    }

    @Test
    void testDryRunDelete() throws IOException {
        this.mockCallWithResponse(200);
        ((RawCustomResourceOperationsImpl)this.namespacedOperations.dryRun()).delete("myns", "myresource");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/myresource", "DELETE");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dryRun=All", (Object)((Request)this.captor.getValue()).url().encodedQuery());
    }

    @Test
    @DisplayName(value="delete, with valid namespace and name and grace period, should delete")
    void deleteWithGracePeriod() throws IOException {
        this.mockCallWithResponse(200);
        this.namespacedOperations.inNamespace("myns").withName("myresource").withGracePeriod(1337L).delete();
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/myresource", "DELETE");
        Buffer b = new Buffer();
        ((Request)this.captor.getValue()).body().writeTo((BufferedSink)b);
        Assertions.assertThat((String)b.readUtf8()).contains(new CharSequence[]{"\"gracePeriodSeconds\":1337"});
    }

    @Test
    @DisplayName(value="delete, with valid namespace and name and propagation policy should delete")
    void deleteWithPropagationPolicy() throws IOException {
        this.mockCallWithResponse(200);
        this.namespacedOperations.inNamespace("myns").withName("myresource").withPropagationPolicy(DeletionPropagation.FOREGROUND).delete();
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/myresource", "DELETE");
        Buffer b = new Buffer();
        ((Request)this.captor.getValue()).body().writeTo((BufferedSink)b);
        Assertions.assertThat((String)b.readUtf8()).contains(new CharSequence[]{"\"propagationPolicy\":\"Foreground\""});
    }

    @Test
    void testDryRunCreate() throws IOException {
        this.mockCallWithResponse(200);
        ((RawCustomResourceOperationsImpl)this.namespacedOperations.dryRun()).create("myns", "{\"apiVersion\":\"test.fabric8.io/v1alpha1\"}");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos", "POST");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dryRun=All", (Object)((Request)this.captor.getValue()).url().encodedQuery());
    }

    @Test
    void testDeleteWithNamespaceAndName() throws IOException {
        this.mockCallWithResponse(200);
        this.namespacedOperations.inNamespace("myns").withName("myresource").delete();
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/myresource", "DELETE");
    }

    @Test
    void testGet() throws IOException {
        this.mockCallWithResponse(200, "{}");
        this.namespacedOperations.inNamespace("myns").withName("myresource").get();
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/myresource", "GET");
    }

    @Test
    void testListWithLimitAndContinue() throws IOException {
        this.mockCallWithResponse(200, "{\"kind\":\"List\"}");
        this.namespacedOperations.inNamespace("myns").list(Integer.valueOf(4), "eyJ2IjoibWV0YS5rOHMuaW8vdj");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos", "GET");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"limit=4&continue=eyJ2IjoibWV0YS5rOHMuaW8vdj", (Object)((Request)this.captor.getValue()).url().encodedQuery());
    }

    @Test
    void testListWithListOptions() throws IOException {
        this.mockCallWithResponse(200, "{\"kind\":\"List\"}");
        this.namespacedOperations.inNamespace("myns").list(((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(4L))).build());
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos", "GET");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"limit=4", (Object)((Request)this.captor.getValue()).url().encodedQuery());
    }

    @Test
    void testListWithLabels() throws IOException {
        this.mockCallWithResponse(200, "{\"kind\":\"List\"}");
        this.namespacedOperations.list("myns", Collections.singletonMap("foo", "bar"));
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos", "GET");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"labelSelector=foo%3Dbar", (Object)((Request)this.captor.getValue()).url().encodedQuery());
    }

    @Test
    void testDeleteInSpecifiedNamespace() throws IOException {
        this.mockCallWithResponse(i -> this.buildResponse(200, "{\"items\": [{\"metadata\": {\"name\": \"one\"}},{\"metadata\": {\"name\": \"two\"}}]}"), i -> this.buildResponse(200));
        this.namespacedOperations.inNamespace("myns").delete();
        this.assertRequestCaptured(0, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos", "GET");
        this.assertRequestCaptured(1, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/one", "DELETE");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/two", "DELETE");
    }

    @Test
    void testDeleteInAllNamespaces() throws IOException {
        this.mockCallWithResponse(i -> this.buildResponse(200, "{\"items\": [{\"metadata\": {\"name\": \"one\", \"namespace\": \"myns\"}},{\"metadata\": {\"name\": \"two\", \"namespace\": \"myns\"}}]}"), i -> this.buildResponse(200));
        this.namespacedOperations.inAnyNamespace().delete();
        this.assertRequestCaptured(0, "/apis/test.fabric8.io/v1alpha1/hellos", "GET");
        this.assertRequestCaptured(1, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/one", "DELETE");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/two", "DELETE");
    }

    @Test
    void testClusterScopedDeletionWithName() throws IOException {
        this.mockCallWithResponse(200);
        this.clusterOperations.withName("myresource").delete();
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/hellos/myresource", "DELETE");
    }

    @Test
    void testClusterScopeDeletionAll() throws IOException {
        this.mockCallWithResponse(i -> this.buildResponse(200, "{\"items\": [{\"metadata\": {\"name\": \"one\"}},{\"metadata\": {\"name\": \"two\"}}]}"), i -> this.buildResponse(200));
        this.clusterOperations.delete();
        this.assertRequestCaptured(0, "/apis/test.fabric8.io/v1alpha1/hellos", "GET");
        this.assertRequestCaptured(1, "/apis/test.fabric8.io/v1alpha1/hellos/one", "DELETE");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/hellos/two", "DELETE");
    }

    @Test
    void testDeleteByNamespaceOrNameWithNamespacedScopedCRD() throws IOException {
        this.mockCallWithResponse(i -> this.buildResponse(200, "{\"items\": [{\"metadata\": {\"name\": \"one\", \"namespace\": \"myns\"}},{\"metadata\": {\"name\": \"two\", \"namespace\": \"myns\"}}]}"), i -> this.buildResponse(200));
        this.namespacedOperations.delete("myns");
        this.assertRequestCaptured(0, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos", "GET");
        this.assertRequestCaptured(1, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/one", "DELETE");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/two", "DELETE");
    }

    @Test
    void testDeleteByNamespaceOrNameWithCascadingWithNamespacedScopedCRD() throws IOException {
        this.mockCallWithResponse(i -> this.buildResponse(200, "{\"items\": [{\"metadata\": {\"name\": \"one\", \"namespace\": \"myns\"}},{\"metadata\": {\"name\": \"two\", \"namespace\": \"myns\"}}]}"), i -> this.buildResponse(200));
        this.namespacedOperations.delete("myns", true);
        this.assertRequestCaptured(0, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos", "GET");
        this.assertRequestCaptured(1, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/one", "DELETE");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/two", "DELETE");
    }

    @Test
    void testDeleteByNamespaceOrNameWithDeleteOptionsWithNamespacedScopedCRD() throws IOException {
        this.mockCallWithResponse(i -> this.buildResponse(200, "{\"items\": [{\"metadata\": {\"name\": \"one\", \"namespace\": \"myns\"}},{\"metadata\": {\"name\": \"two\", \"namespace\": \"myns\"}}]}"), i -> this.buildResponse(200));
        this.namespacedOperations.delete("myns", ((DeleteOptionsBuilder)new DeleteOptionsBuilder().withPropagationPolicy(DeletionPropagation.BACKGROUND.toString())).build());
        this.assertRequestCaptured(0, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos", "GET");
        this.assertRequestCaptured(1, "/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/one", "DELETE");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/namespaces/myns/hellos/two", "DELETE");
    }

    @Test
    void testDeleteByNamespaceOrNameWithClusterScopedCRD() throws IOException {
        this.mockCallWithResponse(200);
        this.clusterOperations.delete("myresource");
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/hellos/myresource", "DELETE");
    }

    @Test
    void testDeleteByNamespaceOrNameWithCascadingWithClusterScopedCRD() throws IOException {
        this.mockCallWithResponse(200);
        this.clusterOperations.delete("myresource", true);
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/hellos/myresource", "DELETE");
    }

    @Test
    void testDeleteByNamespaceOrNameWithDeleteOptionsWithClusterScopedCRD() throws IOException {
        this.mockCallWithResponse(200);
        this.clusterOperations.delete("myresource", ((DeleteOptionsBuilder)new DeleteOptionsBuilder().withPropagationPolicy(DeletionPropagation.BACKGROUND.toString())).build());
        this.assertRequestCaptured("/apis/test.fabric8.io/v1alpha1/hellos/myresource", "DELETE");
    }

    @Test
    void testGetConfigmap() throws IOException {
        this.mockCallWithResponse(200, "{\"kind\": \"ConfigMap\"}");
        CustomResourceDefinitionContext configMapContext = new CustomResourceDefinitionContext.Builder().withGroup(null).withVersion("v1").withPlural("configmaps").withScope("Namespaced").withKind("ConfigMap").build();
        RawCustomResourceOperationsImpl rawOp = new RawCustomResourceOperationsImpl(this.mockClient, this.config, configMapContext);
        Map unstructuredConfigMap = rawOp.inNamespace("default").withName("game-config").get();
        Assertions.assertThat((Map)unstructuredConfigMap).isNotNull();
        this.assertRequestCaptured("/api/v1/namespaces/default/configmaps/game-config", "GET");
    }

    @Test
    void testEditCR() throws IOException {
        this.mockCallWithResponse(i -> this.buildResponse(200, "{\"kind\": \"Hello\"}"), new Function[0]);
        String jsonString = "{ \"metadata\": " + Serialization.jsonMapper().writeValueAsString((Object)((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName("myresource")).withNamespace("mynamespace")).build()) + "}";
        Map res = this.clusterOperations.edit(jsonString);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)res);
    }

    @Test
    @DisplayName(value="watch, with valid Watcher, should connect and receive event")
    void watch() throws IOException {
        final AtomicReference eventReceived = new AtomicReference();
        Mockito.when((Object)this.mockClient.newBuilder().readTimeout(ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any())).build().newWebSocket((Request)Mockito.any(), (WebSocketListener)Mockito.any())).thenAnswer(i -> {
            WebSocket webSocket = (WebSocket)Mockito.mock(WebSocket.class);
            ((WebSocketListener)i.getArguments()[1]).onOpen(webSocket, (Response)Mockito.mock(Response.class));
            ((WebSocketListener)i.getArguments()[1]).onMessage(webSocket, "{\"type\":\"ADDED\", \"object\":{\"kind\": \"Hello\", \"metadata\": {\"name\": \"test\"}}}");
            return webSocket;
        });
        Watch result = this.clusterOperations.watch((Watcher)new Watcher<String>(){

            public void eventReceived(Watcher.Action action, String resource) {
                eventReceived.set(resource);
            }

            public void onClose(WatcherException cause) {
            }
        });
        ((OkHttpClient)Mockito.verify((Object)this.mockClient.newBuilder().readTimeout(ArgumentMatchers.anyLong(), (TimeUnit)((Object)Mockito.any())).build(), (VerificationMode)Mockito.times((int)1))).newWebSocket((Request)this.captor.capture(), (WebSocketListener)Mockito.any());
        Assertions.assertThat(eventReceived).hasValue((Object)"{\"kind\":\"Hello\",\"metadata\":{\"name\":\"test\"}}");
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((Object)((Request)this.captor.getValue()).url()).hasToString("https://localhost:8443/apis/test.fabric8.io/v1alpha1/hellos?watch=true");
    }

    private void mockCallWithResponse(int code) throws IOException {
        this.mockCallWithResponse(code, "{\"kind\":\"Status\",\"status\":\"Success\"}");
    }

    private void mockCallWithResponse(int code, String body) throws IOException {
        this.mockCallWithResponse(i -> this.buildResponse(code, body), new Function[0]);
    }

    @SafeVarargs
    private final void mockCallWithResponse(Function<InvocationOnMock, Response> response, Function<InvocationOnMock, Response> ... responses) throws IOException {
        Call mockCall = (Call)Mockito.mock(Call.class);
        AtomicInteger invocationCount = new AtomicInteger(-1);
        Mockito.when((Object)mockCall.execute()).thenAnswer(invocation -> {
            int current = invocationCount.getAndIncrement();
            if (current == -1 || responses.length == 0) {
                return response.apply(invocation);
            }
            if (current < responses.length) {
                return responses[current].apply(invocation);
            }
            return responses[responses.length - 1].apply(invocation);
        });
        Mockito.when((Object)this.mockClient.newCall((Request)Mockito.any())).thenReturn((Object)mockCall);
    }

    private Response buildResponse(int code) {
        return this.buildResponse(code, "{\"kind\":\"Status\",\"status\":\"Success\"}");
    }

    private Response buildResponse(int code, String body) {
        return new Response.Builder().request(new Request.Builder().url("http://mock").build()).protocol(Protocol.HTTP_1_1).code(code).body(ResponseBody.create((MediaType)MediaType.get((String)"application/json"), (String)body)).message("mock").build();
    }

    private void assertRequestCaptured(int order, String url, String method) {
        ((OkHttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.atLeastOnce())).newCall((Request)this.captor.capture());
        org.junit.jupiter.api.Assertions.assertEquals((Object)url, (Object)((Request)this.captor.getAllValues().get(order)).url().encodedPath());
        org.junit.jupiter.api.Assertions.assertEquals((Object)method, (Object)((Request)this.captor.getAllValues().get(order)).method());
    }

    private void assertRequestCaptured(String url, String method) {
        ((OkHttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.atLeastOnce())).newCall((Request)this.captor.capture());
        org.junit.jupiter.api.Assertions.assertEquals((Object)url, (Object)((Request)this.captor.getValue()).url().encodedPath());
        org.junit.jupiter.api.Assertions.assertEquals((Object)method, (Object)((Request)this.captor.getValue()).method());
    }
}

