/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.CustomResourceList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ResourceOperationsImplTest {
    private final CustomResourceDefinition crd = CustomResourceDefinitionContext.v1beta1CRDFromCustomResourceType(MyCustomResource.class).build();

    ResourceOperationsImplTest() {
    }

    @Test
    void shouldBeAbleToReturnOperationsWithoutSpecificList() {
        MixedOperation operation = new DefaultKubernetesClient().customResources(Bar.class, CustomResourceList.class);
        Assertions.assertNotNull((Object)operation);
    }

    @Test
    void shouldRegisterWithKubernetesDeserializer() throws IOException {
        this.assertForContext(new OperationContext(), (ResourceDefinitionContext)CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)this.crd), MyCustomResource.class, MyCustomResourceList.class);
    }

    @Test
    void shouldWorkWithPlainCustomResourceList() throws IOException {
        this.assertForContext(new OperationContext(), (ResourceDefinitionContext)CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)this.crd), MyCustomResource.class, CustomResourceList.class);
    }

    @Test
    void itFallsBackOnTypeKindIfNoKindSpecifiedInContext() throws IOException {
        ResourceDefinitionContext rdc = new ResourceDefinitionContext.Builder().withGroup(this.crd.getSpec().getGroup()).withVersion(this.crd.getSpec().getVersion()).withPlural(this.crd.getSpec().getNames().getPlural()).build();
        this.assertForContext(new OperationContext(), rdc, MyCustomResource.class, MyCustomResourceList.class);
    }

    private <T extends HasMetadata, L extends KubernetesResourceList<T>> void assertForContext(OperationContext context, ResourceDefinitionContext rdc, Class<T> type, Class<L> listType) throws IOException {
        new HasMetadataOperationsImpl(context, rdc, type, listType);
        MappingJsonFactory factory = new MappingJsonFactory();
        JsonParser parser = factory.createParser("{\n    \"apiVersion\": \"custom.group/v1alpha1\",\n    \"kind\": \"MyCustomResource\"\n}");
        KubernetesDeserializer deserializer = new KubernetesDeserializer();
        KubernetesResource resource = deserializer.deserialize(parser, null);
        Assert.assertThat((Object)resource, (Matcher)IsInstanceOf.instanceOf(MyCustomResource.class));
        Assertions.assertEquals((Object)"custom.group/v1alpha1", (Object)((MyCustomResource)resource).getApiVersion());
    }

    @Group(value="sample.fabric8.io")
    @Version(value="v1")
    public static class Bar
    extends CustomResource {
    }

    public static class MyCustomResourceList
    extends CustomResourceList<MyCustomResource> {
    }

    @Group(value="custom.group")
    @Version(value="v1alpha1")
    public static class MyCustomResource
    extends CustomResource {
        public static final String GROUP = "custom.group";
        public static final String VERSION = "v1alpha1";
    }
}

