/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.utils.BackwardsCompatibilityInterceptor;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.kubernetes.client.utils.ImpersonatorInterceptor;
import io.fabric8.kubernetes.client.utils.TokenRefreshInterceptor;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

class HttpClientUtilsTest {
    HttpClientUtilsTest() {
    }

    @Test
    void testCreateApplicableInterceptors() {
        Config config = new ConfigBuilder().build();
        List interceptorList = HttpClientUtils.createApplicableInterceptors((Config)config);
        ((ListAssert)((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat((List)interceptorList).isNotNull()).hasSize(4)).hasAtLeastOneElementOfType(BackwardsCompatibilityInterceptor.class)).hasAtLeastOneElementOfType(ImpersonatorInterceptor.class)).hasAtLeastOneElementOfType(TokenRefreshInterceptor.class);
    }

    @Test
    void testCreateApplicableInterceptorsWithBackwardsCompatibilityDisabled() {
        Config config = new ConfigBuilder().build();
        System.setProperty("kubernetes.backwardsCompatibilityInterceptor.disable", "true");
        List interceptorList = HttpClientUtils.createApplicableInterceptors((Config)config);
        ((ListAssert)((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat((List)interceptorList).isNotNull()).hasSize(3)).noneMatch(i -> i instanceof BackwardsCompatibilityInterceptor)).hasAtLeastOneElementOfType(ImpersonatorInterceptor.class)).hasAtLeastOneElementOfType(TokenRefreshInterceptor.class);
        System.clearProperty("kubernetes.backwardsCompatibilityInterceptor.disable");
    }
}

