/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventBuilder;
import io.fabric8.kubernetes.api.model.EventFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.batch.v1beta1.CronJob;
import io.fabric8.kubernetes.api.model.batch.v1beta1.CronJobList;
import io.fabric8.kubernetes.client.CustomResourceList;
import io.fabric8.kubernetes.client.Good;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class KubernetesResourceUtilTest {
    private ConfigMap configMap1;

    KubernetesResourceUtilTest() {
    }

    @BeforeEach
    public void createTestResource() {
        this.configMap1 = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName("configmap1")).withNamespace("ns1")).withAnnotations(Collections.singletonMap("foo", "bar"))).withLabels(Collections.singletonMap("foo-label", "bar-label"))).endMetadata()).addToData("one", "1")).build();
    }

    @Test
    void testNullSafeOperationsForName() {
        String resourceName = KubernetesResourceUtil.getName((HasMetadata)this.configMap1);
        Assertions.assertNotNull((Object)resourceName);
        Assertions.assertEquals((Object)"configmap1", (Object)resourceName);
    }

    @Test
    void testNullSafeOperationsForNamespace() {
        String namespace = KubernetesResourceUtil.getNamespace((HasMetadata)this.configMap1);
        Assertions.assertNotNull((Object)namespace);
        Assertions.assertEquals((Object)"ns1", (Object)namespace);
        Assertions.assertEquals((Object)"ns1/configmap1", (Object)KubernetesResourceUtil.getQualifiedName((HasMetadata)this.configMap1));
    }

    @Test
    void testNullSafeOperationsForLabels() {
        Map labels = KubernetesResourceUtil.getOrCreateLabels((HasMetadata)this.configMap1);
        Assertions.assertNotNull((Object)labels);
        Assertions.assertEquals(Collections.singletonMap("foo-label", "bar-label"), (Object)labels);
    }

    @Test
    void testNullSafeOperationsForAnnotations() {
        Map annos = KubernetesResourceUtil.getOrCreateAnnotations((HasMetadata)this.configMap1);
        Assertions.assertNotNull((Object)annos);
        Assertions.assertEquals(Collections.singletonMap("foo", "bar"), (Object)annos);
    }

    @Test
    void testNames() {
        Assertions.assertTrue((boolean)KubernetesResourceUtil.isValidName((String)KubernetesResourceUtil.getName((HasMetadata)this.configMap1)));
        Assertions.assertFalse((boolean)KubernetesResourceUtil.isValidName((String)"test.invalid.name"));
        Assertions.assertTrue((boolean)KubernetesResourceUtil.isValidLabelOrAnnotation((Map)KubernetesResourceUtil.getOrCreateAnnotations((HasMetadata)this.configMap1)));
        Assertions.assertFalse((boolean)KubernetesResourceUtil.isValidLabelOrAnnotation(Collections.singletonMap("NoUppercaseOrSpecialCharsLike=Equals", "bar")));
        Assertions.assertTrue((boolean)KubernetesResourceUtil.isValidName((String)KubernetesResourceUtil.sanitizeName((String)"test.invalid.name")));
        Assertions.assertTrue((boolean)KubernetesResourceUtil.isValidName((String)KubernetesResourceUtil.sanitizeName((String)"90notcool-n@me")));
    }

    @Test
    void testSortEventListBasedOnTimestamp() {
        ArrayList<Event> eventList = new ArrayList<Event>();
        eventList.add(((EventBuilder)((EventBuilder)((EventFluent.MetadataNested)new EventBuilder().withNewMetadata().withName("event2")).endMetadata()).withLastTimestamp("2020-06-12T06:45:16Z")).build());
        eventList.add(((EventBuilder)((EventBuilder)((EventFluent.MetadataNested)new EventBuilder().withNewMetadata().withName("event1")).endMetadata()).withLastTimestamp("2020-06-10T06:45:16Z")).build());
        eventList.add(((EventBuilder)((EventBuilder)((EventFluent.MetadataNested)new EventBuilder().withNewMetadata().withName("event3")).endMetadata()).withLastTimestamp("2020-06-13T06:45:16Z")).build());
        eventList.add(((EventBuilder)((EventFluent.MetadataNested)new EventBuilder().withNewMetadata().withName("eventWithoutLastTimestamp")).endMetadata()).build());
        KubernetesResourceUtil.sortEventListBasedOnTimestamp(eventList);
        Assertions.assertEquals((Object)"eventWithoutLastTimestamp", (Object)((Event)eventList.get(0)).getMetadata().getName());
        Assertions.assertEquals((Object)"event3", (Object)((Event)eventList.get(1)).getMetadata().getName());
        Assertions.assertEquals((Object)"event2", (Object)((Event)eventList.get(2)).getMetadata().getName());
        Assertions.assertEquals((Object)"event1", (Object)((Event)eventList.get(3)).getMetadata().getName());
    }

    @Test
    @DisplayName(value="Should be able to get resource version")
    void testGetResourceVersion() {
        Pod pod = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test")).withResourceVersion("1001")).endMetadata()).build();
        String resourceVersion = KubernetesResourceUtil.getResourceVersion((HasMetadata)pod);
        Assertions.assertEquals((Object)"1001", (Object)resourceVersion);
    }

    @Test
    @DisplayName(value="Should be able to update resource version")
    void testSetResourceVersion() {
        Pod pod = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test")).withResourceVersion("1001")).endMetadata()).build();
        KubernetesResourceUtil.setResourceVersion((HasMetadata)pod, (String)"1002");
        Assertions.assertEquals((Object)"1002", (Object)pod.getMetadata().getResourceVersion());
    }

    @Test
    void testIsResourceReadyReturnsTrue() {
        Deployment deployment = ((DeploymentBuilder)((DeploymentFluent.StatusNested)((DeploymentFluent.StatusNested)((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName("test")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).endSpec()).withNewStatus().withReplicas(Integer.valueOf(1))).withAvailableReplicas(Integer.valueOf(1))).endStatus()).build();
        boolean result = KubernetesResourceUtil.isResourceReady((HasMetadata)deployment);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void testIsResourceReadyReturnsFalse() {
        Deployment deployment = ((DeploymentBuilder)((DeploymentFluent.StatusNested)((DeploymentFluent.StatusNested)((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName("test")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(2))).endSpec()).withNewStatus().withReplicas(Integer.valueOf(1))).withAvailableReplicas(Integer.valueOf(1))).endStatus()).build();
        boolean result = KubernetesResourceUtil.isResourceReady((HasMetadata)deployment);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void testGetAge() {
        Pod pod = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test")).withCreationTimestamp("2020-11-03T13:22:22Z")).endMetadata()).build();
        Duration duration = KubernetesResourceUtil.getAge((HasMetadata)pod);
        Assertions.assertFalse((boolean)duration.isNegative());
    }

    @Test
    void testInferListType() {
        Assertions.assertEquals(PodList.class, (Object)KubernetesResourceUtil.inferListType(Pod.class));
        Assertions.assertEquals(ConfigMapList.class, (Object)KubernetesResourceUtil.inferListType(ConfigMap.class));
        Assertions.assertEquals(CronJobList.class, (Object)KubernetesResourceUtil.inferListType(CronJob.class));
        Assertions.assertEquals(CustomResourceList.class, (Object)KubernetesResourceUtil.inferListType(Good.class));
    }

    @Test
    void testcreateDockerRegistrySecret() throws JsonProcessingException {
        Secret secret = KubernetesResourceUtil.createDockerRegistrySecret((String)"http://harbor.inner.com", (String)"SecretAdmin", (String)"TestingSecret");
        String header = new String(Base64.getDecoder().decode((String)secret.getData().get(".dockerconfigjson")));
        Assertions.assertEquals((Object)"{\"auths\":{\"http://harbor.inner.com\":{\"password\":\"TestingSecret\",\"auth\":\"U2VjcmV0QWRtaW46VGVzdGluZ1NlY3JldA==\",\"username\":\"SecretAdmin\"}}}", (Object)header);
    }
}

