/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.base;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.WatchConnectionManager;
import io.fabric8.kubernetes.client.dsl.internal.WatchHTTPManager;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.MockedConstruction;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class BaseOperationWatchTest {
    private Watcher<Pod> watcher;
    private OperationContext operationContext;
    private BaseOperation<Pod, PodList, PodResource<Pod>> baseOperation;

    BaseOperationWatchTest() {
    }

    @BeforeEach
    void setUp() {
        this.watcher = (Watcher)Mockito.mock(Watcher.class);
        this.operationContext = (OperationContext)Mockito.mock(OperationContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.baseOperation = new BaseOperation(this.operationContext);
    }

    @Test
    @DisplayName(value="watch, with exception on connection open, should throw Exception and close WatchConnectionManager")
    void watchWithExceptionOnOpen() {
        try (MockedConstruction m = Mockito.mockConstruction(WatchConnectionManager.class, (mock, context) -> ((WatchConnectionManager)Mockito.doThrow((Throwable[])new Throwable[]{new KubernetesClientException("Mocked Connection Error")}).when(mock)).waitUntilReady());){
            KubernetesClientException result = (KubernetesClientException)org.junit.jupiter.api.Assertions.assertThrows(KubernetesClientException.class, () -> {
                this.baseOperation.watch(this.watcher);
                org.junit.jupiter.api.Assertions.fail();
            });
            Assertions.assertThat((Throwable)result).hasMessage("Mocked Connection Error");
            ((ObjectAssert)((ListAssert)Assertions.assertThat((List)m.constructed()).hasSize(1)).element(0)).matches(wcm -> {
                ((WatchConnectionManager)Mockito.verify((Object)wcm, (VerificationMode)Mockito.times((int)1))).close();
                return true;
            });
        }
    }

    @Test
    @DisplayName(value="watch, with retryable exception on connection open, should close initial WatchConnectionManager and retry")
    void watchWithRetryableExceptionOnOpen() {
        try (MockedConstruction m = Mockito.mockConstruction(WatchConnectionManager.class, (mock, context) -> ((WatchConnectionManager)Mockito.doThrow((Throwable[])new Throwable[]{new KubernetesClientException(((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(503))).build())}).when(mock)).waitUntilReady());
             MockedConstruction mHttp = Mockito.mockConstruction(WatchHTTPManager.class);){
            Watch result = this.baseOperation.watch(this.watcher);
            ((ObjectAssert)Assertions.assertThat((Object)result).isInstanceOf(WatchHTTPManager.class)).isSameAs(mHttp.constructed().get(0));
            ((ObjectAssert)((ListAssert)Assertions.assertThat((List)m.constructed()).hasSize(1)).element(0)).matches(wcm -> {
                ((WatchConnectionManager)Mockito.verify((Object)wcm, (VerificationMode)Mockito.times((int)1))).close();
                return true;
            });
        }
    }
}

