/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.base;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class BaseOperationTest {
    BaseOperationTest() {
    }

    @Test
    void testSimpleFieldQueryParamConcatenation() {
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        fieldsMap.put("yesKey1", "yesValue1");
        fieldsMap.put("yesKey2", "yesValue2");
        PodOperationsImpl operation = new PodOperationsImpl(new PodOperationContext());
        operation = (PodOperationsImpl)((FilterWatchListDeletable)((FilterWatchListDeletable)operation.withFields(fieldsMap).withField("yesKey2", "overrideValue2")).withoutField("noKey1", "noValue1")).withoutField("noKey2", "noValue2");
        String fieldQueryParam = operation.getFieldQueryParam();
        MatcherAssert.assertThat((Object)fieldQueryParam, (Matcher)CoreMatchers.containsString((String)"yesKey1=yesValue1"));
        MatcherAssert.assertThat((Object)fieldQueryParam, (Matcher)CoreMatchers.containsString((String)"yesKey2=overrideValue2"));
        MatcherAssert.assertThat((Object)fieldQueryParam, (Matcher)CoreMatchers.containsString((String)"noKey1!=noValue1"));
        MatcherAssert.assertThat((Object)fieldQueryParam, (Matcher)CoreMatchers.containsString((String)"noKey2!=noValue2"));
    }

    @Test
    void testSkippingFieldNotMatchingNullValues() {
        PodOperationsImpl operation = new PodOperationsImpl(new PodOperationContext());
        operation = (PodOperationsImpl)((FilterWatchListDeletable)((FilterWatchListDeletable)((FilterWatchListDeletable)((FilterWatchListDeletable)((FilterWatchListDeletable)operation.withField("key1", "value1").withoutField("key2", "value2")).withoutField("key2", null)).withoutField("key2", "")).withoutField("key2", "value3")).withoutField("key10", "value11")).withoutField("key10", "");
        MatcherAssert.assertThat((Object)operation.getFieldQueryParam(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"key1=value1,key2!=value2,key2!=value3,key10!=value11")));
    }

    @Test
    void testFilterContextModification() {
        PodOperationsImpl operation = new PodOperationsImpl(new PodOperationContext());
        operation.withField("x", "y");
        Assert.assertTrue((boolean)Utils.isNullOrEmpty((String)operation.getFieldQueryParam()));
    }

    @Test
    void testDefaultGracePeriod() {
        BaseOperation operation = new BaseOperation(new OperationContext());
        MatcherAssert.assertThat((Object)operation.getGracePeriodSeconds(), (Matcher)CoreMatchers.is((Object)-1L));
    }

    @Test
    void testChainingGracePeriodAndPropagationPolicy() {
        BaseOperation operation = new BaseOperation(new OperationContext());
        EditReplacePatchDeletable operationWithPropagationPolicy = operation.withPropagationPolicy(DeletionPropagation.FOREGROUND);
        MatcherAssert.assertThat((Object)operationWithPropagationPolicy, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assertions.assertNotNull((Object)operationWithPropagationPolicy.withGracePeriod(10L));
    }

    @Test
    void testListOptions() throws MalformedURLException {
        URL url = new URL("https://172.17.0.2:8443/api/v1/namespaces/default/pods");
        BaseOperation operation = new BaseOperation(new OperationContext());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).build()).toString());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).build()).toString());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ&fieldSelector=status.phase%3DRunning"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).withFieldSelector("status.phase=Running")).build()).toString());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ&resourceVersion=210448&fieldSelector=status.phase%3DRunning"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).withFieldSelector("status.phase=Running")).withResourceVersion("210448")).build()).toString());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ&resourceVersion=210448&labelSelector=%21node-role.kubernetes.io%2Fmaster"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).withLabelSelector("!node-role.kubernetes.io/master")).withResourceVersion("210448")).build()).toString());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ&resourceVersion=210448&labelSelector=%21node-role.kubernetes.io%2Fmaster&timeoutSeconds=10"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).withLabelSelector("!node-role.kubernetes.io/master")).withResourceVersion("210448")).withTimeoutSeconds(Long.valueOf(10L))).build()).toString());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ&resourceVersion=210448&labelSelector=%21node-role.kubernetes.io%2Fmaster&timeoutSeconds=10&allowWatchBookmarks=true"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).withLabelSelector("!node-role.kubernetes.io/master")).withResourceVersion("210448")).withTimeoutSeconds(Long.valueOf(10L))).withAllowWatchBookmarks(Boolean.valueOf(true))).build()).toString());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?limit=5&continue=eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ&resourceVersion=210448&labelSelector=%21node-role.kubernetes.io%2Fmaster&timeoutSeconds=10&allowWatchBookmarks=true&watch=true"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(5L))).withContinue("eyJ2IjoibWV0YS5rOHMuaW8vdjEiLCJydiI6MjE0NDUzLCJzdGFydCI6ImV0Y2QtbWluaWt1YmVcdTAwMDAifQ")).withLabelSelector("!node-role.kubernetes.io/master")).withResourceVersion("210448")).withTimeoutSeconds(Long.valueOf(10L))).withAllowWatchBookmarks(Boolean.valueOf(true))).withWatch(Boolean.valueOf(true))).build()).toString());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?resourceVersion=210448"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion("210448")).build()).toString());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?timeoutSeconds=10"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)new ListOptionsBuilder().withTimeoutSeconds(Long.valueOf(10L))).build()).toString());
        Assert.assertEquals((Object)URLUtils.join((String[])new String[]{url.toString(), "?watch=true"}), (Object)operation.fetchListUrl(url, ((ListOptionsBuilder)new ListOptionsBuilder().withWatch(Boolean.valueOf(true))).build()).toString());
    }

    @Test
    void testGetWriteOperationUrlWithDryRunEnabled() throws MalformedURLException {
        BaseOperation baseOp = new BaseOperation(new OperationContext().withConfig(((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://172.17.0.2:8443")).build()).withPlural("pods").withDryRun(true));
        baseOp.setType(Pod.class);
        baseOp.setListType(PodList.class);
        URL result = baseOp.getResourceURLForWriteOperation(new URL("https://172.17.0.2:8443/api/v1/namespaces/ns1/pods/foo"));
        Assertions.assertNotNull((Object)result);
        Assert.assertEquals((Object)"https://172.17.0.2:8443/api/v1/namespaces/ns1/pods/foo?dryRun=All", (Object)result.toString());
    }

    @Test
    void testGetWriteOperationUrlWithDryRunDisabled() throws MalformedURLException {
        BaseOperation baseOp = new BaseOperation(new OperationContext().withConfig(((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://172.17.0.2:8443")).build()).withPlural("pods"));
        baseOp.setType(Pod.class);
        baseOp.setListType(PodList.class);
        URL result = baseOp.getResourceURLForWriteOperation(new URL("https://172.17.0.2:8443/api/v1/namespaces/ns1/pods/foo"));
        Assertions.assertNotNull((Object)result);
        Assert.assertEquals((Object)"https://172.17.0.2:8443/api/v1/namespaces/ns1/pods/foo", (Object)result.toString());
    }

    private OkHttpClient newHttpClientWithSomeFailures(AtomicInteger httpExecutionCounter, int numFailures) {
        OkHttpClient mockClient = (OkHttpClient)Mockito.mock(OkHttpClient.class);
        Mockito.when((Object)mockClient.newCall((Request)ArgumentMatchers.any())).thenAnswer(invocation -> {
            Call mockCall = (Call)Mockito.mock(Call.class);
            Request req = (Request)invocation.getArgument(0);
            Mockito.when((Object)mockCall.execute()).thenAnswer(i -> {
                int count = httpExecutionCounter.getAndIncrement();
                if (count < numFailures) {
                    if (count % 2 == 0) {
                        throw new IOException("For example java.net.ConnectException");
                    }
                    return new Response.Builder().request(req).message("Internal Server Error").protocol(Protocol.HTTP_1_1).code(500).build();
                }
                Pod podNoLabels = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).withNamespace("test")).and()).build();
                ResponseBody body = ResponseBody.create((MediaType)MediaType.get((String)"application/json"), (String)Serialization.asJson((Object)podNoLabels));
                return new Response.Builder().request(req).protocol(Protocol.HTTP_1_1).body(body).message("OK").code(200).build();
            });
            return mockCall;
        });
        return mockClient;
    }

    @Test
    void testNoHttpRetryWithDefaultConfig() throws MalformedURLException, IOException {
        AtomicInteger httpExecutionCounter = new AtomicInteger(0);
        OkHttpClient mockClient = this.newHttpClientWithSomeFailures(httpExecutionCounter, 1000);
        BaseOperation baseOp = new BaseOperation(new OperationContext().withConfig(((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://172.17.0.2:8443")).build()).withPlural("pods").withName("test-pod").withOkhttpClient(mockClient));
        baseOp.setType(Pod.class);
        Exception exception = (Exception)Assertions.assertThrows(KubernetesClientException.class, () -> {
            Pod result = (Pod)baseOp.get();
        });
        Assert.assertTrue((String)"As the first failure is an IOException the message of the causedBy expected to contain the given text: 'For example java.net.ConnectException'!", (boolean)exception.getCause().getMessage().contains("For example java.net.ConnectException"));
        Assert.assertEquals((long)1L, (long)httpExecutionCounter.get());
    }

    @Test
    void testHttpRetryWithMoreFailuresThanRetries() throws MalformedURLException, IOException {
        AtomicInteger httpExecutionCounter = new AtomicInteger(0);
        OkHttpClient mockClient = this.newHttpClientWithSomeFailures(httpExecutionCounter, 1000);
        BaseOperation baseOp = new BaseOperation(new OperationContext().withConfig(((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://172.17.0.2:8443")).withRequestRetryBackoffLimit(3)).build()).withPlural("pods").withName("test-pod").withOkhttpClient(mockClient));
        baseOp.setType(Pod.class);
        Exception exception = (Exception)Assertions.assertThrows(KubernetesClientException.class, () -> {
            Pod result = (Pod)baseOp.get();
        });
        Assert.assertTrue((String)"As the last failure, the 3rd one, is not an IOException the message expected to contain: 'Internal Server Error'!", (boolean)exception.getMessage().contains("Internal Server Error"));
        Assert.assertEquals((String)"Expected 4 calls: one normal try and 3 backoff retries!", (long)4L, (long)httpExecutionCounter.get());
    }

    @Test
    void testHttpRetryWithLessFailuresThanRetries() throws MalformedURLException, IOException {
        AtomicInteger httpExecutionCounter = new AtomicInteger(0);
        OkHttpClient mockClient = this.newHttpClientWithSomeFailures(httpExecutionCounter, 2);
        BaseOperation baseOp = new BaseOperation(new OperationContext().withConfig(((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://172.17.0.2:8443")).withRequestRetryBackoffLimit(3)).build()).withPlural("pods").withName("test-pod").withOkhttpClient(mockClient));
        baseOp.setType(Pod.class);
        Pod result = (Pod)baseOp.get();
        Assertions.assertNotNull((Object)result);
        Assert.assertEquals((String)"Expected 3 calls: 2 failures and 1 success!", (long)3L, (long)httpExecutionCounter.get());
    }
}

