
                                          

package io.fabric8.kubernetes.client.handlers.flowcontrol.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.flowcontrol.v1beta1.FlowSchemaOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.FlowSchema;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.FlowSchemaBuilder;

public class FlowSchemaHandler implements ResourceHandler<FlowSchema, FlowSchemaBuilder> {

  @Override
  public String getKind() {
    return FlowSchema.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "flowcontrol.apiserver.k8s.io/v1beta1";
      }

  @Override
  public FlowSchemaBuilder edit(FlowSchema item) {
    return new FlowSchemaBuilder(item);
  }

  @Override
  public Resource<FlowSchema> resource(OkHttpClient client, Config config, String namespace, FlowSchema item) {
    return new FlowSchemaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
