
                                          

package io.fabric8.kubernetes.client.handlers.events.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.events.v1.EventOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.events.v1.Event;
import io.fabric8.kubernetes.api.model.events.v1.EventBuilder;

public class EventHandler implements ResourceHandler<Event, EventBuilder> {

  @Override
  public String getKind() {
    return Event.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "events.k8s.io/v1";
      }

  @Override
  public EventBuilder edit(Event item) {
    return new EventBuilder(item);
  }

  @Override
  public Resource<Event> resource(OkHttpClient client, Config config, String namespace, Event item) {
    return new EventOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
