
                                          

package io.fabric8.kubernetes.client.handlers.core.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.ComponentStatusOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.ComponentStatus;
import io.fabric8.kubernetes.api.model.ComponentStatusBuilder;

public class ComponentStatusHandler implements ResourceHandler<ComponentStatus, ComponentStatusBuilder> {

  @Override
  public String getKind() {
    return ComponentStatus.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "v1";
      }

  @Override
  public ComponentStatusBuilder edit(ComponentStatus item) {
    return new ComponentStatusBuilder(item);
  }

  @Override
  public Resource<ComponentStatus> resource(OkHttpClient client, Config config, String namespace, ComponentStatus item) {
    return new ComponentStatusOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
