
                                          

package io.fabric8.kubernetes.client.handlers.coordination.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.coordination.v1.LeaseOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseBuilder;

public class LeaseHandler implements ResourceHandler<Lease, LeaseBuilder> {

  @Override
  public String getKind() {
    return Lease.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "coordination.k8s.io/v1";
      }

  @Override
  public LeaseBuilder edit(Lease item) {
    return new LeaseBuilder(item);
  }

  @Override
  public Resource<Lease> resource(OkHttpClient client, Config config, String namespace, Lease item) {
    return new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
