/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodListBuilder;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.client.utils.PodOperationUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class PodOperationUtilTest {
    private PodOperationsImpl podOperations;
    private OperationContext operationContext;

    PodOperationUtilTest() {
    }

    @BeforeEach
    void setUp() {
        this.podOperations = (PodOperationsImpl)Mockito.mock(PodOperationsImpl.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.operationContext = (OperationContext)Mockito.mock(OperationContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    }

    @Test
    void testGetFilteredPodsForLogs() {
        String controllerUid = "controller-uid-ejofjeofer";
        PodList podList = this.getMockPodList(controllerUid);
        List podResourceList = PodOperationUtil.getFilteredPodsForLogs((PodOperationsImpl)this.podOperations, (PodList)podList, (String)controllerUid);
        Assertions.assertNotNull((Object)podResourceList);
        Assertions.assertEquals((int)1, (int)podResourceList.size());
        ((PodOperationsImpl)Mockito.verify((Object)this.podOperations, (VerificationMode)Mockito.times((int)1))).withName((String)ArgumentMatchers.any());
    }

    @Test
    void testGetGenericPodOperations() {
        PodOperationsImpl podOperations = PodOperationUtil.getGenericPodOperations((OperationContext)this.operationContext, (boolean)false, (Integer)5);
        Assertions.assertNotNull((Object)podOperations);
        Assertions.assertNull((Object)podOperations.getName());
    }

    @Test
    void testWaitUntilReadyBeforeFetchingLogs() throws InterruptedException {
        Pod pod = ((PodBuilder)((PodFluent.StatusNested)((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("foo")).endMetadata()).withNewStatus().withPhase("Pending")).endStatus()).build();
        Gettable gettablePod = () -> pod;
        Mockito.when((Object)this.podOperations.fromServer()).thenReturn((Object)gettablePod);
        Mockito.when((Object)this.podOperations.waitUntilReady(5L, TimeUnit.SECONDS)).thenReturn((Object)pod);
        PodOperationUtil.waitUntilReadyBeforeFetchingLogs((PodResource)this.podOperations, (Integer)5);
        ((PodOperationsImpl)Mockito.verify((Object)this.podOperations, (VerificationMode)Mockito.times((int)1))).waitUntilReady(5L, TimeUnit.SECONDS);
    }

    @Test
    void testGetPodOperationsForController() {
        String controllerUid = "some-uid";
        Map<String, String> selectorLabels = Collections.singletonMap("foo", "bar");
        FilterWatchListDeletable<Pod, PodList> filterWatchListDeletable = this.getMockPodFilterOperation(controllerUid);
        Mockito.when((Object)this.podOperations.withLabels((Map)ArgumentMatchers.any())).thenReturn(filterWatchListDeletable);
        List podResources = PodOperationUtil.getPodOperationsForController((PodOperationsImpl)this.podOperations, (String)controllerUid, selectorLabels);
        Assertions.assertNotNull((Object)podResources);
        Assertions.assertEquals((int)1, (int)podResources.size());
    }

    private PodList getMockPodList(String controllerUid) {
        return ((PodListBuilder)((PodListBuilder)new PodListBuilder().addToItems(new Pod[]{((PodBuilder)((PodFluent.MetadataNested)((ObjectMetaFluent.OwnerReferencesNested)((ObjectMetaFluent.OwnerReferencesNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).addNewOwnerReference().withController(Boolean.valueOf(true))).withUid(controllerUid)).endOwnerReference()).endMetadata()).build()})).addToItems(new Pod[]{((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod2")).endMetadata()).build()})).build();
    }

    private FilterWatchListDeletable<Pod, PodList> getMockPodFilterOperation(final String controllerUid) {
        FilterWatchListDeletable result = (FilterWatchListDeletable)Mockito.mock(FilterWatchListDeletable.class);
        Mockito.when((Object)result.list()).then((Answer)new Answer<PodList>(){

            public PodList answer(InvocationOnMock invocation) throws Throwable {
                return PodOperationUtilTest.this.getMockPodList(controllerUid);
            }
        });
        return result;
    }
}

