/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.cache.ProcessorListener;
import io.fabric8.kubernetes.client.informers.cache.SharedProcessor;
import junit.framework.TestCase;
import org.junit.jupiter.api.Test;

class SharedProcessorTest {
    SharedProcessorTest() {
    }

    @Test
    void testListenerAddition() throws InterruptedException {
        SharedProcessor sharedProcessor = new SharedProcessor();
        Pod foo1 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("foo1")).withNamespace("default")).endMetadata()).build();
        ProcessorListener.AddNotification addNotification = new ProcessorListener.AddNotification((Object)foo1);
        ProcessorListener.UpdateNotification updateNotification = new ProcessorListener.UpdateNotification(null, (Object)foo1);
        ProcessorListener.DeleteNotification deleteNotification = new ProcessorListener.DeleteNotification((Object)foo1);
        ExpectingNotificationHandler expectAddHandler = new ExpectingNotificationHandler(addNotification);
        ExpectingNotificationHandler expectUpdateHandler = new ExpectingNotificationHandler(updateNotification);
        ExpectingNotificationHandler expectDeleteHandler = new ExpectingNotificationHandler(deleteNotification);
        sharedProcessor.addListener(expectAddHandler);
        sharedProcessor.addListener(expectUpdateHandler);
        sharedProcessor.addListener(expectDeleteHandler);
        sharedProcessor.distribute((ProcessorListener.Notification)addNotification, false);
        sharedProcessor.distribute((ProcessorListener.Notification)updateNotification, false);
        sharedProcessor.distribute((ProcessorListener.Notification)deleteNotification, false);
        TestCase.assertTrue((boolean)expectAddHandler.isSatisfied());
        TestCase.assertTrue((boolean)expectUpdateHandler.isSatisfied());
        TestCase.assertTrue((boolean)expectDeleteHandler.isSatisfied());
    }

    private static class ExpectingNotificationHandler<T>
    extends ProcessorListener<T> {
        private ProcessorListener.Notification<T> expectingNotification;
        private boolean satisfied;

        ExpectingNotificationHandler(ProcessorListener.Notification<T> notification) {
            this(new ResourceEventHandler<T>(){

                public void onAdd(T obj) {
                }

                public void onUpdate(T oldObj, T newObj) {
                }

                public void onDelete(T obj, boolean deletedFinalStateUnknown) {
                }
            }, 0L);
            this.expectingNotification = notification;
        }

        ExpectingNotificationHandler(ResourceEventHandler<T> handler, long resyncPeriod) {
            super(handler, resyncPeriod);
        }

        public void add(ProcessorListener.Notification<T> obj) {
            super.add(obj);
            if (!this.satisfied) {
                this.satisfied = obj.equals(this.expectingNotification);
            }
        }

        boolean isSatisfied() {
            return this.satisfied;
        }
    }
}

