/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodListBuilder;
import io.fabric8.kubernetes.api.model.PodListFluent;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.informers.ListerWatcher;
import io.fabric8.kubernetes.client.informers.cache.Reflector;
import io.fabric8.kubernetes.client.informers.cache.SyncableStore;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ReflectorTest {
    ReflectorTest() {
    }

    @Test
    void testStateFlags() {
        ListerWatcher mock = (ListerWatcher)Mockito.mock(ListerWatcher.class);
        PodList list = ((PodListBuilder)((PodListFluent.MetadataNested)new PodListBuilder().withNewMetadata().withResourceVersion("1")).endMetadata()).build();
        Mockito.when((Object)mock.list((ListOptions)Mockito.any(), (String)Mockito.any(), (OperationContext)Mockito.any())).thenReturn((Object)list);
        Reflector reflector = new Reflector(Pod.class, mock, (SyncableStore)Mockito.mock(SyncableStore.class), new OperationContext());
        Assertions.assertFalse((boolean)reflector.isWatching());
        Assertions.assertFalse((boolean)reflector.isRunning());
        Mockito.when((Object)mock.watch((ListOptions)Mockito.any(), (String)Mockito.any(), (OperationContext)Mockito.any(), (Watcher)Mockito.any())).thenThrow(new Throwable[]{new KubernetesClientException("error")}).thenReturn(Mockito.mock(Watch.class));
        Assertions.assertThrows(KubernetesClientException.class, () -> reflector.listSyncAndWatch());
        Assertions.assertFalse((boolean)reflector.isWatching());
        Assert.assertTrue((boolean)reflector.isRunning());
        reflector.listSyncAndWatch();
        Assert.assertTrue((boolean)reflector.isWatching());
        Assert.assertTrue((boolean)reflector.isRunning());
        reflector.stop();
        Assertions.assertFalse((boolean)reflector.isWatching());
        Assertions.assertFalse((boolean)reflector.isRunning());
    }

    @Test
    void testNonHttpGone() {
        ListerWatcher mock = (ListerWatcher)Mockito.mock(ListerWatcher.class);
        PodList list = ((PodListBuilder)((PodListFluent.MetadataNested)new PodListBuilder().withNewMetadata().withResourceVersion("1")).endMetadata()).build();
        Mockito.when((Object)mock.list((ListOptions)Mockito.any(), (String)Mockito.any(), (OperationContext)Mockito.any())).thenReturn((Object)list);
        Reflector reflector = new Reflector(Pod.class, mock, (SyncableStore)Mockito.mock(SyncableStore.class), new OperationContext());
        reflector.listSyncAndWatch();
        Assert.assertTrue((boolean)reflector.isWatching());
        Assert.assertTrue((boolean)reflector.isRunning());
        reflector.getWatcher().onClose(new WatcherException(null));
        Assertions.assertFalse((boolean)reflector.isWatching());
        Assertions.assertFalse((boolean)reflector.isRunning());
    }
}

