/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Kind;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import okhttp3.OkHttpClient;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class SharedInformerFactoryTest {
    public static final long RESYNC_PERIOD = 10000L;
    private OkHttpClient mockClient;
    private Config config;
    private ExecutorService executorService;

    SharedInformerFactoryTest() {
    }

    @BeforeEach
    void init() {
        this.mockClient = (OkHttpClient)Mockito.mock(OkHttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://localhost:8443/")).build();
        this.executorService = (ExecutorService)Mockito.mock(ExecutorService.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    }

    @Test
    void testInformersCreatedWithSameNameButDifferentCRDContext() {
        SharedInformerFactory sharedInformerFactory = new SharedInformerFactory(this.executorService, this.mockClient, this.config);
        sharedInformerFactory.sharedIndexInformerForCustomResource(TestCustomResource.class, new OperationContext().withApiGroupVersion("v1").withPlural("testcustomresources"), 10000L);
        sharedInformerFactory.sharedIndexInformerForCustomResource(TestCustomResource.class, new OperationContext().withApiGroupVersion("v1beta1").withPlural("testcustomresources"), 10000L);
        Assertions.assertThat((List)sharedInformerFactory.getExistingSharedIndexInformers()).hasSize(2);
    }

    @Test
    void testSharedIndexInformerForCustomResourceNoType() {
        SharedInformerFactory sharedInformerFactory = new SharedInformerFactory(this.executorService, this.mockClient, this.config);
        CustomResourceDefinitionContext context = new CustomResourceDefinitionContext.Builder().withKind("Dummy").withScope("Namespaced").withVersion("v1").withGroup("demos.fabric8.io").withPlural("dummies").build();
        SharedIndexInformer informer = sharedInformerFactory.inNamespace("ns1").sharedIndexInformerForCustomResource(context, 10000L);
        Assertions.assertThat((Object)informer).isNotNull();
        Assertions.assertThat((List)sharedInformerFactory.getExistingSharedIndexInformers()).hasSize(1);
    }

    @Test
    void testGetExistingSharedIndexInformer() {
        SharedInformerFactory sharedInformerFactory = new SharedInformerFactory(this.executorService, this.mockClient, this.config);
        sharedInformerFactory.sharedIndexInformerFor(Deployment.class, 10000L);
        sharedInformerFactory.sharedIndexInformerFor(Pod.class, 10000L);
        Assertions.assertThat((Object)sharedInformerFactory.getExistingSharedIndexInformer(Deployment.class)).isNotNull();
        Assertions.assertThat((Object)sharedInformerFactory.getExistingSharedIndexInformer(Pod.class)).isNotNull();
    }

    @Test
    void testGetExistingSharedIndexInformerWithKindDifferentFromClassName() {
        SharedInformerFactory sharedInformerFactory = new SharedInformerFactory(this.executorService, this.mockClient, this.config);
        SharedIndexInformer createdInformer = sharedInformerFactory.sharedIndexInformerFor(MyAppCustomResource.class, 10000L);
        SharedIndexInformer existingInformer = sharedInformerFactory.getExistingSharedIndexInformer(MyAppCustomResource.class);
        Assertions.assertThat((Object)createdInformer).isNotNull();
        Assertions.assertThat((Object)existingInformer).isNotNull();
        Assertions.assertThat((Object)createdInformer).isEqualTo((Object)existingInformer);
    }

    @Test
    void testGetExistingSharedIndexInformerWithTwoClassesSimilarNames() {
        SharedInformerFactory sharedInformerFactory = new SharedInformerFactory(this.executorService, this.mockClient, this.config);
        sharedInformerFactory.sharedIndexInformerFor(VirtualService.class, 10000L);
        sharedInformerFactory.sharedIndexInformerFor(Service.class, 10000L);
        SharedIndexInformer sharedIndexInformerSvc = sharedInformerFactory.getExistingSharedIndexInformer(Service.class);
        SharedIndexInformer sharedIndexInformerVSvc = sharedInformerFactory.getExistingSharedIndexInformer(VirtualService.class);
        Assertions.assertThat((Class)sharedIndexInformerSvc.getApiTypeClass()).isEqualTo(Service.class);
        Assertions.assertThat((Class)sharedIndexInformerVSvc.getApiTypeClass()).isEqualTo(VirtualService.class);
    }

    @Test
    void testGetExistingSharedIndexInformersReturnsListOfOperationContextAndSharedIndexInformerEntries() {
        SharedInformerFactory sharedInformerFactory = new SharedInformerFactory(this.executorService, this.mockClient, this.config);
        sharedInformerFactory.sharedIndexInformerFor(MyAppCustomResource.class, 10000L);
        sharedInformerFactory.sharedIndexInformerFor(Secret.class, 10000L);
        sharedInformerFactory.sharedIndexInformerFor(MyAppCustomResourceCopy.class, 10000L);
        List existingInformers = sharedInformerFactory.getExistingSharedIndexInformers();
        ((ListAssert)Assertions.assertThat((List)existingInformers).isNotNull()).hasSize(3);
        Assertions.assertThat((String)((OperationContext)((Map.Entry)existingInformers.get(0)).getKey()).getPlural()).isEqualTo("myapps");
        Assertions.assertThat((String)((OperationContext)((Map.Entry)existingInformers.get(1)).getKey()).getPlural()).isEqualTo("secrets");
        Assertions.assertThat((String)((OperationContext)((Map.Entry)existingInformers.get(2)).getKey()).getPlural()).isEqualTo("myapps");
    }

    @Group(value="networking.istio.io")
    @Version(value="v1alpha3")
    public static class VirtualService
    extends CustomResource<Void, Void> {
    }

    @Group(value="com.acme")
    @Version(value="v1")
    @Kind(value="MyApp")
    @Plural(value="myapps")
    public static class MyAppCustomResourceCopy
    extends CustomResource<Void, Void> {
    }

    @Group(value="com.acme")
    @Version(value="v1")
    @Kind(value="MyApp")
    public static class MyAppCustomResource
    extends CustomResource<Void, Void> {
    }

    @Group(value="io.fabric8")
    @Version(value="v1")
    private static class TestCustomResource
    extends CustomResource<TestCustomResourceSpec, TestCustomResourceStatus> {
        private TestCustomResource() {
        }
    }

    private static class TestCustomResourceStatus {
        private TestCustomResourceStatus() {
        }
    }

    private static class TestCustomResourceSpec {
        private TestCustomResourceSpec() {
        }
    }
}

