/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.extended.leaderelection.resourcelock;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Namespaceable;
import io.fabric8.kubernetes.client.dsl.Replaceable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.ConfigMapLock;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.LeaderElectionRecord;
import java.io.Serializable;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class ConfigMapLockTest {
    private DefaultKubernetesClient kc;
    private MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> configMaps;
    private ConfigMapBuilder configMapBuilder;
    private ConfigMapFluent.MetadataNested<ConfigMapBuilder> metadata;

    ConfigMapLockTest() {
    }

    @BeforeEach
    void setUp() {
        this.kc = (DefaultKubernetesClient)Mockito.mock(DefaultKubernetesClient.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        this.configMaps = (MixedOperation)Mockito.mock(MixedOperation.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        this.configMapBuilder = (ConfigMapBuilder)Mockito.mock(ConfigMapBuilder.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        this.metadata = (ConfigMapFluent.MetadataNested)Mockito.mock(ConfigMapFluent.MetadataNested.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.kc.inNamespace(ArgumentMatchers.anyString()).configMaps()).thenReturn(this.configMaps);
        Mockito.when((Object)this.configMapBuilder.editOrNewMetadata()).thenReturn(this.metadata);
    }

    @AfterEach
    void tearDown() {
        this.metadata = null;
        this.configMapBuilder = null;
        this.configMaps = null;
        this.kc = null;
    }

    @Test
    void missingNamespaceShouldThrowException() {
        Executable newInstance = () -> new ConfigMapLock(null, "name", "1337");
        Assertions.assertThrows(NullPointerException.class, (Executable)newInstance);
    }

    @Test
    void missingNameShouldThrowException() {
        Executable newInstance = () -> new ConfigMapLock("namespace", null, "1337");
        Assertions.assertThrows(NullPointerException.class, (Executable)newInstance);
    }

    @Test
    void missingIdentityShouldThrowException() {
        Executable newInstance = () -> new ConfigMapLock("namespace", "name", null);
        Assertions.assertThrows(NullPointerException.class, (Executable)newInstance);
    }

    @Test
    void getWithExistingConfigMapShouldReturnLeaderElectionRecord() {
        ConfigMap cm = new ConfigMap();
        Mockito.when((Object)((Resource)this.configMaps.withName((String)ArgumentMatchers.eq((Object)"name"))).get()).thenReturn((Object)cm);
        cm.setMetadata(((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withAnnotations(Collections.singletonMap("control-plane.alpha.kubernetes.io/leader", "{\"holderIdentity\":\"1337\",\"leaseDuration\":15,\"acquireTime\":1445401740,\"renewTime\":1445412480}"))).withResourceVersion("313373")).build());
        ConfigMapLock lock = new ConfigMapLock("namespace", "name", "1337");
        LeaderElectionRecord result = lock.get((Namespaceable)this.kc);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)"313373", (Object)result.getVersion());
        Assertions.assertEquals((Object)"1337", (Object)result.getHolderIdentity());
        Assertions.assertEquals((long)15L, (long)result.getLeaseDuration().getSeconds());
        Assertions.assertEquals((Object)ZonedDateTime.of(2015, 10, 21, 4, 29, 0, 0, ZoneId.of("UTC")), (Object)result.getAcquireTime());
    }

    @Test
    void createWithValidLeaderElectionRecordShouldSendPostRequest() throws Exception {
        LeaderElectionRecord record = new LeaderElectionRecord("1", Duration.ofSeconds(1L), ZonedDateTime.now(), ZonedDateTime.now(), 0);
        ConfigMapLock lock = new ConfigMapLock("namespace", "name", "1337");
        lock.create((Namespaceable)this.kc, record);
        ((Resource)Mockito.verify((Object)this.configMaps.withName("name"), (VerificationMode)Mockito.times((int)1))).create(ArgumentMatchers.any(ConfigMap.class));
    }

    @Test
    void updateWithValidLeaderElectionRecordShouldSendPutRequest() throws Exception {
        Resource configMapResource = (Resource)this.configMaps.withName("name");
        Replaceable replaceable = (Replaceable)Mockito.mock(Replaceable.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)configMapResource.lockResourceVersion((String)ArgumentMatchers.any())).thenReturn((Object)replaceable);
        ConfigMap configMapInTheCluster = new ConfigMap();
        configMapInTheCluster.setMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withAnnotations(new HashMap())).build());
        Mockito.when((Object)configMapResource.get()).thenReturn((Object)configMapInTheCluster);
        LeaderElectionRecord record = new LeaderElectionRecord("1337", Duration.ofSeconds(1L), ZonedDateTime.now(), ZonedDateTime.now(), 0);
        record.setVersion((Serializable)((Object)"313373"));
        ConfigMapLock lock = new ConfigMapLock("namespace", "name", "1337");
        lock.update((Namespaceable)this.kc, record);
        ((Replaceable)Mockito.verify((Object)replaceable, (VerificationMode)Mockito.times((int)1))).replace(ArgumentMatchers.eq((Object)configMapInTheCluster));
    }

    @Test
    void identityShouldReturnProvidedIdentity() {
        ConfigMapLock configMapLock = new ConfigMapLock("namespace", "name", "1337");
        String identity = configMapLock.identity();
        Assertions.assertEquals((Object)"1337", (Object)identity);
    }

    @Test
    void describeShouldReturnAnIdentifiableDescription() {
        ConfigMapLock configMapLock = new ConfigMapLock("namespace", "name", "1337");
        String description = configMapLock.describe();
        Assertions.assertEquals((Object)"ConfigMapLock: namespace - name (1337)", (Object)description);
    }
}

