/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.CascadingDeletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerWritable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.VisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.VisitFromServerWritable;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class DryRunTest {
    private OkHttpClient mockClient;
    private KubernetesClient kubernetesClient;

    DryRunTest() {
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.mockClient = (OkHttpClient)Mockito.mock(OkHttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://localhost:8443/")).build();
        Call mockCall = (Call)Mockito.mock(Call.class);
        Response mockResponse = new Response.Builder().request(new Request.Builder().url("http://mock").build()).protocol(Protocol.HTTP_1_1).code(200).body(ResponseBody.create((MediaType)MediaType.get((String)"application/json"), (String)"{}")).message("mock").build();
        Mockito.when((Object)mockCall.execute()).thenReturn((Object)mockResponse);
        Mockito.when((Object)this.mockClient.newCall((Request)ArgumentMatchers.any())).thenReturn((Object)mockCall);
        this.kubernetesClient = new DefaultKubernetesClient(this.mockClient, config);
    }

    @Test
    void testDryRunDisable() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        Pod pod = (Pod)((WritableOperation)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).dryRun(false)).create((Object)this.getPod("pod1"));
        ((OkHttpClient)Mockito.verify((Object)this.mockClient)).newCall((Request)captor.capture());
        this.assertRequest((Request)captor.getValue(), "POST", "/api/v1/namespaces/ns1/pods", null);
        Assertions.assertNotNull((Object)pod);
    }

    @Test
    void testDryRunEnable() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        Pod pod = (Pod)((WritableOperation)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).dryRun(true)).create((Object)this.getPod("pod1"));
        ((OkHttpClient)Mockito.verify((Object)this.mockClient)).newCall((Request)captor.capture());
        this.assertRequest((Request)captor.getValue(), "POST", "/api/v1/namespaces/ns1/pods", "dryRun=All");
        Assertions.assertNotNull((Object)pod);
    }

    @Test
    void testCreate() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        Pod pod = (Pod)((WritableOperation)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).dryRun()).create((Object)this.getPod("pod1"));
        ((OkHttpClient)Mockito.verify((Object)this.mockClient)).newCall((Request)captor.capture());
        this.assertRequest((Request)captor.getValue(), "POST", "/api/v1/namespaces/ns1/pods", "dryRun=All");
        Assertions.assertNotNull((Object)pod);
    }

    @Test
    void testCreateOrReplace() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        Pod pod = (Pod)((WritableOperation)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).dryRun()).createOrReplace((Object[])new Pod[]{this.getPod("pod1")});
        ((OkHttpClient)Mockito.verify((Object)this.mockClient)).newCall((Request)captor.capture());
        Assertions.assertNotNull((Object)pod);
        this.assertRequest((Request)captor.getValue(), "POST", "/api/v1/namespaces/ns1/pods", "dryRun=All");
    }

    @Test
    void testPatch() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        ((WritableOperation)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("pod1")).dryRun()).patch((Object)this.getPod("pod1"));
        ((OkHttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).newCall((Request)captor.capture());
        this.assertRequest((Request)captor.getValue(), "PATCH", "/api/v1/namespaces/ns1/pods/pod1", "dryRun=All");
    }

    @Test
    void testReplace() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        ((WritableOperation)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("pod1")).dryRun()).replace((Object)this.getPod("pod1"));
        ((OkHttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).newCall((Request)captor.capture());
        this.assertRequest((Request)captor.getValue(), "PUT", "/api/v1/namespaces/ns1/pods/pod1", "dryRun=All");
    }

    @Test
    void testDelete() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        ((EditReplacePatchDeletable)((WritableOperation)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("pod1")).dryRun()).withPropagationPolicy(DeletionPropagation.BACKGROUND)).delete();
        ((OkHttpClient)Mockito.verify((Object)this.mockClient)).newCall((Request)captor.capture());
        this.assertRequest((Request)captor.getValue(), "DELETE", "/api/v1/namespaces/ns1/pods/pod1", "dryRun=All");
    }

    @Test
    void testResourceCreateOrReplace() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        ((VisitFromServerWritable)((VisitFromServerGetWatchDeleteRecreateWaitApplicable)this.kubernetesClient.resource((HasMetadata)this.getPod("pod1")).inNamespace("ns1")).dryRun()).createOrReplace();
        ((OkHttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).newCall((Request)captor.capture());
        this.assertRequest((Request)captor.getValue(), "POST", "/api/v1/namespaces/ns1/pods", "dryRun=All");
    }

    @Test
    void testResourceDelete() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        ((CascadingDeletable)((VisitFromServerWritable)((VisitFromServerGetWatchDeleteRecreateWaitApplicable)this.kubernetesClient.resource((HasMetadata)this.getPod("pod1")).inNamespace("ns1")).dryRun()).withPropagationPolicy(DeletionPropagation.BACKGROUND)).delete();
        ((OkHttpClient)Mockito.verify((Object)this.mockClient)).newCall((Request)captor.capture());
        this.assertRequest((Request)captor.getValue(), "DELETE", "/api/v1/namespaces/ns1/pods/pod1", "dryRun=All");
    }

    @Test
    void testResourceListCreateOrReplace() {
        Pod pod = this.getPod("pod1");
        Service svc = ((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc1")).endMetadata()).build();
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        ((ListVisitFromServerWritable)((ListVisitFromServerGetDeleteRecreateWaitApplicable)this.kubernetesClient.resourceList(new HasMetadata[]{pod, svc}).inNamespace("ns1")).dryRun()).createOrReplace();
        ((OkHttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).newCall((Request)captor.capture());
        this.assertRequest((Request)captor.getAllValues().get(0), "POST", "/api/v1/namespaces/ns1/services", "dryRun=All");
        this.assertRequest((Request)captor.getAllValues().get(1), "POST", "/api/v1/namespaces/ns1/pods", "dryRun=All");
    }

    @Test
    void testResourceListDelete() {
        Pod pod = this.getPod("pod1");
        Service svc = ((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("svc1")).endMetadata()).build();
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        ((CascadingDeletable)((ListVisitFromServerWritable)((ListVisitFromServerGetDeleteRecreateWaitApplicable)this.kubernetesClient.resourceList(new HasMetadata[]{pod, svc}).inNamespace("ns1")).dryRun()).withPropagationPolicy(DeletionPropagation.BACKGROUND)).delete();
        ((OkHttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).newCall((Request)captor.capture());
        this.assertRequest((Request)captor.getAllValues().get(0), "DELETE", "/api/v1/namespaces/ns1/services/svc1", "dryRun=All");
        this.assertRequest((Request)captor.getAllValues().get(1), "DELETE", "/api/v1/namespaces/ns1/pods/pod1", "dryRun=All");
    }

    private Pod getPod(String name) {
        return ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(name)).endMetadata()).build();
    }

    private void assertRequest(Request request, String method, String url, String queryParam) {
        Assertions.assertEquals((Object)url, (Object)request.url().encodedPath());
        Assertions.assertEquals((Object)method, (Object)request.method());
        Assertions.assertEquals((Object)queryParam, (Object)request.url().encodedQuery());
    }
}

