/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class DefaultKubernetesClientTest {
    private DefaultKubernetesClient defaultKubernetesClient;

    DefaultKubernetesClientTest() {
    }

    @BeforeEach
    public void setUp() {
        this.defaultKubernetesClient = new DefaultKubernetesClient();
    }

    @AfterEach
    public void tearDown() {
        this.defaultKubernetesClient.close();
        this.defaultKubernetesClient = null;
    }

    @Test
    void testInitClientWithCustomHeaderConfiguration() {
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        customHeaders.put("user-id", "test-user");
        customHeaders.put("cluster-id", "test-cluster");
        Config configWithCustomerHeaders = ((ConfigBuilder)new ConfigBuilder().withCustomHeaders(customHeaders)).build();
        DefaultKubernetesClient customHeaderConfigClient = new DefaultKubernetesClient(configWithCustomerHeaders);
        Assertions.assertThat((List)customHeaderConfigClient.getHttpClient().networkInterceptors()).hasSize(1);
    }

    @Test
    void testInitClientWithDefaultConfiguration() {
        Config defaultEmptyConfig = new ConfigBuilder().build();
        DefaultKubernetesClient defaultConfigClient = new DefaultKubernetesClient(defaultEmptyConfig);
        Assertions.assertThat((List)defaultConfigClient.getHttpClient().networkInterceptors()).isEmpty();
    }

    @Test
    @DisplayName(value="load, InputStream containing List with windows like line-ends (CRLF), all list items should be available")
    void loadWithWindowsLineSeparatorsString() throws Exception {
        List<String> fileLines = Files.readAllLines(new File(DefaultKubernetesClientTest.class.getResource("/test-list.yml").getFile()).toPath(), StandardCharsets.UTF_8);
        String crlfFile = String.join((CharSequence)" \r\n", fileLines);
        List result = (List)new DefaultKubernetesClient().load((InputStream)new ByteArrayInputStream(crlfFile.getBytes(StandardCharsets.UTF_8))).get();
        ((ListAssert)((ListAssert)Assertions.assertThat((List)result).hasSize(2)).hasAtLeastOneElementOfType(Service.class)).hasAtLeastOneElementOfType(Deployment.class);
    }
}

