/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Applicable;
import io.fabric8.kubernetes.client.dsl.CascadingDeletable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerWritable;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.Readiable;
import io.fabric8.kubernetes.client.dsl.Waitable;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.dsl.internal.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import io.fabric8.kubernetes.client.utils.CreateOrReplaceHelper;
import io.fabric8.kubernetes.client.utils.DeleteAndCreateHelper;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl
extends OperationSupport
implements ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata>,
Waitable<List<HasMetadata>, HasMetadata>,
Readiable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.class);
    protected static final String EXPRESSION = "expression";
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final String fallbackNamespace;
    private final String explicitNamespace;
    private final Boolean fromServer;
    private final Boolean deletingExisting;
    private final List<Visitor> visitors;
    private final long watchRetryInitialBackoffMillis;
    private final double watchRetryBackoffMultiplier;
    private final Object item;
    private final InputStream inputStream;
    private final long gracePeriodSeconds;
    private final DeletionPropagation propagationPolicy;
    private final Boolean cascading;

    @Override
    public List<HasMetadata> waitUntilReady(long amount, TimeUnit timeUnit) {
        return this.waitUntilCondition(resource -> Objects.nonNull(resource) && this.getReadiness().isReady((HasMetadata)resource), amount, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HasMetadata> waitUntilCondition(Predicate<HasMetadata> condition, long amount, TimeUnit timeUnit) {
        List<HasMetadata> items = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.acceptVisitors(this.asHasMetadata(this.item, true), this.visitors);
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        ExecutorService executor = Executors.newFixedThreadPool(items.size(), Utils.daemonThreadFactory(this));
        try {
            ArrayList<CompletableFuture<HasMetadata>> futures = new ArrayList<CompletableFuture<HasMetadata>>(items.size());
            for (HasMetadata meta : items) {
                ResourceHandler<HasMetadata, ?> h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
                futures.add(CompletableFuture.supplyAsync(() -> {
                    try {
                        return h.waitUntilCondition(this.client, this.config, meta.getMetadata().getNamespace(), meta, condition, amount, timeUnit);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                }, executor));
            }
            ArrayList results = new ArrayList();
            ArrayList<HasMetadata> itemsWithConditionNotMatched = new ArrayList<HasMetadata>();
            int i = 0;
            for (HasMetadata meta : items) {
                try {
                    CompletableFuture future = (CompletableFuture)futures.get(i);
                    results.add(future.get());
                }
                catch (ExecutionException e) {
                    itemsWithConditionNotMatched.add(meta);
                    NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.logAsNotReady(e.getCause(), meta);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw KubernetesClientException.launderThrowable(e);
                }
                ++i;
            }
            if (!itemsWithConditionNotMatched.isEmpty()) {
                throw new KubernetesClientTimeoutException(itemsWithConditionNotMatched, amount, timeUnit);
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        finally {
            executor.shutdownNow();
        }
    }

    private static void logAsNotReady(Throwable t, HasMetadata meta) {
        LOGGER.warn("Error while waiting for: [{}] with name: [{}] in namespace: [{}]: {}. The resource will be considered not ready.", new Object[]{meta.getKind(), meta.getMetadata().getName(), meta.getMetadata().getNamespace(), t.getMessage()});
        LOGGER.debug("The error stack trace:", t);
    }

    @Override
    public Boolean isReady() {
        for (HasMetadata meta : NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.acceptVisitors((List<HasMetadata>)this.get(), this.visitors)) {
            if (this.getReadiness().isReady(meta)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> withParameters(Map<String, String> parameters) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.namespace, this.explicitNamespace, this.fromServer, this.deletingExisting, this.visitors, null, this.inputStream, parameters, -1L, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public ListVisitFromServerWritable<HasMetadata> dryRun(boolean isDryRun) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.namespace, this.explicitNamespace, this.fromServer, this.deletingExisting, this.visitors, this.item, this.inputStream, null, -1L, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, isDryRun);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, InputStream is, Map<String, String> parameters, Boolean cascading, DeletionPropagation propagationPolicy, boolean dryRun) {
        this(client, config, namespace, explicitNamespace, fromServer, deletingExisting, visitors, null, is, parameters, -1L, propagationPolicy, cascading, 5L, 2.0, dryRun);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, Object item, Map<String, String> parameters, DeletionPropagation propagationPolicy, Boolean cascading, boolean dryRun) {
        this(client, config, namespace, explicitNamespace, fromServer, deletingExisting, visitors, item, null, parameters, -1L, propagationPolicy, cascading, 5L, 2.0, dryRun);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, Object item, InputStream inputStream, Map<String, String> parameters, long gracePeriodSeconds, DeletionPropagation propagationPolicy, Boolean cascading, long watchRetryInitialBackoffMillis, double watchRetryBackoffMultiplier, boolean dryRun) {
        super(client, config);
        this.fallbackNamespace = namespace;
        this.explicitNamespace = explicitNamespace;
        this.fromServer = fromServer;
        this.deletingExisting = deletingExisting;
        this.visitors = visitors != null ? new ArrayList<Visitor>(visitors) : new ArrayList();
        this.watchRetryInitialBackoffMillis = watchRetryInitialBackoffMillis;
        this.watchRetryBackoffMultiplier = watchRetryBackoffMultiplier;
        if (item != null) {
            this.item = item;
        } else if (inputStream != null) {
            this.item = Serialization.unmarshal(inputStream, parameters);
        } else {
            throw new IllegalArgumentException("Need to either specify an Object or an InputStream.");
        }
        this.inputStream = inputStream;
        this.cascading = cascading;
        this.gracePeriodSeconds = gracePeriodSeconds;
        this.propagationPolicy = propagationPolicy;
        this.dryRun = dryRun;
        this.visitors.add((Visitor)new ChangeNamespace(explicitNamespace, this.fallbackNamespace));
    }

    @Override
    public List<HasMetadata> apply() {
        return this.createOrReplace();
    }

    @Override
    public List<HasMetadata> createOrReplace() {
        ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
        for (HasMetadata meta : NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.acceptVisitors(this.asHasMetadata(this.item, true), this.visitors)) {
            String namespaceToUse;
            ResourceHandler<HasMetadata, ?> h;
            HasMetadata createdItem = this.createOrReplaceOrDeleteExisting(meta, h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta), namespaceToUse = meta.getMetadata().getNamespace(), this.dryRun);
            if (createdItem == null) continue;
            result.add(createdItem);
        }
        return result;
    }

    @Override
    public Waitable<List<HasMetadata>, HasMetadata> createOrReplaceAnd() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, this.deletingExisting, this.visitors, this.createOrReplace(), this.inputStream, null, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public Boolean delete() {
        for (HasMetadata meta : NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.acceptVisitors(this.asHasMetadata(this.item, true), this.visitors)) {
            if (NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta) != null) continue;
            return false;
        }
        for (HasMetadata meta : NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.acceptVisitors(this.asHasMetadata(this.item, true), this.visitors)) {
            ResourceHandler<HasMetadata, ?> h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
            if (h.delete(this.client, this.config, meta.getMetadata().getNamespace(), this.propagationPolicy, this.gracePeriodSeconds, meta, this.dryRun).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<HasMetadata> get() {
        if (this.fromServer.booleanValue()) {
            ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
            for (HasMetadata meta : NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.acceptVisitors(this.asHasMetadata(this.item, true), this.visitors)) {
                ResourceHandler<HasMetadata, ?> h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
                HasMetadata reloaded = h.reload(this.client, this.config, meta.getMetadata().getNamespace(), meta);
                if (reloaded == null) continue;
                HasMetadata edited = reloaded;
                for (Visitor v : this.visitors) {
                    ((VisitableBuilder)h.edit(edited).accept(new Visitor[]{v})).build();
                }
                result.add(reloaded);
            }
            return result;
        }
        return NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.acceptVisitors(this.asHasMetadata(this.item, true), this.visitors);
    }

    private static List<HasMetadata> acceptVisitors(List<HasMetadata> list, List<Visitor> visitors) {
        ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
        for (HasMetadata item : list) {
            ResourceHandler<HasMetadata, ?> h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(item);
            Object builder = h.edit(item);
            for (Visitor v : visitors) {
                builder.accept(new Visitor[]{v});
            }
            result.add((HasMetadata)builder.build());
        }
        return result;
    }

    @Override
    public ListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> inNamespace(String explicitNamespace) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.fallbackNamespace, explicitNamespace, this.fromServer, this.deletingExisting, this.visitors, this.item, null, null, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public Gettable<List<HasMetadata>> fromServer() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, true, this.deletingExisting, this.visitors, this.item, null, null, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public Applicable<List<HasMetadata>> deletingExisting() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, null, null, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    public ListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> accept(Visitor ... visitors) {
        ArrayList<Visitor> newVisitors = new ArrayList<Visitor>(this.visitors);
        for (Visitor v : visitors) {
            newVisitors.add(v);
        }
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, newVisitors, this.item, null, null, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public CascadingDeletable<List<HasMetadata>> withGracePeriod(long gracePeriodSeconds) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, null, null, gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public CascadingDeletable<List<HasMetadata>> withPropagationPolicy(DeletionPropagation propagationPolicy) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, null, null, this.gracePeriodSeconds, propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    @Override
    public Waitable<List<HasMetadata>, HasMetadata> withWaitRetryBackoff(long initialBackoff, TimeUnit backoffUnit, double backoffMultiplier) {
        long watchRetryInitialBackoffMillis = backoffUnit.toMillis(initialBackoff);
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, null, null, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, watchRetryInitialBackoffMillis, backoffMultiplier, this.dryRun);
    }

    @Override
    public Deletable cascading(boolean cascading) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, null, null, this.gracePeriodSeconds, this.propagationPolicy, cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.dryRun);
    }

    protected Readiness getReadiness() {
        return Readiness.getInstance();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> List<HasMetadata> asHasMetadata(T item, Boolean enableProcessing) {
        ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
        if (item instanceof KubernetesList) {
            result.addAll(((KubernetesList)item).getItems());
            return result;
        }
        if (item instanceof KubernetesResourceList) {
            result.addAll(((KubernetesResourceList)item).getItems());
            return result;
        }
        if (item instanceof HasMetadata) {
            result.add((HasMetadata)item);
            return result;
        }
        if (item instanceof String) {
            try (ByteArrayInputStream is = new ByteArrayInputStream(((String)item).getBytes(StandardCharsets.UTF_8));){
                List<HasMetadata> list = this.asHasMetadata(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.unmarshal(is), enableProcessing);
                return list;
            }
            catch (IOException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }
        if (!(item instanceof Collection)) return result;
        Iterator iterator = ((Collection)item).iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof HasMetadata)) continue;
            result.add((HasMetadata)o);
        }
        return result;
    }

    private HasMetadata createOrReplaceOrDeleteExisting(HasMetadata meta, ResourceHandler<HasMetadata, ?> h, String namespaceToUse, boolean dryRun) {
        if (Boolean.TRUE.equals(this.deletingExisting)) {
            return DeleteAndCreateHelper.deleteAndCreateItem(this.client, this.config, meta, h, namespaceToUse, this.propagationPolicy, this.gracePeriodSeconds, dryRun);
        }
        return CreateOrReplaceHelper.createOrReplaceItem(this.client, this.config, meta, h, namespaceToUse, dryRun);
    }

    private class ChangeNamespace
    extends TypedVisitor<ObjectMetaBuilder> {
        private final String explicitNamespace;
        private final String fallbackNamespace;

        private ChangeNamespace(String explicitNamespace, String fallbackNamespace) {
            this.explicitNamespace = explicitNamespace;
            this.fallbackNamespace = fallbackNamespace;
        }

        public void visit(ObjectMetaBuilder builder) {
            if (Utils.isNotNullOrEmpty(this.explicitNamespace)) {
                builder.withNamespace(this.explicitNamespace);
            } else if (Utils.isNullOrEmpty(builder.getNamespace())) {
                builder.withNamespace(this.fallbackNamespace);
            }
        }
    }
}

