
                                          

package io.fabric8.kubernetes.client.handlers.storage.v1beta1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.storage.v1beta1.CSIStorageCapacityOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacity;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class CSIStorageCapacityHandler implements ResourceHandler<CSIStorageCapacity, CSIStorageCapacityBuilder> {

  @Override
  public String getKind() {
    return CSIStorageCapacity.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "storage.k8s.io/v1beta1";
      }

  @Override
  public CSIStorageCapacity create(OkHttpClient client, Config config, String namespace, CSIStorageCapacity item, boolean dryRun) {
    return new CSIStorageCapacityOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public CSIStorageCapacity replace(OkHttpClient client, Config config, String namespace, CSIStorageCapacity item, boolean dryRun) {
    return new CSIStorageCapacityOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public CSIStorageCapacity reload(OkHttpClient client, Config config, String namespace, CSIStorageCapacity item) {
    return new CSIStorageCapacityOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public CSIStorageCapacityBuilder edit(CSIStorageCapacity item) {
    return new CSIStorageCapacityBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, CSIStorageCapacity item, boolean dryRun) {
    return new CSIStorageCapacityOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

@Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CSIStorageCapacity item, Watcher<CSIStorageCapacity> watcher) {
    return new CSIStorageCapacityOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CSIStorageCapacity item, String resourceVersion, Watcher<CSIStorageCapacity> watcher) {
    return new CSIStorageCapacityOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CSIStorageCapacity item, ListOptions options, Watcher<CSIStorageCapacity> watcher) {
    return new CSIStorageCapacityOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public CSIStorageCapacity waitUntilReady(OkHttpClient client, Config config, String namespace, CSIStorageCapacity item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CSIStorageCapacityOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public CSIStorageCapacity waitUntilCondition(OkHttpClient client, Config config, String namespace, CSIStorageCapacity item, Predicate<CSIStorageCapacity> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CSIStorageCapacityOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
