/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class SerializationTest {
    @Test
    void unmarshalCRDWithSchema() throws Exception {
        String input = this.readYamlToString("/test-crd-schema.yml");
        CustomResourceDefinition crd = (CustomResourceDefinition)Serialization.unmarshal((String)input, CustomResourceDefinition.class);
        JSONSchemaProps spec = (JSONSchemaProps)crd.getSpec().getValidation().getOpenAPIV3Schema().getProperties().get("spec");
        Assert.assertEquals((long)3L, (long)spec.getRequired().size());
        Assert.assertEquals((Object)"builderName", spec.getRequired().get(0));
        Assert.assertEquals((Object)"edges", spec.getRequired().get(1));
        Assert.assertEquals((Object)"dimensions", spec.getRequired().get(2));
        Map properties = spec.getProperties();
        Assert.assertNotNull(properties.get("builderName"));
        Assert.assertEquals((Object)((JSONSchemaProps)properties.get("builderName")).getExample(), (Object)new TextNode("builder-example"));
        Assert.assertEquals((Object)BooleanNode.FALSE, (Object)((JSONSchemaProps)properties.get("hollow")).getDefault());
        Assert.assertNotNull(properties.get("dimensions"));
        Assert.assertNotNull(((JSONSchemaProps)properties.get("dimensions")).getProperties().get("x"));
        Assert.assertEquals((Object)((JSONSchemaProps)((JSONSchemaProps)properties.get("dimensions")).getProperties().get("x")).getDefault(), (Object)new IntNode(10));
        String output = Serialization.asYaml((Object)crd);
        Assert.assertEquals((Object)input.trim(), (Object)output.trim());
    }

    @Test
    @DisplayName(value="unmarshal, String containing List with windows like line-ends (CRLF), all list items should be available")
    void unmarshalListWithWindowsLineSeparatorsString() throws Exception {
        String crlfFile = this.readYamlToString("/test-list.yml");
        KubernetesResource result = (KubernetesResource)Serialization.unmarshal((String)crlfFile, KubernetesResource.class);
        Assert.assertTrue((boolean)(result instanceof KubernetesList));
        KubernetesList kubernetesList = (KubernetesList)result;
        Assert.assertEquals((long)2L, (long)kubernetesList.getItems().size());
        Assert.assertTrue((boolean)(kubernetesList.getItems().get(0) instanceof Service));
        Assert.assertTrue((boolean)(kubernetesList.getItems().get(1) instanceof Deployment));
    }

    private String readYamlToString(String path) throws IOException {
        return Files.readAllLines(new File(SerializationTest.class.getResource(path).getFile()).toPath(), StandardCharsets.UTF_8).stream().filter(line -> !line.startsWith("#")).collect(Collectors.joining("\n"));
    }

    @Test
    @DisplayName(value="containsMultipleDocuments, multiple documents with windows line ends, should return true")
    void containsMultipleDocumentsWithMultipleDocumentsAndWindowsLineEnds() {
        String multiDocument = "---\r\napiVersion: v1\r\nKind: Something\r\n\r\n---\r\napiVersion: v2\r\nKind: Other";
        boolean result = Serialization.containsMultipleDocuments((String)"---\r\napiVersion: v1\r\nKind: Something\r\n\r\n---\r\napiVersion: v2\r\nKind: Other");
        Assert.assertTrue((boolean)result);
    }

    @Test
    @DisplayName(value="containsMultipleDocuments, single document with windows line ends, should return false")
    void containsMultipleDocumentsWithSingleDocumentAndWindowsLineEnds() {
        String multiDocument = "---\r\napiVersion: v1\r\nKind: Something\r\n\r\n";
        boolean result = Serialization.containsMultipleDocuments((String)"---\r\napiVersion: v1\r\nKind: Something\r\n\r\n");
        Assert.assertFalse((boolean)result);
    }

    @Test
    @DisplayName(value="containsMultipleDocuments, multiple documents with linux line ends, should return true")
    void containsMultipleDocumentsWithMultipleDocumentsAndLinuxLineEnds() {
        String multiDocument = "---\napiVersion: v1\nKind: Something\n\n---\napiVersion: v2\nKind: Other";
        boolean result = Serialization.containsMultipleDocuments((String)"---\napiVersion: v1\nKind: Something\n\n---\napiVersion: v2\nKind: Other");
        Assert.assertTrue((boolean)result);
    }

    @Test
    @DisplayName(value="containsMultipleDocuments, single document with linux line ends, should return false")
    void containsMultipleDocumentsWithSingleDocumentAndLinuxLineEnds() {
        String multiDocument = "---\napiVersion: v1\nKind: Something\n\n";
        boolean result = Serialization.containsMultipleDocuments((String)"---\napiVersion: v1\nKind: Something\n\n");
        Assert.assertFalse((boolean)result);
    }

    @Test
    void testSerializeYamlWithAlias() {
        InputStream fileInputStream = this.getClass().getResourceAsStream("/test-pod-manifest-with-aliases.yml");
        Pod pod = (Pod)Serialization.unmarshal((InputStream)fileInputStream);
        Assert.assertNotNull((Object)pod);
        Assert.assertEquals((Object)"test-pod-with-alias", (Object)pod.getMetadata().getName());
        Assert.assertEquals((Object)"build", pod.getSpec().getNodeSelector().get("workload"));
        Assert.assertEquals((long)1L, (long)pod.getSpec().getTolerations().size());
        Assert.assertEquals((long)1000L, (long)pod.getSpec().getSecurityContext().getRunAsGroup().intValue());
        Assert.assertEquals((long)1000L, (long)pod.getSpec().getSecurityContext().getRunAsUser().intValue());
        Assert.assertEquals((long)2L, (long)pod.getSpec().getContainers().size());
        Assert.assertEquals((Object)"ubuntu", (Object)((Container)pod.getSpec().getContainers().get(0)).getName());
        Assert.assertEquals((Object)"ubuntu:bionic", (Object)((Container)pod.getSpec().getContainers().get(0)).getImage());
        Assert.assertEquals((Object)new Quantity("100m"), ((Container)pod.getSpec().getContainers().get(0)).getResources().getRequests().get("cpu"));
        Assert.assertEquals((Object)"python3", (Object)((Container)pod.getSpec().getContainers().get(1)).getName());
        Assert.assertEquals((Object)"python:3.7", (Object)((Container)pod.getSpec().getContainers().get(1)).getImage());
        Assert.assertEquals((Object)new Quantity("100m"), ((Container)pod.getSpec().getContainers().get(1)).getResources().getRequests().get("cpu"));
    }

    @Test
    void testClone() {
        Pod pod = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod")).endMetadata()).build();
        Pod clonePod = (Pod)Serialization.clone((Object)pod);
        Assert.assertNotNull((Object)clonePod);
        Assert.assertNotSame((Object)pod, (Object)clonePod);
        Assert.assertEquals((Object)pod.getMetadata().getName(), (Object)clonePod.getMetadata().getName());
    }

    @Test
    void testSerializeYamlWithJsonSubTypes() {
        Root root = new Root();
        root.setTypeable(new Typed());
        Assert.assertEquals((Object)"---\ntypeable:\n  type: \"x\"\n", (Object)Serialization.asYaml((Object)root));
    }

    @Test
    void nullValueShouldNotBeOutput() {
        MyCR cr = new MyCR();
        String s = Serialization.asYaml((Object)((Object)cr));
        Assert.assertTrue((!s.contains("status") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.contains("spec: \"foo\""));
    }

    @Group(value="serialization.fabric8.io")
    @Version(value="v1")
    private static class MyCR
    extends CustomResource<String, Void> {
        public MyCR() {
            this.setSpec("foo");
        }
    }

    public static class Root {
        private Typeable typeable;

        public Typeable getTypeable() {
            return this.typeable;
        }

        public void setTypeable(Typeable typeable) {
            this.typeable = typeable;
        }
    }

    public static class Typed
    implements Typeable {
        @Override
        public String getType() {
            return "x";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Typed.class, name="x")})
    public static interface Typeable {
        public String getType();
    }
}

