/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.informers.cache.ProcessorListener;
import io.fabric8.kubernetes.client.informers.cache.ProcessorStore;
import io.fabric8.kubernetes.client.informers.cache.SharedProcessor;
import io.fabric8.kubernetes.client.informers.cache.Store;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ProcessorStoreTest {
    @Test
    public void testEvents() {
        ArgumentCaptor notificationCaptor = ArgumentCaptor.forClass(ProcessorListener.Notification.class);
        ArgumentCaptor syncCaptor = ArgumentCaptor.forClass(Boolean.class);
        Store podStore = (Store)Mockito.mock(Store.class);
        SharedProcessor processor = (SharedProcessor)Mockito.mock(SharedProcessor.class);
        ProcessorStore processorStore = new ProcessorStore(podStore, processor);
        Pod pod = new Pod();
        processorStore.add((Object)pod);
        processorStore.update((Object)pod);
        processorStore.delete((Object)pod);
        Mockito.when((Object)podStore.get((Object)pod)).thenReturn((Object)pod);
        processorStore.update((Object)pod);
        processorStore.delete((Object)pod);
        ((SharedProcessor)Mockito.verify((Object)processor, (VerificationMode)Mockito.times((int)4))).distribute((ProcessorListener.Notification)notificationCaptor.capture(), ((Boolean)syncCaptor.capture()).booleanValue());
        List notifications = notificationCaptor.getAllValues();
        Assertions.assertThat(notifications.get(0)).isInstanceOf(ProcessorListener.AddNotification.class);
        Assertions.assertThat(notifications.get(1)).isInstanceOf(ProcessorListener.AddNotification.class);
        Assertions.assertThat(notifications.get(2)).isInstanceOf(ProcessorListener.UpdateNotification.class);
        Assertions.assertThat(notifications.get(3)).isInstanceOf(ProcessorListener.DeleteNotification.class);
        Assert.assertTrue((boolean)syncCaptor.getAllValues().stream().allMatch(s -> s == false));
    }

    @Test
    public void testSyncEvents() {
        ArgumentCaptor notificationCaptor = ArgumentCaptor.forClass(ProcessorListener.Notification.class);
        ArgumentCaptor syncCaptor = ArgumentCaptor.forClass(Boolean.class);
        Store podStore = (Store)Mockito.mock(Store.class);
        SharedProcessor processor = (SharedProcessor)Mockito.mock(SharedProcessor.class);
        ProcessorStore processorStore = new ProcessorStore(podStore, processor);
        Pod pod = ((PodBuilder)new PodBuilder().withNewMetadata().endMetadata()).build();
        Pod pod2 = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod2")).endMetadata()).build();
        processorStore.replace(Arrays.asList(pod, pod2), null);
        Mockito.when((Object)podStore.list()).thenReturn(Arrays.asList(pod, pod2));
        processorStore.resync();
        processorStore.replace(Collections.emptyList(), null);
        ((SharedProcessor)Mockito.verify((Object)processor, (VerificationMode)Mockito.times((int)6))).distribute((ProcessorListener.Notification)notificationCaptor.capture(), ((Boolean)syncCaptor.capture()).booleanValue());
        List notifications = notificationCaptor.getAllValues();
        Assertions.assertThat(notifications.get(0)).isInstanceOf(ProcessorListener.AddNotification.class);
        Assertions.assertThat(notifications.get(1)).isInstanceOf(ProcessorListener.AddNotification.class);
        Assertions.assertThat(notifications.get(2)).isInstanceOf(ProcessorListener.UpdateNotification.class);
        Assertions.assertThat(notifications.get(3)).isInstanceOf(ProcessorListener.UpdateNotification.class);
        Assert.assertTrue((boolean)syncCaptor.getAllValues().subList(0, 4).stream().allMatch(s -> s));
        Assertions.assertThat(notifications.get(4)).isInstanceOf(ProcessorListener.DeleteNotification.class);
        Assertions.assertThat(notifications.get(5)).isInstanceOf(ProcessorListener.DeleteNotification.class);
        Assert.assertTrue((boolean)syncCaptor.getAllValues().subList(4, 6).stream().allMatch(s -> s == false));
    }
}

