/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.informers.ListerWatcher;
import io.fabric8.kubernetes.client.informers.SharedInformerEventListener;
import io.fabric8.kubernetes.client.informers.cache.Controller;
import io.fabric8.kubernetes.client.informers.cache.Store;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class ControllerTest {
    private final Store<Pod> deltaFIFO = (Store)Mockito.mock(Store.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private static final Long WAIT_TIME = 500L;
    private final ListerWatcher<Pod, PodList> listerWatcher = (ListerWatcher)Mockito.mock(AbstractPodListerWatcher.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private final OperationContext operationContext = (OperationContext)Mockito.mock(OperationContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private final ConcurrentLinkedQueue<SharedInformerEventListener> eventListeners = (ConcurrentLinkedQueue)Mockito.mock(ConcurrentLinkedQueue.class, (Answer)Mockito.RETURNS_DEEP_STUBS);

    ControllerTest() {
    }

    @Test
    @DisplayName(value="Controller initialized with resync period greater than zero should use provided resync period")
    void testControllerCreationWithResyncPeriodMoreThanZero() {
        Controller controller = new Controller(Pod.class, this.deltaFIFO, this.listerWatcher, () -> true, 1000L, this.operationContext, this.eventListeners);
        Assertions.assertEquals((long)1000L, (long)controller.getFullResyncPeriod());
    }

    @Test
    @DisplayName(value="Controller initialized with resync period less than zero should throw exception")
    void testControllerCreationWithResyncPeriodLessThanZero() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Controller(Pod.class, this.deltaFIFO, this.listerWatcher, () -> true, -1000L, this.operationContext, this.eventListeners));
    }

    @Test
    @DisplayName(value="Controller initialized with resync period 0 should use provided resync period")
    void testControllerCreationWithResyncPeriodZero() {
        Controller controller = new Controller(Pod.class, this.deltaFIFO, this.listerWatcher, () -> true, 0L, this.operationContext, this.eventListeners);
        Assertions.assertEquals((long)0L, (long)controller.getFullResyncPeriod());
    }

    @Test
    @DisplayName(value="Controller stop shut downs/cancels all executor services")
    void testStop() {
        Controller controller = new Controller(Pod.class, this.deltaFIFO, this.listerWatcher, () -> true, 1000L, this.operationContext, this.eventListeners);
        controller.stop();
        AssertionsForClassTypes.assertThat((boolean)controller.getResyncExecutor().isShutdown()).isTrue();
    }

    @Test
    @DisplayName(value="Controller initialized with resync period should have synced")
    void testControllerHasSync() {
        Controller controller = new Controller(Pod.class, this.deltaFIFO, this.listerWatcher, () -> true, 10L, this.operationContext, this.eventListeners);
        Thread controllerThread = this.newControllerThread((Controller<Pod, PodList>)controller);
        controllerThread.start();
        ScheduledExecutorService resyncExecutor = controller.getResyncExecutor();
        Assertions.assertNotNull((Object)resyncExecutor);
        AssertionsForClassTypes.assertThat((boolean)controller.hasSynced()).isFalse();
        AssertionsForClassTypes.assertThat((String)controller.lastSyncResourceVersion()).isNull();
    }

    @Test
    @DisplayName(value="Controller with interrupted thread should not shutdown resyncExecutor")
    void testControllerRunWithInterruptedThread() throws InterruptedException {
        Thread controllerThread;
        ThreadWrapper controllerThreadWrapper = new ThreadWrapper();
        long fullResyncPeriod = 1L;
        int numberOfResyncs = 1;
        CountDownLatch countDown = new CountDownLatch(numberOfResyncs);
        Controller controller = new Controller(Pod.class, this.deltaFIFO, this.listerWatcher, () -> {
            controllerThreadWrapper.interrupt();
            return true;
        }, fullResyncPeriod, this.operationContext, this.eventListeners);
        controllerThreadWrapper.thread = controllerThread = this.newControllerThread((Controller<Pod, PodList>)controller);
        controllerThread.start();
        countDown.await(WAIT_TIME, TimeUnit.MILLISECONDS);
        ScheduledExecutorService resyncExecutor = controller.getResyncExecutor();
        Assertions.assertNotNull((Object)resyncExecutor);
        AssertionsForClassTypes.assertThat((boolean)resyncExecutor.isShutdown()).isFalse();
    }

    @Test
    @DisplayName(value="Controller initialized with resync period should initialize resyncExecutor")
    void testControllerRunWithResyncPeriodGreaterThanZero() throws InterruptedException {
        Controller controller = new Controller(Pod.class, this.deltaFIFO, this.listerWatcher, () -> true, 1L, this.operationContext, this.eventListeners);
        Thread controllerThread = this.newControllerThread((Controller<Pod, PodList>)controller);
        controllerThread.start();
        controller.stop();
        ScheduledExecutorService resyncExecutor = controller.getResyncExecutor();
        Assertions.assertNotNull((Object)resyncExecutor);
        AssertionsForClassTypes.assertThat((boolean)resyncExecutor.isShutdown()).isTrue();
    }

    @Test
    @DisplayName(value="Controller with resync function throwing exception")
    void testControllerRunsResyncFunctionThrowingException() throws InterruptedException {
        long fullResyncPeriod = 10L;
        int numberOfResyncs = 10;
        CountDownLatch countDown = new CountDownLatch(numberOfResyncs);
        Controller controller = new Controller(Pod.class, this.deltaFIFO, this.listerWatcher, () -> {
            countDown.countDown();
            if (countDown.getCount() == 2L) {
                throw new RuntimeException("make it fail");
            }
            return true;
        }, fullResyncPeriod, this.operationContext, this.eventListeners);
        Executable controllerRun = this.newControllerRun((Controller<Pod, PodList>)controller);
        Assertions.assertDoesNotThrow((Executable)controllerRun);
        countDown.await(WAIT_TIME, TimeUnit.MILLISECONDS);
        controller.stop();
        AssertionsForClassTypes.assertThat((long)countDown.getCount()).isLessThanOrEqualTo(2L);
    }

    @Test
    @DisplayName(value="Controller initialized with resync period should initialize resyncExecutor")
    void testControllerRunWithResyncPeriodGreaterThanZeroAndExecutorNotShutdown() throws InterruptedException {
        Controller controller = new Controller(Pod.class, this.deltaFIFO, this.listerWatcher, () -> true, 1L, this.operationContext, this.eventListeners);
        Executable controllerRun = this.newControllerRun((Controller<Pod, PodList>)controller);
        Assertions.assertDoesNotThrow((Executable)controllerRun);
        ScheduledExecutorService resyncExecutor = controller.getResyncExecutor();
        Assertions.assertNotNull((Object)resyncExecutor);
        AssertionsForClassTypes.assertThat((boolean)resyncExecutor.isShutdown()).isFalse();
    }

    @Test
    @DisplayName(value="Controller initialized with resync period should initialize resyncExecutor")
    void testControllerRunWithResyncPeriodGreaterThanZeroAndExecutorForcedShutdown() throws InterruptedException {
        Controller controller = new Controller(Pod.class, this.deltaFIFO, this.listerWatcher, () -> true, 1L, this.operationContext, this.eventListeners);
        Executable controllerRun = this.newControllerRun((Controller<Pod, PodList>)controller);
        Assertions.assertDoesNotThrow((Executable)controllerRun);
        ScheduledExecutorService resyncExecutor = controller.getResyncExecutor();
        Assertions.assertNotNull((Object)resyncExecutor);
        resyncExecutor.shutdown();
        AssertionsForClassTypes.assertThat((boolean)resyncExecutor.isShutdown()).isTrue();
    }

    @Test
    @DisplayName(value="Controller initialized with resync period to 0 should initialize resyncExecutor")
    void testControllerRunWithResyncPeriodToZero() throws InterruptedException {
        Controller controller = new Controller(Pod.class, this.deltaFIFO, this.listerWatcher, () -> true, 0L, this.operationContext, this.eventListeners);
        Thread controllerThread = this.newControllerThread((Controller<Pod, PodList>)controller);
        controllerThread.start();
        controller.stop();
        ScheduledExecutorService resyncExecutor = controller.getResyncExecutor();
        Assertions.assertNotNull((Object)resyncExecutor);
        AssertionsForClassTypes.assertThat((boolean)resyncExecutor.isShutdown()).isTrue();
        AssertionsForClassTypes.assertThat((boolean)resyncExecutor.isTerminated()).isTrue();
    }

    @Test
    @DisplayName(value="Controller initialized with resync period should run, initialize resyncExecutor and resync at least a given number of times")
    void testControllerRunsReyncFunctionExpectedNumberOfTime() throws InterruptedException {
        long fullResyncPeriod = 10L;
        int numberOfResyncs = 10;
        CountDownLatch countDown = new CountDownLatch(numberOfResyncs);
        Controller controller = new Controller(Pod.class, this.deltaFIFO, this.listerWatcher, () -> {
            countDown.countDown();
            return true;
        }, fullResyncPeriod, this.operationContext, this.eventListeners);
        Executable controllerRun = this.newControllerRun((Controller<Pod, PodList>)controller);
        Assertions.assertDoesNotThrow((Executable)controllerRun);
        countDown.await(WAIT_TIME, TimeUnit.MILLISECONDS);
        controller.stop();
        ScheduledExecutorService resyncExecutor = controller.getResyncExecutor();
        Assertions.assertNotNull((Object)resyncExecutor);
        AssertionsForClassTypes.assertThat((boolean)resyncExecutor.isShutdown()).isTrue();
        AssertionsForClassTypes.assertThat((long)countDown.getCount()).isLessThanOrEqualTo(1L);
    }

    @Test
    @DisplayName(value="Controller initialized with resync period to 0 should run but never resync")
    void testControllerNeverRunsReyncFunctionWhenPeriodIsZero() throws InterruptedException {
        int count = 10;
        CountDownLatch countDown = new CountDownLatch(count);
        Controller controller = new Controller(Pod.class, this.deltaFIFO, this.listerWatcher, () -> {
            countDown.countDown();
            return true;
        }, 0L, this.operationContext, this.eventListeners);
        Executable controllerRun = this.newControllerRun((Controller<Pod, PodList>)controller);
        Assertions.assertDoesNotThrow((Executable)controllerRun);
        countDown.await(1000L, TimeUnit.MILLISECONDS);
        controller.stop();
        ScheduledExecutorService resyncExecutor = controller.getResyncExecutor();
        Assertions.assertNotNull((Object)resyncExecutor);
        AssertionsForClassTypes.assertThat((boolean)resyncExecutor.isShutdown()).isTrue();
        AssertionsForClassTypes.assertThat((long)countDown.getCount()).isEqualTo((long)count);
    }

    private Executable newControllerRun(Controller<Pod, PodList> controller) {
        return () -> {
            Thread controllerThread = this.newControllerThread(controller);
            controllerThread.start();
        };
    }

    private Thread newControllerThread(Controller<Pod, PodList> controller) {
        return new Thread(() -> controller.run());
    }

    @Test
    @DisplayName(value="Controller schedules resync tasks with fixed delay")
    void testControllerRunSchedulesResyncTaskWithFixedDelay() {
        ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Controller controller = new Controller(Pod.class, this.deltaFIFO, this.listerWatcher, () -> true, 1L, this.operationContext, this.eventListeners, scheduledExecutorService);
        controller.scheduleResync();
        ((ScheduledExecutorService)Mockito.verify((Object)scheduledExecutorService, (VerificationMode)Mockito.times((int)1))).scheduleWithFixedDelay((Runnable)ArgumentMatchers.any(), ArgumentMatchers.eq((long)1L), ArgumentMatchers.eq((long)1L), (TimeUnit)((Object)ArgumentMatchers.any()));
    }

    private static class ThreadWrapper {
        public Thread thread;

        private ThreadWrapper() {
        }

        public void interrupt() {
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }

    private static abstract class AbstractPodListerWatcher
    implements ListerWatcher<Pod, PodList> {
        private AbstractPodListerWatcher() {
        }
    }
}

