/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.base.PatchContext;
import io.fabric8.kubernetes.client.dsl.base.PatchType;
import java.io.IOException;
import java.util.Collections;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class PatchTest {
    private Call mockCall;
    private OkHttpClient mockClient;
    private KubernetesClient kubernetesClient;

    PatchTest() {
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.mockClient = (OkHttpClient)Mockito.mock(OkHttpClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://localhost:8443/")).build();
        this.mockCall = (Call)Mockito.mock(Call.class);
        Response mockResponse = new Response.Builder().request(new Request.Builder().url("http://mock").build()).protocol(Protocol.HTTP_1_1).code(200).body(ResponseBody.create((MediaType)MediaType.get((String)"application/json"), (String)"{\"metadata\":{\"name\":\"foo\"}}")).message("mock").build();
        Mockito.when((Object)this.mockCall.execute()).thenReturn((Object)mockResponse, (Object[])new Response[]{mockResponse});
        Mockito.when((Object)this.mockClient.newCall((Request)ArgumentMatchers.any())).thenReturn((Object)this.mockCall);
        this.kubernetesClient = new DefaultKubernetesClient(this.mockClient, config);
    }

    @Test
    void testJsonPatch() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).patch("{\"metadata\":{\"annotations\":{\"bob\":\"martin\"}}}");
        ((OkHttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).newCall((Request)captor.capture());
        this.assertRequest((Request)captor.getAllValues().get(0), "GET", "/api/v1/namespaces/ns1/pods/foo", null);
        this.assertRequest((Request)captor.getAllValues().get(1), "PATCH", "/api/v1/namespaces/ns1/pods/foo", null);
        this.assertBodyContentType("strategic-merge-patch+json", (Request)captor.getAllValues().get(1));
    }

    @Test
    void testJsonMergePatch() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        PatchContext patchContext = new PatchContext.Builder().withPatchType(PatchType.JSON_MERGE).build();
        ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).patch(patchContext, "{\"metadata\":{\"annotations\":{\"bob\":\"martin\"}}}");
        ((OkHttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).newCall((Request)captor.capture());
        this.assertRequest((Request)captor.getAllValues().get(0), "GET", "/api/v1/namespaces/ns1/pods/foo", null);
        this.assertRequest((Request)captor.getAllValues().get(1), "PATCH", "/api/v1/namespaces/ns1/pods/foo", null);
        this.assertBodyContentType("merge-patch+json", (Request)captor.getAllValues().get(1));
    }

    @Test
    void testYamlPatchConvertedToJson() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).patch("metadata:\n  annotations:\n    bob: martin");
        ((OkHttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).newCall((Request)captor.capture());
        this.assertRequest((Request)captor.getAllValues().get(0), "GET", "/api/v1/namespaces/ns1/pods/foo", null);
        this.assertRequest((Request)captor.getAllValues().get(1), "PATCH", "/api/v1/namespaces/ns1/pods/foo", null);
        this.assertBodyContentType("strategic-merge-patch+json", (Request)captor.getAllValues().get(1));
    }

    @Test
    void testPatchReturnsNullWhenResourceNotFound() throws IOException {
        Mockito.when((Object)this.mockCall.execute()).thenReturn((Object)new Response.Builder().request(new Request.Builder().url("http://mock").build()).protocol(Protocol.HTTP_1_1).code(404).body(ResponseBody.create((MediaType)MediaType.get((String)"application/json"), (String)"{}")).message("mock").build());
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        Pod pod = (Pod)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).patch("{\"metadata\":{\"annotations\":{\"bob\":\"martin\"}}}");
        ((OkHttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)1))).newCall((Request)captor.capture());
        this.assertRequest((Request)captor.getValue(), "GET", "/api/v1/namespaces/ns1/pods/foo", null);
        AssertionsForInterfaceTypes.assertThat((Object)pod).isNull();
    }

    @Test
    void testJsonPatchWithPositionalArrays() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        PatchContext patchContext = new PatchContext.Builder().withPatchType(PatchType.JSON).build();
        ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).patch(patchContext, "[{\"op\": \"replace\", \"path\":\"/spec/containers/0/image\", \"value\":\"foo/gb-frontend:v4\"}]");
        ((OkHttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).newCall((Request)captor.capture());
        this.assertRequest((Request)captor.getAllValues().get(0), "GET", "/api/v1/namespaces/ns1/pods/foo", null);
        this.assertRequest((Request)captor.getAllValues().get(1), "PATCH", "/api/v1/namespaces/ns1/pods/foo", null);
        this.assertBodyContentType("json-patch+json", (Request)captor.getAllValues().get(1));
    }

    @Test
    void testPatchWithPatchOptions() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Request.class);
        ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace("ns1")).withName("foo")).patch(new PatchContext.Builder().withFieldManager("fabric8").withDryRun(Collections.singletonList("All")).build(), "{\"metadata\":{\"annotations\":{\"bob\":\"martin\"}}}");
        ((OkHttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)2))).newCall((Request)captor.capture());
        this.assertRequest((Request)captor.getAllValues().get(0), "GET", "/api/v1/namespaces/ns1/pods/foo", null);
        this.assertRequest((Request)captor.getAllValues().get(1), "PATCH", "/api/v1/namespaces/ns1/pods/foo", "fieldManager=fabric8&dryRun=All");
        this.assertBodyContentType("strategic-merge-patch+json", (Request)captor.getAllValues().get(1));
    }

    private void assertRequest(Request request, String method, String url, String queryParam) {
        AssertionsForInterfaceTypes.assertThat((String)request.url().encodedPath()).isEqualTo(url);
        AssertionsForInterfaceTypes.assertThat((String)request.method()).isEqualTo(method);
        AssertionsForInterfaceTypes.assertThat((String)request.url().encodedQuery()).isEqualTo(queryParam);
    }

    private void assertBodyContentType(String expectedContentSubtype, Request request) {
        AssertionsForClassTypes.assertThat((Object)request.body().contentType()).isNotNull();
        AssertionsForClassTypes.assertThat((String)request.body().contentType().type()).isEqualTo("application");
        AssertionsForClassTypes.assertThat((String)request.body().contentType().subtype()).isEqualTo(expectedContentSubtype);
    }
}

