
                                          

package io.fabric8.kubernetes.client.handlers.node.v1beta1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.node.v1beta1.RuntimeClassOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.node.v1beta1.RuntimeClass;
import io.fabric8.kubernetes.api.model.node.v1beta1.RuntimeClassBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class RuntimeClassHandler implements ResourceHandler<RuntimeClass, RuntimeClassBuilder> {

  @Override
  public String getKind() {
    return RuntimeClass.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "node.k8s.io/v1beta1";
      }

  @Override
  public RuntimeClass create(OkHttpClient client, Config config, String namespace, RuntimeClass item, boolean dryRun) {
    return new RuntimeClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public RuntimeClass replace(OkHttpClient client, Config config, String namespace, RuntimeClass item, boolean dryRun) {
    return new RuntimeClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public RuntimeClass reload(OkHttpClient client, Config config, String namespace, RuntimeClass item) {
    return new RuntimeClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public RuntimeClassBuilder edit(RuntimeClass item) {
    return new RuntimeClassBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, RuntimeClass item, boolean dryRun) {
    return new RuntimeClassOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

@Override
  public Watch watch(OkHttpClient client, Config config, String namespace, RuntimeClass item, Watcher<RuntimeClass> watcher) {
    return new RuntimeClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, RuntimeClass item, String resourceVersion, Watcher<RuntimeClass> watcher) {
    return new RuntimeClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, RuntimeClass item, ListOptions options, Watcher<RuntimeClass> watcher) {
    return new RuntimeClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public RuntimeClass waitUntilReady(OkHttpClient client, Config config, String namespace, RuntimeClass item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new RuntimeClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public RuntimeClass waitUntilCondition(OkHttpClient client, Config config, String namespace, RuntimeClass item, Predicate<RuntimeClass> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new RuntimeClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
