
                                          

package io.fabric8.kubernetes.client.handlers.flowcontrol.v1beta1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.flowcontrol.v1beta1.FlowSchemaOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.FlowSchema;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.FlowSchemaBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class FlowSchemaHandler implements ResourceHandler<FlowSchema, FlowSchemaBuilder> {

  @Override
  public String getKind() {
    return FlowSchema.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "flowcontrol.apiserver.k8s.io/v1beta1";
      }

  @Override
  public FlowSchema create(OkHttpClient client, Config config, String namespace, FlowSchema item, boolean dryRun) {
    return new FlowSchemaOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public FlowSchema replace(OkHttpClient client, Config config, String namespace, FlowSchema item, boolean dryRun) {
    return new FlowSchemaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public FlowSchema reload(OkHttpClient client, Config config, String namespace, FlowSchema item) {
    return new FlowSchemaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public FlowSchemaBuilder edit(FlowSchema item) {
    return new FlowSchemaBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, FlowSchema item, boolean dryRun) {
    return new FlowSchemaOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

@Override
  public Watch watch(OkHttpClient client, Config config, String namespace, FlowSchema item, Watcher<FlowSchema> watcher) {
    return new FlowSchemaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, FlowSchema item, String resourceVersion, Watcher<FlowSchema> watcher) {
    return new FlowSchemaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, FlowSchema item, ListOptions options, Watcher<FlowSchema> watcher) {
    return new FlowSchemaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public FlowSchema waitUntilReady(OkHttpClient client, Config config, String namespace, FlowSchema item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new FlowSchemaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public FlowSchema waitUntilCondition(OkHttpClient client, Config config, String namespace, FlowSchema item, Predicate<FlowSchema> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new FlowSchemaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
