
                                          

package io.fabric8.kubernetes.client.handlers.core.v1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.ServiceAccountOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ServiceAccountHandler implements ResourceHandler<ServiceAccount, ServiceAccountBuilder> {

  @Override
  public String getKind() {
    return ServiceAccount.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "v1";
      }

  @Override
  public ServiceAccount create(OkHttpClient client, Config config, String namespace, ServiceAccount item, boolean dryRun) {
    return new ServiceAccountOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public ServiceAccount replace(OkHttpClient client, Config config, String namespace, ServiceAccount item, boolean dryRun) {
    return new ServiceAccountOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public ServiceAccount reload(OkHttpClient client, Config config, String namespace, ServiceAccount item) {
    return new ServiceAccountOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ServiceAccountBuilder edit(ServiceAccount item) {
    return new ServiceAccountBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ServiceAccount item, boolean dryRun) {
    return new ServiceAccountOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

@Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ServiceAccount item, Watcher<ServiceAccount> watcher) {
    return new ServiceAccountOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ServiceAccount item, String resourceVersion, Watcher<ServiceAccount> watcher) {
    return new ServiceAccountOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ServiceAccount item, ListOptions options, Watcher<ServiceAccount> watcher) {
    return new ServiceAccountOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public ServiceAccount waitUntilReady(OkHttpClient client, Config config, String namespace, ServiceAccount item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ServiceAccountOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ServiceAccount waitUntilCondition(OkHttpClient client, Config config, String namespace, ServiceAccount item, Predicate<ServiceAccount> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ServiceAccountOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
