package io.fabric8.kubernetes.client.extended.leaderelection;

import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.time.Duration;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.Lock;

public class LeaderElectionConfigFluentImpl<A extends io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfigFluent<A> {

    private io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.Lock lock;
    private java.time.Duration leaseDuration;
    private java.time.Duration renewDeadline;
    private java.time.Duration retryPeriod;
    private io.fabric8.kubernetes.client.extended.leaderelection.LeaderCallbacks leaderCallbacks;
    private boolean releaseOnCancel;
    private java.lang.String name;

    public LeaderElectionConfigFluentImpl() {
    }

    public LeaderElectionConfigFluentImpl(io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfig instance) {
        this.withLock(instance.getLock()); 
        this.withLeaseDuration(instance.getLeaseDuration()); 
        this.withRenewDeadline(instance.getRenewDeadline()); 
        this.withRetryPeriod(instance.getRetryPeriod()); 
        this.withLeaderCallbacks(instance.getLeaderCallbacks()); 
        this.withReleaseOnCancel(instance.isReleaseOnCancel()); 
        this.withName(instance.getName()); 
    }

    public io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.Lock getLock() {
        return this.lock;
    }

    public A withLock(io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.Lock lock) {
        this.lock=lock; return (A) this;
    }

    public java.lang.Boolean hasLock() {
        return this.lock != null;
    }

    public java.time.Duration getLeaseDuration() {
        return this.leaseDuration;
    }

    public A withLeaseDuration(java.time.Duration leaseDuration) {
        this.leaseDuration=leaseDuration; return (A) this;
    }

    public java.lang.Boolean hasLeaseDuration() {
        return this.leaseDuration != null;
    }

    public java.time.Duration getRenewDeadline() {
        return this.renewDeadline;
    }

    public A withRenewDeadline(java.time.Duration renewDeadline) {
        this.renewDeadline=renewDeadline; return (A) this;
    }

    public java.lang.Boolean hasRenewDeadline() {
        return this.renewDeadline != null;
    }

    public java.time.Duration getRetryPeriod() {
        return this.retryPeriod;
    }

    public A withRetryPeriod(java.time.Duration retryPeriod) {
        this.retryPeriod=retryPeriod; return (A) this;
    }

    public java.lang.Boolean hasRetryPeriod() {
        return this.retryPeriod != null;
    }

    public io.fabric8.kubernetes.client.extended.leaderelection.LeaderCallbacks getLeaderCallbacks() {
        return this.leaderCallbacks;
    }

    public A withLeaderCallbacks(io.fabric8.kubernetes.client.extended.leaderelection.LeaderCallbacks leaderCallbacks) {
        this.leaderCallbacks=leaderCallbacks; return (A) this;
    }

    public java.lang.Boolean hasLeaderCallbacks() {
        return this.leaderCallbacks != null;
    }

    public boolean isReleaseOnCancel() {
        return this.releaseOnCancel;
    }

    public A withReleaseOnCancel(boolean releaseOnCancel) {
        this.releaseOnCancel=releaseOnCancel; return (A) this;
    }

    public java.lang.Boolean hasReleaseOnCancel() {
        return true;
    }

    public java.lang.String getName() {
        return this.name;
    }

    public A withName(java.lang.String name) {
        this.name=name; return (A) this;
    }

    public java.lang.Boolean hasName() {
        return this.name != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withName instead.
     */
        public A withNewName(java.lang.String arg0) {
        return (A)withName(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LeaderElectionConfigFluentImpl that = (LeaderElectionConfigFluentImpl) o;
        if (lock != null ? !lock.equals(that.lock) :that.lock != null) return false;
        if (leaseDuration != null ? !leaseDuration.equals(that.leaseDuration) :that.leaseDuration != null) return false;
        if (renewDeadline != null ? !renewDeadline.equals(that.renewDeadline) :that.renewDeadline != null) return false;
        if (retryPeriod != null ? !retryPeriod.equals(that.retryPeriod) :that.retryPeriod != null) return false;
        if (leaderCallbacks != null ? !leaderCallbacks.equals(that.leaderCallbacks) :that.leaderCallbacks != null) return false;
        if (releaseOnCancel != that.releaseOnCancel) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(lock,  leaseDuration,  renewDeadline,  retryPeriod,  leaderCallbacks,  releaseOnCancel,  name,  super.hashCode());
    }

}
