package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.NamedContext;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import okhttp3.TlsVersion;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class ConfigFluentImpl<A extends io.fabric8.kubernetes.client.ConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.client.ConfigFluent<A> {

    private boolean trustCerts;
    private boolean disableHostnameVerification;
    private java.lang.String masterUrl;
    private java.lang.String apiVersion;
    private java.lang.String namespace;
    private java.lang.String caCertFile;
    private java.lang.String caCertData;
    private java.lang.String clientCertFile;
    private java.lang.String clientCertData;
    private java.lang.String clientKeyFile;
    private java.lang.String clientKeyData;
    private java.lang.String clientKeyAlgo;
    private java.lang.String clientKeyPassphrase;
    private java.lang.String trustStoreFile;
    private java.lang.String trustStorePassphrase;
    private java.lang.String keyStoreFile;
    private java.lang.String keyStorePassphrase;
    private java.util.List<io.fabric8.kubernetes.api.model.NamedContext> contexts;
    private io.fabric8.kubernetes.api.model.NamedContext currentContext;
    private java.lang.String username;
    private java.lang.String password;
    private java.lang.String oauthToken;
    private int watchReconnectInterval;
    private int watchReconnectLimit;
    private int connectionTimeout;
    private int requestTimeout;
    private long rollingTimeout;
    private long scaleTimeout;
    private int loggingInterval;
    private long websocketTimeout;
    private long websocketPingInterval;
    private int maxConcurrentRequests;
    private int maxConcurrentRequestsPerHost;
    private java.lang.String impersonateUsername;
    private io.fabric8.kubernetes.client.OAuthTokenProvider oauthTokenProvider;
    private java.lang.String impersonateGroup;
    private java.util.List<java.lang.String> impersonateGroups;
    private java.util.Map<java.lang.String,java.util.List<java.lang.String>> impersonateExtras;
    private boolean http2Disable;
    private java.lang.String httpProxy;
    private java.lang.String httpsProxy;
    private java.lang.String proxyUsername;
    private java.lang.String proxyPassword;
    private java.util.List<java.lang.String> noProxy;
    private java.lang.String userAgent;
    private java.util.List<okhttp3.TlsVersion> tlsVersions;
    private java.util.Map<java.lang.Integer,java.lang.String> errorMessages;
    private java.util.Map<java.lang.String,java.lang.String> customHeaders;

    public ConfigFluentImpl() {
    }

    public ConfigFluentImpl(io.fabric8.kubernetes.client.Config instance) {
        this.withMasterUrl(instance.getMasterUrl()); 
        this.withApiVersion(instance.getApiVersion()); 
        this.withNamespace(instance.getNamespace()); 
        this.withTrustCerts(instance.isTrustCerts()); 
        this.withDisableHostnameVerification(instance.isDisableHostnameVerification()); 
        this.withCaCertFile(instance.getCaCertFile()); 
        this.withCaCertData(instance.getCaCertData()); 
        this.withClientCertFile(instance.getClientCertFile()); 
        this.withClientCertData(instance.getClientCertData()); 
        this.withClientKeyFile(instance.getClientKeyFile()); 
        this.withClientKeyData(instance.getClientKeyData()); 
        this.withClientKeyAlgo(instance.getClientKeyAlgo()); 
        this.withClientKeyPassphrase(instance.getClientKeyPassphrase()); 
        this.withUsername(instance.getUsername()); 
        this.withPassword(instance.getPassword()); 
        this.withOauthToken(instance.getOauthToken()); 
        this.withWatchReconnectInterval(instance.getWatchReconnectInterval()); 
        this.withWatchReconnectLimit(instance.getWatchReconnectLimit()); 
        this.withConnectionTimeout(instance.getConnectionTimeout()); 
        this.withRequestTimeout(instance.getRequestTimeout()); 
        this.withRollingTimeout(instance.getRollingTimeout()); 
        this.withScaleTimeout(instance.getScaleTimeout()); 
        this.withLoggingInterval(instance.getLoggingInterval()); 
        this.withMaxConcurrentRequests(instance.getMaxConcurrentRequests()); 
        this.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost()); 
        this.withHttp2Disable(instance.isHttp2Disable()); 
        this.withHttpProxy(instance.getHttpProxy()); 
        this.withHttpsProxy(instance.getHttpsProxy()); 
        this.withNoProxy(instance.getNoProxy()); 
        this.withErrorMessages(instance.getErrorMessages()); 
        this.withUserAgent(instance.getUserAgent()); 
        this.withTlsVersions(instance.getTlsVersions()); 
        this.withWebsocketTimeout(instance.getWebsocketTimeout()); 
        this.withWebsocketPingInterval(instance.getWebsocketPingInterval()); 
        this.withProxyUsername(instance.getProxyUsername()); 
        this.withProxyPassword(instance.getProxyPassword()); 
        this.withTrustStoreFile(instance.getTrustStoreFile()); 
        this.withTrustStorePassphrase(instance.getTrustStorePassphrase()); 
        this.withKeyStoreFile(instance.getKeyStoreFile()); 
        this.withKeyStorePassphrase(instance.getKeyStorePassphrase()); 
        this.withImpersonateUsername(instance.getImpersonateUsername()); 
        this.withImpersonateGroups(instance.getImpersonateGroups()); 
        this.withImpersonateExtras(instance.getImpersonateExtras()); 
        this.withOauthTokenProvider(instance.getOauthTokenProvider()); 
        this.withCustomHeaders(instance.getCustomHeaders()); 
        this.withContexts(instance.getContexts());
        
        this.withCurrentContext(instance.getCurrentContext());
        
        this.withImpersonateGroup(instance.getImpersonateGroup());
    }

    public boolean isTrustCerts() {
        return this.trustCerts;
    }

    public A withTrustCerts(boolean trustCerts) {
        this.trustCerts=trustCerts; return (A) this;
    }

    public java.lang.Boolean hasTrustCerts() {
        return true;
    }

    public boolean isDisableHostnameVerification() {
        return this.disableHostnameVerification;
    }

    public A withDisableHostnameVerification(boolean disableHostnameVerification) {
        this.disableHostnameVerification=disableHostnameVerification; return (A) this;
    }

    public java.lang.Boolean hasDisableHostnameVerification() {
        return true;
    }

    public java.lang.String getMasterUrl() {
        return this.masterUrl;
    }

    public A withMasterUrl(java.lang.String masterUrl) {
        this.masterUrl=masterUrl; return (A) this;
    }

    public java.lang.Boolean hasMasterUrl() {
        return this.masterUrl != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withMasterUrl instead.
     */
        public A withNewMasterUrl(java.lang.String arg0) {
        return (A)withMasterUrl(new String(arg0));
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0) {
        return (A)withApiVersion(new String(arg0));
    }

    public java.lang.String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(java.lang.String namespace) {
        this.namespace=namespace; return (A) this;
    }

    public java.lang.Boolean hasNamespace() {
        return this.namespace != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withNamespace instead.
     */
        public A withNewNamespace(java.lang.String arg0) {
        return (A)withNamespace(new String(arg0));
    }

    public java.lang.String getCaCertFile() {
        return this.caCertFile;
    }

    public A withCaCertFile(java.lang.String caCertFile) {
        this.caCertFile=caCertFile; return (A) this;
    }

    public java.lang.Boolean hasCaCertFile() {
        return this.caCertFile != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withCaCertFile instead.
     */
        public A withNewCaCertFile(java.lang.String arg0) {
        return (A)withCaCertFile(new String(arg0));
    }

    public java.lang.String getCaCertData() {
        return this.caCertData;
    }

    public A withCaCertData(java.lang.String caCertData) {
        this.caCertData=caCertData; return (A) this;
    }

    public java.lang.Boolean hasCaCertData() {
        return this.caCertData != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withCaCertData instead.
     */
        public A withNewCaCertData(java.lang.String arg0) {
        return (A)withCaCertData(new String(arg0));
    }

    public java.lang.String getClientCertFile() {
        return this.clientCertFile;
    }

    public A withClientCertFile(java.lang.String clientCertFile) {
        this.clientCertFile=clientCertFile; return (A) this;
    }

    public java.lang.Boolean hasClientCertFile() {
        return this.clientCertFile != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientCertFile instead.
     */
        public A withNewClientCertFile(java.lang.String arg0) {
        return (A)withClientCertFile(new String(arg0));
    }

    public java.lang.String getClientCertData() {
        return this.clientCertData;
    }

    public A withClientCertData(java.lang.String clientCertData) {
        this.clientCertData=clientCertData; return (A) this;
    }

    public java.lang.Boolean hasClientCertData() {
        return this.clientCertData != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientCertData instead.
     */
        public A withNewClientCertData(java.lang.String arg0) {
        return (A)withClientCertData(new String(arg0));
    }

    public java.lang.String getClientKeyFile() {
        return this.clientKeyFile;
    }

    public A withClientKeyFile(java.lang.String clientKeyFile) {
        this.clientKeyFile=clientKeyFile; return (A) this;
    }

    public java.lang.Boolean hasClientKeyFile() {
        return this.clientKeyFile != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientKeyFile instead.
     */
        public A withNewClientKeyFile(java.lang.String arg0) {
        return (A)withClientKeyFile(new String(arg0));
    }

    public java.lang.String getClientKeyData() {
        return this.clientKeyData;
    }

    public A withClientKeyData(java.lang.String clientKeyData) {
        this.clientKeyData=clientKeyData; return (A) this;
    }

    public java.lang.Boolean hasClientKeyData() {
        return this.clientKeyData != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientKeyData instead.
     */
        public A withNewClientKeyData(java.lang.String arg0) {
        return (A)withClientKeyData(new String(arg0));
    }

    public java.lang.String getClientKeyAlgo() {
        return this.clientKeyAlgo;
    }

    public A withClientKeyAlgo(java.lang.String clientKeyAlgo) {
        this.clientKeyAlgo=clientKeyAlgo; return (A) this;
    }

    public java.lang.Boolean hasClientKeyAlgo() {
        return this.clientKeyAlgo != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientKeyAlgo instead.
     */
        public A withNewClientKeyAlgo(java.lang.String arg0) {
        return (A)withClientKeyAlgo(new String(arg0));
    }

    public java.lang.String getClientKeyPassphrase() {
        return this.clientKeyPassphrase;
    }

    public A withClientKeyPassphrase(java.lang.String clientKeyPassphrase) {
        this.clientKeyPassphrase=clientKeyPassphrase; return (A) this;
    }

    public java.lang.Boolean hasClientKeyPassphrase() {
        return this.clientKeyPassphrase != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientKeyPassphrase instead.
     */
        public A withNewClientKeyPassphrase(java.lang.String arg0) {
        return (A)withClientKeyPassphrase(new String(arg0));
    }

    public java.lang.String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public A withTrustStoreFile(java.lang.String trustStoreFile) {
        this.trustStoreFile=trustStoreFile; return (A) this;
    }

    public java.lang.Boolean hasTrustStoreFile() {
        return this.trustStoreFile != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTrustStoreFile instead.
     */
        public A withNewTrustStoreFile(java.lang.String arg0) {
        return (A)withTrustStoreFile(new String(arg0));
    }

    public java.lang.String getTrustStorePassphrase() {
        return this.trustStorePassphrase;
    }

    public A withTrustStorePassphrase(java.lang.String trustStorePassphrase) {
        this.trustStorePassphrase=trustStorePassphrase; return (A) this;
    }

    public java.lang.Boolean hasTrustStorePassphrase() {
        return this.trustStorePassphrase != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTrustStorePassphrase instead.
     */
        public A withNewTrustStorePassphrase(java.lang.String arg0) {
        return (A)withTrustStorePassphrase(new String(arg0));
    }

    public java.lang.String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public A withKeyStoreFile(java.lang.String keyStoreFile) {
        this.keyStoreFile=keyStoreFile; return (A) this;
    }

    public java.lang.Boolean hasKeyStoreFile() {
        return this.keyStoreFile != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKeyStoreFile instead.
     */
        public A withNewKeyStoreFile(java.lang.String arg0) {
        return (A)withKeyStoreFile(new String(arg0));
    }

    public java.lang.String getKeyStorePassphrase() {
        return this.keyStorePassphrase;
    }

    public A withKeyStorePassphrase(java.lang.String keyStorePassphrase) {
        this.keyStorePassphrase=keyStorePassphrase; return (A) this;
    }

    public java.lang.Boolean hasKeyStorePassphrase() {
        return this.keyStorePassphrase != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKeyStorePassphrase instead.
     */
        public A withNewKeyStorePassphrase(java.lang.String arg0) {
        return (A)withKeyStorePassphrase(new String(arg0));
    }

    public A addToContexts(int index,io.fabric8.kubernetes.api.model.NamedContext item) {
        if (this.contexts == null) {this.contexts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedContext>();}
        this.contexts.add(index, item);
        return (A)this;
    }

    public A setToContexts(int index,io.fabric8.kubernetes.api.model.NamedContext item) {
        if (this.contexts == null) {this.contexts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedContext>();}
        this.contexts.set(index, item); return (A)this;
    }

    public A addToContexts(io.fabric8.kubernetes.api.model.NamedContext... items) {
        if (this.contexts == null) {this.contexts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedContext>();}
        for (io.fabric8.kubernetes.api.model.NamedContext item : items) {this.contexts.add(item);} return (A)this;
    }

    public A addAllToContexts(java.util.Collection<io.fabric8.kubernetes.api.model.NamedContext> items) {
        if (this.contexts == null) {this.contexts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedContext>();}
        for (io.fabric8.kubernetes.api.model.NamedContext item : items) {this.contexts.add(item);} return (A)this;
    }

    public A removeFromContexts(io.fabric8.kubernetes.api.model.NamedContext... items) {
        for (io.fabric8.kubernetes.api.model.NamedContext item : items) {if (this.contexts!= null){ this.contexts.remove(item);}} return (A)this;
    }

    public A removeAllFromContexts(java.util.Collection<io.fabric8.kubernetes.api.model.NamedContext> items) {
        for (io.fabric8.kubernetes.api.model.NamedContext item : items) {if (this.contexts!= null){ this.contexts.remove(item);}} return (A)this;
    }

    public java.util.List<io.fabric8.kubernetes.api.model.NamedContext> getContexts() {
        return this.contexts;
    }

    public io.fabric8.kubernetes.api.model.NamedContext getContext(int index) {
        return this.contexts.get(index);
    }

    public io.fabric8.kubernetes.api.model.NamedContext getFirstContext() {
        return this.contexts.get(0);
    }

    public io.fabric8.kubernetes.api.model.NamedContext getLastContext() {
        return this.contexts.get(contexts.size() - 1);
    }

    public io.fabric8.kubernetes.api.model.NamedContext getMatchingContext(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedContext> predicate) {
        for (io.fabric8.kubernetes.api.model.NamedContext item: contexts) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingContext(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamedContext> predicate) {
        for (io.fabric8.kubernetes.api.model.NamedContext item: contexts) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withContexts(java.util.List<io.fabric8.kubernetes.api.model.NamedContext> contexts) {
        if (this.contexts != null) { _visitables.get("contexts").removeAll(this.contexts);}
        if (contexts != null) {this.contexts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamedContext>(); for (io.fabric8.kubernetes.api.model.NamedContext item : contexts){this.addToContexts(item);}} else { this.contexts = null;} return (A) this;
    }

    public A withContexts(io.fabric8.kubernetes.api.model.NamedContext... contexts) {
        if (this.contexts != null) {this.contexts.clear();}
        if (contexts != null) {for (io.fabric8.kubernetes.api.model.NamedContext item :contexts){ this.addToContexts(item);}} return (A) this;
    }

    public java.lang.Boolean hasContexts() {
        return contexts != null && !contexts.isEmpty();
    }

    public io.fabric8.kubernetes.api.model.NamedContext getCurrentContext() {
        return this.currentContext;
    }

    public A withCurrentContext(io.fabric8.kubernetes.api.model.NamedContext currentContext) {
        this.currentContext=currentContext; return (A) this;
    }

    public java.lang.Boolean hasCurrentContext() {
        return this.currentContext != null;
    }

    public java.lang.String getUsername() {
        return this.username;
    }

    public A withUsername(java.lang.String username) {
        this.username=username; return (A) this;
    }

    public java.lang.Boolean hasUsername() {
        return this.username != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUsername instead.
     */
        public A withNewUsername(java.lang.String arg0) {
        return (A)withUsername(new String(arg0));
    }

    public java.lang.String getPassword() {
        return this.password;
    }

    public A withPassword(java.lang.String password) {
        this.password=password; return (A) this;
    }

    public java.lang.Boolean hasPassword() {
        return this.password != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPassword instead.
     */
        public A withNewPassword(java.lang.String arg0) {
        return (A)withPassword(new String(arg0));
    }

    public java.lang.String getOauthToken() {
        return this.oauthToken;
    }

    public A withOauthToken(java.lang.String oauthToken) {
        this.oauthToken=oauthToken; return (A) this;
    }

    public java.lang.Boolean hasOauthToken() {
        return this.oauthToken != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withOauthToken instead.
     */
        public A withNewOauthToken(java.lang.String arg0) {
        return (A)withOauthToken(new String(arg0));
    }

    public int getWatchReconnectInterval() {
        return this.watchReconnectInterval;
    }

    public A withWatchReconnectInterval(int watchReconnectInterval) {
        this.watchReconnectInterval=watchReconnectInterval; return (A) this;
    }

    public java.lang.Boolean hasWatchReconnectInterval() {
        return true;
    }

    public int getWatchReconnectLimit() {
        return this.watchReconnectLimit;
    }

    public A withWatchReconnectLimit(int watchReconnectLimit) {
        this.watchReconnectLimit=watchReconnectLimit; return (A) this;
    }

    public java.lang.Boolean hasWatchReconnectLimit() {
        return true;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public A withConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout=connectionTimeout; return (A) this;
    }

    public java.lang.Boolean hasConnectionTimeout() {
        return true;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public A withRequestTimeout(int requestTimeout) {
        this.requestTimeout=requestTimeout; return (A) this;
    }

    public java.lang.Boolean hasRequestTimeout() {
        return true;
    }

    public long getRollingTimeout() {
        return this.rollingTimeout;
    }

    public A withRollingTimeout(long rollingTimeout) {
        this.rollingTimeout=rollingTimeout; return (A) this;
    }

    public java.lang.Boolean hasRollingTimeout() {
        return true;
    }

    public long getScaleTimeout() {
        return this.scaleTimeout;
    }

    public A withScaleTimeout(long scaleTimeout) {
        this.scaleTimeout=scaleTimeout; return (A) this;
    }

    public java.lang.Boolean hasScaleTimeout() {
        return true;
    }

    public int getLoggingInterval() {
        return this.loggingInterval;
    }

    public A withLoggingInterval(int loggingInterval) {
        this.loggingInterval=loggingInterval; return (A) this;
    }

    public java.lang.Boolean hasLoggingInterval() {
        return true;
    }

    public long getWebsocketTimeout() {
        return this.websocketTimeout;
    }

    public A withWebsocketTimeout(long websocketTimeout) {
        this.websocketTimeout=websocketTimeout; return (A) this;
    }

    public java.lang.Boolean hasWebsocketTimeout() {
        return true;
    }

    public long getWebsocketPingInterval() {
        return this.websocketPingInterval;
    }

    public A withWebsocketPingInterval(long websocketPingInterval) {
        this.websocketPingInterval=websocketPingInterval; return (A) this;
    }

    public java.lang.Boolean hasWebsocketPingInterval() {
        return true;
    }

    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    public A withMaxConcurrentRequests(int maxConcurrentRequests) {
        this.maxConcurrentRequests=maxConcurrentRequests; return (A) this;
    }

    public java.lang.Boolean hasMaxConcurrentRequests() {
        return true;
    }

    public int getMaxConcurrentRequestsPerHost() {
        return this.maxConcurrentRequestsPerHost;
    }

    public A withMaxConcurrentRequestsPerHost(int maxConcurrentRequestsPerHost) {
        this.maxConcurrentRequestsPerHost=maxConcurrentRequestsPerHost; return (A) this;
    }

    public java.lang.Boolean hasMaxConcurrentRequestsPerHost() {
        return true;
    }

    public java.lang.String getImpersonateUsername() {
        return this.impersonateUsername;
    }

    public A withImpersonateUsername(java.lang.String impersonateUsername) {
        this.impersonateUsername=impersonateUsername; return (A) this;
    }

    public java.lang.Boolean hasImpersonateUsername() {
        return this.impersonateUsername != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImpersonateUsername instead.
     */
        public A withNewImpersonateUsername(java.lang.String arg0) {
        return (A)withImpersonateUsername(new String(arg0));
    }

    public io.fabric8.kubernetes.client.OAuthTokenProvider getOauthTokenProvider() {
        return this.oauthTokenProvider;
    }

    public A withOauthTokenProvider(io.fabric8.kubernetes.client.OAuthTokenProvider oauthTokenProvider) {
        this.oauthTokenProvider=oauthTokenProvider; return (A) this;
    }

    public java.lang.Boolean hasOauthTokenProvider() {
        return this.oauthTokenProvider != null;
    }

    public java.lang.String getImpersonateGroup() {
        return this.impersonateGroup;
    }

    public A withImpersonateGroup(java.lang.String impersonateGroup) {
        this.impersonateGroup=impersonateGroup; return (A) this;
    }

    public java.lang.Boolean hasImpersonateGroup() {
        return this.impersonateGroup != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImpersonateGroup instead.
     */
        public A withNewImpersonateGroup(java.lang.String arg0) {
        return (A)withImpersonateGroup(new String(arg0));
    }

    public A withImpersonateGroups(java.lang.String... impersonateGroups) {
        if (this.impersonateGroups != null) {this.impersonateGroups.clear();}
        if (impersonateGroups != null) {for (java.lang.String item :impersonateGroups){ this.addToImpersonateGroups(item);}} return (A) this;
    }

    public java.lang.String[] getImpersonateGroups() {
        //This needs to work with primitives, so we use arrays.
        int size = impersonateGroups != null ? impersonateGroups.size() : 0;
        java.lang.String[] result = new java.lang.String[size];
        if (size == 0) {
           return result;
        }
        int index = 0;
        for (java.lang.String item : impersonateGroups) {
            result[index++]=item;
        }
        return result;
    }

    public A addToImpersonateGroups(int index,java.lang.String item) {
        if (this.impersonateGroups == null) {this.impersonateGroups = new java.util.ArrayList<java.lang.String>();}
        this.impersonateGroups.add(index, item);
        return (A)this;
    }

    public A setToImpersonateGroups(int index,java.lang.String item) {
        if (this.impersonateGroups == null) {this.impersonateGroups = new java.util.ArrayList<java.lang.String>();}
        this.impersonateGroups.set(index, item); return (A)this;
    }

    public A addToImpersonateGroups(java.lang.String... items) {
        if (this.impersonateGroups == null) {this.impersonateGroups = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.impersonateGroups.add(item);} return (A)this;
    }

    public A addAllToImpersonateGroups(java.util.Collection<java.lang.String> items) {
        if (this.impersonateGroups == null) {this.impersonateGroups = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.impersonateGroups.add(item);} return (A)this;
    }

    public A removeFromImpersonateGroups(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.impersonateGroups!= null){ this.impersonateGroups.remove(item);}} return (A)this;
    }

    public A removeAllFromImpersonateGroups(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.impersonateGroups!= null){ this.impersonateGroups.remove(item);}} return (A)this;
    }

    public java.lang.Boolean hasImpersonateGroups() {
        return impersonateGroups != null && !impersonateGroups.isEmpty();
    }

    public A addNewImpersonateGroup(java.lang.String arg0) {
        return (A)addToImpersonateGroups(new String(arg0));
    }

    public A addToImpersonateExtras(java.lang.String key,java.util.List<java.lang.String> value) {
        if(this.impersonateExtras == null && key != null && value != null) { this.impersonateExtras = new java.util.LinkedHashMap<java.lang.String,java.util.List<java.lang.String>>(); }
        if(key != null && value != null) {this.impersonateExtras.put(key, value);} return (A)this;
    }

    public A addToImpersonateExtras(java.util.Map<java.lang.String,java.util.List<java.lang.String>> map) {
        if(this.impersonateExtras == null && map != null) { this.impersonateExtras = new java.util.LinkedHashMap<java.lang.String,java.util.List<java.lang.String>>(); }
        if(map != null) { this.impersonateExtras.putAll(map);} return (A)this;
    }

    public A removeFromImpersonateExtras(java.lang.String key) {
        if(this.impersonateExtras == null) { return (A) this; }
        if(key != null && this.impersonateExtras != null) {this.impersonateExtras.remove(key);} return (A)this;
    }

    public A removeFromImpersonateExtras(java.util.Map<java.lang.String,java.util.List<java.lang.String>> map) {
        if(this.impersonateExtras == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.impersonateExtras != null){this.impersonateExtras.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.util.List<java.lang.String>> getImpersonateExtras() {
        return this.impersonateExtras;
    }

    public <K,V>A withImpersonateExtras(java.util.Map<java.lang.String,java.util.List<java.lang.String>> impersonateExtras) {
        if (impersonateExtras == null) { this.impersonateExtras =  null;} else {this.impersonateExtras = new java.util.LinkedHashMap<java.lang.String,java.util.List<java.lang.String>>(impersonateExtras);} return (A) this;
    }

    public java.lang.Boolean hasImpersonateExtras() {
        return this.impersonateExtras != null;
    }

    public boolean isHttp2Disable() {
        return this.http2Disable;
    }

    public A withHttp2Disable(boolean http2Disable) {
        this.http2Disable=http2Disable; return (A) this;
    }

    public java.lang.Boolean hasHttp2Disable() {
        return true;
    }

    public java.lang.String getHttpProxy() {
        return this.httpProxy;
    }

    public A withHttpProxy(java.lang.String httpProxy) {
        this.httpProxy=httpProxy; return (A) this;
    }

    public java.lang.Boolean hasHttpProxy() {
        return this.httpProxy != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withHttpProxy instead.
     */
        public A withNewHttpProxy(java.lang.String arg0) {
        return (A)withHttpProxy(new String(arg0));
    }

    public java.lang.String getHttpsProxy() {
        return this.httpsProxy;
    }

    public A withHttpsProxy(java.lang.String httpsProxy) {
        this.httpsProxy=httpsProxy; return (A) this;
    }

    public java.lang.Boolean hasHttpsProxy() {
        return this.httpsProxy != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withHttpsProxy instead.
     */
        public A withNewHttpsProxy(java.lang.String arg0) {
        return (A)withHttpsProxy(new String(arg0));
    }

    public java.lang.String getProxyUsername() {
        return this.proxyUsername;
    }

    public A withProxyUsername(java.lang.String proxyUsername) {
        this.proxyUsername=proxyUsername; return (A) this;
    }

    public java.lang.Boolean hasProxyUsername() {
        return this.proxyUsername != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withProxyUsername instead.
     */
        public A withNewProxyUsername(java.lang.String arg0) {
        return (A)withProxyUsername(new String(arg0));
    }

    public java.lang.String getProxyPassword() {
        return this.proxyPassword;
    }

    public A withProxyPassword(java.lang.String proxyPassword) {
        this.proxyPassword=proxyPassword; return (A) this;
    }

    public java.lang.Boolean hasProxyPassword() {
        return this.proxyPassword != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withProxyPassword instead.
     */
        public A withNewProxyPassword(java.lang.String arg0) {
        return (A)withProxyPassword(new String(arg0));
    }

    public A withNoProxy(java.lang.String... noProxy) {
        if (this.noProxy != null) {this.noProxy.clear();}
        if (noProxy != null) {for (java.lang.String item :noProxy){ this.addToNoProxy(item);}} return (A) this;
    }

    public java.lang.String[] getNoProxy() {
        //This needs to work with primitives, so we use arrays.
        int size = noProxy != null ? noProxy.size() : 0;
        java.lang.String[] result = new java.lang.String[size];
        if (size == 0) {
           return result;
        }
        int index = 0;
        for (java.lang.String item : noProxy) {
            result[index++]=item;
        }
        return result;
    }

    public A addToNoProxy(int index,java.lang.String item) {
        if (this.noProxy == null) {this.noProxy = new java.util.ArrayList<java.lang.String>();}
        this.noProxy.add(index, item);
        return (A)this;
    }

    public A setToNoProxy(int index,java.lang.String item) {
        if (this.noProxy == null) {this.noProxy = new java.util.ArrayList<java.lang.String>();}
        this.noProxy.set(index, item); return (A)this;
    }

    public A addToNoProxy(java.lang.String... items) {
        if (this.noProxy == null) {this.noProxy = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.noProxy.add(item);} return (A)this;
    }

    public A addAllToNoProxy(java.util.Collection<java.lang.String> items) {
        if (this.noProxy == null) {this.noProxy = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.noProxy.add(item);} return (A)this;
    }

    public A removeFromNoProxy(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.noProxy!= null){ this.noProxy.remove(item);}} return (A)this;
    }

    public A removeAllFromNoProxy(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.noProxy!= null){ this.noProxy.remove(item);}} return (A)this;
    }

    public java.lang.Boolean hasNoProxy() {
        return noProxy != null && !noProxy.isEmpty();
    }

    public A addNewNoProxy(java.lang.String arg0) {
        return (A)addToNoProxy(new String(arg0));
    }

    public java.lang.String getUserAgent() {
        return this.userAgent;
    }

    public A withUserAgent(java.lang.String userAgent) {
        this.userAgent=userAgent; return (A) this;
    }

    public java.lang.Boolean hasUserAgent() {
        return this.userAgent != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUserAgent instead.
     */
        public A withNewUserAgent(java.lang.String arg0) {
        return (A)withUserAgent(new String(arg0));
    }

    public A withTlsVersions(okhttp3.TlsVersion... tlsVersions) {
        if (this.tlsVersions != null) {this.tlsVersions.clear();}
        if (tlsVersions != null) {for (okhttp3.TlsVersion item :tlsVersions){ this.addToTlsVersions(item);}} return (A) this;
    }

    public okhttp3.TlsVersion[] getTlsVersions() {
        //This needs to work with primitives, so we use arrays.
        int size = tlsVersions != null ? tlsVersions.size() : 0;
        okhttp3.TlsVersion[] result = new okhttp3.TlsVersion[size];
        if (size == 0) {
           return result;
        }
        int index = 0;
        for (okhttp3.TlsVersion item : tlsVersions) {
            result[index++]=item;
        }
        return result;
    }

    public A addToTlsVersions(int index,okhttp3.TlsVersion item) {
        if (this.tlsVersions == null) {this.tlsVersions = new java.util.ArrayList<okhttp3.TlsVersion>();}
        this.tlsVersions.add(index, item);
        return (A)this;
    }

    public A setToTlsVersions(int index,okhttp3.TlsVersion item) {
        if (this.tlsVersions == null) {this.tlsVersions = new java.util.ArrayList<okhttp3.TlsVersion>();}
        this.tlsVersions.set(index, item); return (A)this;
    }

    public A addToTlsVersions(okhttp3.TlsVersion... items) {
        if (this.tlsVersions == null) {this.tlsVersions = new java.util.ArrayList<okhttp3.TlsVersion>();}
        for (okhttp3.TlsVersion item : items) {this.tlsVersions.add(item);} return (A)this;
    }

    public A addAllToTlsVersions(java.util.Collection<okhttp3.TlsVersion> items) {
        if (this.tlsVersions == null) {this.tlsVersions = new java.util.ArrayList<okhttp3.TlsVersion>();}
        for (okhttp3.TlsVersion item : items) {this.tlsVersions.add(item);} return (A)this;
    }

    public A removeFromTlsVersions(okhttp3.TlsVersion... items) {
        for (okhttp3.TlsVersion item : items) {if (this.tlsVersions!= null){ this.tlsVersions.remove(item);}} return (A)this;
    }

    public A removeAllFromTlsVersions(java.util.Collection<okhttp3.TlsVersion> items) {
        for (okhttp3.TlsVersion item : items) {if (this.tlsVersions!= null){ this.tlsVersions.remove(item);}} return (A)this;
    }

    public java.lang.Boolean hasTlsVersions() {
        return tlsVersions != null && !tlsVersions.isEmpty();
    }

    public A addToErrorMessages(java.lang.Integer key,java.lang.String value) {
        if(this.errorMessages == null && key != null && value != null) { this.errorMessages = new java.util.LinkedHashMap<java.lang.Integer,java.lang.String>(); }
        if(key != null && value != null) {this.errorMessages.put(key, value);} return (A)this;
    }

    public A addToErrorMessages(java.util.Map<java.lang.Integer,java.lang.String> map) {
        if(this.errorMessages == null && map != null) { this.errorMessages = new java.util.LinkedHashMap<java.lang.Integer,java.lang.String>(); }
        if(map != null) { this.errorMessages.putAll(map);} return (A)this;
    }

    public A removeFromErrorMessages(java.lang.Integer key) {
        if(this.errorMessages == null) { return (A) this; }
        if(key != null && this.errorMessages != null) {this.errorMessages.remove(key);} return (A)this;
    }

    public A removeFromErrorMessages(java.util.Map<java.lang.Integer,java.lang.String> map) {
        if(this.errorMessages == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.errorMessages != null){this.errorMessages.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.Integer,java.lang.String> getErrorMessages() {
        return this.errorMessages;
    }

    public <K,V>A withErrorMessages(java.util.Map<java.lang.Integer,java.lang.String> errorMessages) {
        if (errorMessages == null) { this.errorMessages =  null;} else {this.errorMessages = new java.util.LinkedHashMap<java.lang.Integer,java.lang.String>(errorMessages);} return (A) this;
    }

    public java.lang.Boolean hasErrorMessages() {
        return this.errorMessages != null;
    }

    public A addToCustomHeaders(java.lang.String key,java.lang.String value) {
        if(this.customHeaders == null && key != null && value != null) { this.customHeaders = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(key != null && value != null) {this.customHeaders.put(key, value);} return (A)this;
    }

    public A addToCustomHeaders(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.customHeaders == null && map != null) { this.customHeaders = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(map != null) { this.customHeaders.putAll(map);} return (A)this;
    }

    public A removeFromCustomHeaders(java.lang.String key) {
        if(this.customHeaders == null) { return (A) this; }
        if(key != null && this.customHeaders != null) {this.customHeaders.remove(key);} return (A)this;
    }

    public A removeFromCustomHeaders(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.customHeaders == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.customHeaders != null){this.customHeaders.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.String> getCustomHeaders() {
        return this.customHeaders;
    }

    public <K,V>A withCustomHeaders(java.util.Map<java.lang.String,java.lang.String> customHeaders) {
        if (customHeaders == null) { this.customHeaders =  null;} else {this.customHeaders = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(customHeaders);} return (A) this;
    }

    public java.lang.Boolean hasCustomHeaders() {
        return this.customHeaders != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ConfigFluentImpl that = (ConfigFluentImpl) o;
        if (trustCerts != that.trustCerts) return false;
        if (disableHostnameVerification != that.disableHostnameVerification) return false;
        if (masterUrl != null ? !masterUrl.equals(that.masterUrl) :that.masterUrl != null) return false;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
        if (caCertFile != null ? !caCertFile.equals(that.caCertFile) :that.caCertFile != null) return false;
        if (caCertData != null ? !caCertData.equals(that.caCertData) :that.caCertData != null) return false;
        if (clientCertFile != null ? !clientCertFile.equals(that.clientCertFile) :that.clientCertFile != null) return false;
        if (clientCertData != null ? !clientCertData.equals(that.clientCertData) :that.clientCertData != null) return false;
        if (clientKeyFile != null ? !clientKeyFile.equals(that.clientKeyFile) :that.clientKeyFile != null) return false;
        if (clientKeyData != null ? !clientKeyData.equals(that.clientKeyData) :that.clientKeyData != null) return false;
        if (clientKeyAlgo != null ? !clientKeyAlgo.equals(that.clientKeyAlgo) :that.clientKeyAlgo != null) return false;
        if (clientKeyPassphrase != null ? !clientKeyPassphrase.equals(that.clientKeyPassphrase) :that.clientKeyPassphrase != null) return false;
        if (trustStoreFile != null ? !trustStoreFile.equals(that.trustStoreFile) :that.trustStoreFile != null) return false;
        if (trustStorePassphrase != null ? !trustStorePassphrase.equals(that.trustStorePassphrase) :that.trustStorePassphrase != null) return false;
        if (keyStoreFile != null ? !keyStoreFile.equals(that.keyStoreFile) :that.keyStoreFile != null) return false;
        if (keyStorePassphrase != null ? !keyStorePassphrase.equals(that.keyStorePassphrase) :that.keyStorePassphrase != null) return false;
        if (contexts != null ? !contexts.equals(that.contexts) :that.contexts != null) return false;
        if (currentContext != null ? !currentContext.equals(that.currentContext) :that.currentContext != null) return false;
        if (username != null ? !username.equals(that.username) :that.username != null) return false;
        if (password != null ? !password.equals(that.password) :that.password != null) return false;
        if (oauthToken != null ? !oauthToken.equals(that.oauthToken) :that.oauthToken != null) return false;
        if (watchReconnectInterval != that.watchReconnectInterval) return false;
        if (watchReconnectLimit != that.watchReconnectLimit) return false;
        if (connectionTimeout != that.connectionTimeout) return false;
        if (requestTimeout != that.requestTimeout) return false;
        if (rollingTimeout != that.rollingTimeout) return false;
        if (scaleTimeout != that.scaleTimeout) return false;
        if (loggingInterval != that.loggingInterval) return false;
        if (websocketTimeout != that.websocketTimeout) return false;
        if (websocketPingInterval != that.websocketPingInterval) return false;
        if (maxConcurrentRequests != that.maxConcurrentRequests) return false;
        if (maxConcurrentRequestsPerHost != that.maxConcurrentRequestsPerHost) return false;
        if (impersonateUsername != null ? !impersonateUsername.equals(that.impersonateUsername) :that.impersonateUsername != null) return false;
        if (oauthTokenProvider != null ? !oauthTokenProvider.equals(that.oauthTokenProvider) :that.oauthTokenProvider != null) return false;
        if (impersonateGroup != null ? !impersonateGroup.equals(that.impersonateGroup) :that.impersonateGroup != null) return false;
        if (impersonateGroups != null ? !impersonateGroups.equals(that.impersonateGroups) :that.impersonateGroups != null) return false;
        if (impersonateExtras != null ? !impersonateExtras.equals(that.impersonateExtras) :that.impersonateExtras != null) return false;
        if (http2Disable != that.http2Disable) return false;
        if (httpProxy != null ? !httpProxy.equals(that.httpProxy) :that.httpProxy != null) return false;
        if (httpsProxy != null ? !httpsProxy.equals(that.httpsProxy) :that.httpsProxy != null) return false;
        if (proxyUsername != null ? !proxyUsername.equals(that.proxyUsername) :that.proxyUsername != null) return false;
        if (proxyPassword != null ? !proxyPassword.equals(that.proxyPassword) :that.proxyPassword != null) return false;
        if (noProxy != null ? !noProxy.equals(that.noProxy) :that.noProxy != null) return false;
        if (userAgent != null ? !userAgent.equals(that.userAgent) :that.userAgent != null) return false;
        if (tlsVersions != null ? !tlsVersions.equals(that.tlsVersions) :that.tlsVersions != null) return false;
        if (errorMessages != null ? !errorMessages.equals(that.errorMessages) :that.errorMessages != null) return false;
        if (customHeaders != null ? !customHeaders.equals(that.customHeaders) :that.customHeaders != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(trustCerts,  disableHostnameVerification,  masterUrl,  apiVersion,  namespace,  caCertFile,  caCertData,  clientCertFile,  clientCertData,  clientKeyFile,  clientKeyData,  clientKeyAlgo,  clientKeyPassphrase,  trustStoreFile,  trustStorePassphrase,  keyStoreFile,  keyStorePassphrase,  contexts,  currentContext,  username,  password,  oauthToken,  watchReconnectInterval,  watchReconnectLimit,  connectionTimeout,  requestTimeout,  rollingTimeout,  scaleTimeout,  loggingInterval,  websocketTimeout,  websocketPingInterval,  maxConcurrentRequests,  maxConcurrentRequestsPerHost,  impersonateUsername,  oauthTokenProvider,  impersonateGroup,  impersonateGroups,  impersonateExtras,  http2Disable,  httpProxy,  httpsProxy,  proxyUsername,  proxyPassword,  noProxy,  userAgent,  tlsVersions,  errorMessages,  customHeaders,  super.hashCode());
    }

}
